/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.Mapper4;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper119
extends Mapper4 {
    private final boolean[] reg_ram = new boolean[6];

    public Mapper119(NESCartridge cartridge, boolean revision_a) {
        super(cartridge, revision_a, false, true, 1);
        this.applyState();
    }

    @Override
    protected final void applyCHRModes() {
        if ((this.reg_8000 & 0x80) == 0) {
            this.mapCHR(2, 0, this.regs[0] >> 1, this.reg_ram[0]);
            this.mapCHR(2, 1, this.regs[1] >> 1, this.reg_ram[1]);
            for (int i = 0; i < 4; ++i) {
                this.mapCHR(1, 4 + i, this.regs[2 + i], this.reg_ram[2 + i]);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.mapCHR(1, i, this.regs[2 + i], this.reg_ram[2 + i]);
            }
            this.mapCHR(2, 2, this.regs[0] >> 1, this.reg_ram[0]);
            this.mapCHR(2, 3, this.regs[1] >> 1, this.reg_ram[1]);
        }
    }

    @Override
    protected final void writeRegister(int value) {
        int r = this.reg_8000 & 7;
        if (r > 5) {
            this.regs[r] = value;
        } else {
            this.regs[r] = value & 0x3F;
            this.reg_ram[r] = (value & 0x40) != 0;
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        ByteSerializer.serializationBooleanArray(info, this.reg_ram);
    }
}

