/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper13
extends NESMapper {
    private int chr_bank;

    public Mapper13(NESCartridge cartridge) {
        super(cartridge, 2, true);
        this.mapPRG(32, 0, 0);
        this.mapCHR(4, 0, 0);
        this.chr_bank = 0;
        this.setMirroring(0);
        this.applyState();
    }

    private final void applyState() {
        this.mapCHR(4, 1, this.chr_bank);
    }

    @Override
    public final void write(int address, int value) {
        this.chr_bank = value & 3;
        this.applyState();
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.chr_bank = ByteSerializer.serializationInt(info, this.chr_bank);
    }
}

