/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper16
extends NESMapper {
    private final int[] chr_banks = new int[8];
    private int prg_bank;
    private int mirroring;
    private int irq_counter;
    private boolean irq_dec;

    public Mapper16(NESCartridge cartridge) {
        super(cartridge, 1, false, true, false);
        this.mapPRG(16, 1, -1);
        this.applyState();
    }

    private void applyState() {
        this.mapPRG(16, 0, this.prg_bank);
        this.mapCHR(1, 0, this.chr_banks[0]);
        this.mapCHR(1, 1, this.chr_banks[1]);
        this.mapCHR(1, 2, this.chr_banks[2]);
        this.mapCHR(1, 3, this.chr_banks[3]);
        this.mapCHR(1, 4, this.chr_banks[4]);
        this.mapCHR(1, 5, this.chr_banks[5]);
        this.mapCHR(1, 6, this.chr_banks[6]);
        this.mapCHR(1, 7, this.chr_banks[7]);
        this.setMirroring(this.mirroring);
    }

    @Override
    public final void writeSRAM(int address, int value) {
        this.writeRegister(address, value);
    }

    @Override
    public final void writePRGROM(int address, int value) {
        this.writeRegister(address, value);
    }

    private final void writeRegister(int address, int value) {
        int r = address & 0xF;
        if (r < 8) {
            this.chr_banks[r] = value;
        } else if (r == 8) {
            this.prg_bank = value & 0xF;
        } else if (r == 9) {
            switch (value & 3) {
                case 0: {
                    this.mirroring = 0;
                    break;
                }
                case 1: {
                    this.mirroring = 1;
                    break;
                }
                case 2: {
                    this.mirroring = 2;
                    break;
                }
                case 3: {
                    this.mirroring = 3;
                }
            }
        } else if (r == 10) {
            this.irq_dec = (value & 1) == 1;
            this.cartridge.nes.cpu.setIRQ(1, false);
        } else if (r == 11) {
            this.irq_counter = this.irq_counter & 0xFF00 | value;
        } else if (r == 12) {
            this.irq_counter = this.irq_counter & 0xFF | value << 8;
        }
        this.applyState();
    }

    @Override
    public final void CPUTick() {
        if (this.irq_dec) {
            this.irq_counter = this.irq_counter - 1 & 0xFFFF;
            if (this.irq_counter == 65535) {
                this.cartridge.nes.cpu.setIRQ(1, true);
            }
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        ByteSerializer.serializationIntArray(info, this.chr_banks);
        this.prg_bank = ByteSerializer.serializationInt(info, this.prg_bank);
        this.mirroring = ByteSerializer.serializationInt(info, this.mirroring);
        this.irq_counter = ByteSerializer.serializationInt(info, this.irq_counter);
        this.irq_dec = ByteSerializer.serializationBoolean(info, this.irq_dec);
    }
}

