/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper163
extends NESMapper {
    private final int[] regs = new int[2];
    private boolean scanline_top;
    private boolean reset_chr;
    private int prg_bank;
    private int security;
    private int trigger;
    private int strobe;

    public Mapper163(NESCartridge cartridge) {
        super(cartridge, 1, true, false, true);
        this.regs[0] = 255;
        this.strobe = 255;
        this.security = 4;
        this.scanline_top = true;
        this.reset_chr = true;
        this.applyState();
    }

    private void applyState() {
        this.mapPRG(32, 0, this.prg_bank);
        if (this.reset_chr) {
            this.reset_chr = false;
            this.mapCHR(8, 0, 0);
        }
    }

    @Override
    public final void writeCartRAM(int address, int value) {
        if (address < 20480) {
            return;
        }
        if (address == 20737) {
            int add = this.strobe;
            this.strobe = value;
            if (add != 0 && value == 0) {
                this.trigger = (this.trigger ^ 0xFF) & 0xFF;
            }
            return;
        }
        if (address == 20736) {
            if (value == 6) {
                this.prg_bank = 3;
            }
            this.applyState();
            return;
        }
        if ((address &= 0x7300) == 20480 || address == 20992) {
            this.regs[address >> 9 & 1] = value;
            this.prg_bank = (this.regs[0] & 0xF | this.regs[1] << 4 & 0xFF) & 0xFF;
            if ((address & 0x300 | this.regs[0] & 0x80) == 0) {
                this.reset_chr = true;
            }
        } else if (address == 21248) {
            this.security = value;
            return;
        }
        this.applyState();
    }

    @Override
    public final int readCartRAM(int address) {
        if (address < 20480) {
            return 0;
        }
        if ((address &= 0x7700) == 20480) {
            return 4;
        }
        if (address == 20736) {
            return this.security;
        }
        if (address == 21760) {
            return this.security & this.trigger;
        }
        return 0;
    }

    @Override
    public final void PPUTick() {
        boolean bl = this.scanline_top = this.ppu.scanline <= 128;
        if ((this.regs[0] & 0x80) != 0 && this.ppu.is_rendering) {
            switch (this.ppu.scanline) {
                case 128: {
                    this.mapCHR(4, 0, 1);
                    this.mapCHR(4, 1, 1);
                    break;
                }
                case 239: {
                    this.mapCHR(4, 0, 0);
                    this.mapCHR(4, 1, 0);
                }
            }
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        ByteSerializer.serializationIntArray(info, this.regs);
        this.scanline_top = ByteSerializer.serializationBoolean(info, this.scanline_top);
        this.reset_chr = ByteSerializer.serializationBoolean(info, this.reset_chr);
        this.prg_bank = ByteSerializer.serializationInt(info, this.prg_bank);
        this.security = ByteSerializer.serializationInt(info, this.security);
        this.trigger = ByteSerializer.serializationInt(info, this.trigger);
        this.strobe = ByteSerializer.serializationInt(info, this.strobe);
    }
}

