/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper18
extends NESMapper {
    private final int[] prg_banks;
    private final int[] chr_banks;
    private int irq_mask;
    private int irq_const_mask;
    private boolean irq_dec;
    private int irq_reload;
    private int irq_counter;

    public Mapper18(NESCartridge cartridge) {
        super(cartridge, 1, false, true, false);
        this.mapPRG(8, 3, -1);
        this.prg_banks = new int[3];
        this.chr_banks = new int[8];
        this.applyState();
    }

    private void applyState() {
        this.mapPRG(8, 0, this.prg_banks[0]);
        this.mapPRG(8, 1, this.prg_banks[1]);
        this.mapPRG(8, 2, this.prg_banks[2]);
        this.mapCHR(1, 0, this.chr_banks[0]);
        this.mapCHR(1, 1, this.chr_banks[1]);
        this.mapCHR(1, 2, this.chr_banks[2]);
        this.mapCHR(1, 3, this.chr_banks[3]);
        this.mapCHR(1, 4, this.chr_banks[4]);
        this.mapCHR(1, 5, this.chr_banks[5]);
        this.mapCHR(1, 6, this.chr_banks[6]);
        this.mapCHR(1, 7, this.chr_banks[7]);
    }

    @Override
    public final void writePRGROM(int address, int value) {
        block0 : switch (address) {
            case 32768: {
                this.setBank(this.prg_banks, false, 0, value);
                break;
            }
            case 32769: {
                this.setBank(this.prg_banks, true, 0, value);
                break;
            }
            case 32770: {
                this.setBank(this.prg_banks, false, 1, value);
                break;
            }
            case 32771: {
                this.setBank(this.prg_banks, true, 1, value);
                break;
            }
            case 36864: {
                this.setBank(this.prg_banks, false, 2, value);
                break;
            }
            case 36865: {
                this.setBank(this.prg_banks, true, 2, value);
                break;
            }
            case 40960: {
                this.setBank(this.chr_banks, false, 0, value);
                break;
            }
            case 40961: {
                this.setBank(this.chr_banks, true, 0, value);
                break;
            }
            case 40962: {
                this.setBank(this.chr_banks, false, 1, value);
                break;
            }
            case 40963: {
                this.setBank(this.chr_banks, true, 1, value);
                break;
            }
            case 45056: {
                this.setBank(this.chr_banks, false, 2, value);
                break;
            }
            case 45057: {
                this.setBank(this.chr_banks, true, 2, value);
                break;
            }
            case 45058: {
                this.setBank(this.chr_banks, false, 3, value);
                break;
            }
            case 45059: {
                this.setBank(this.chr_banks, true, 3, value);
                break;
            }
            case 49152: {
                this.setBank(this.chr_banks, false, 4, value);
                break;
            }
            case 49153: {
                this.setBank(this.chr_banks, true, 4, value);
                break;
            }
            case 49154: {
                this.setBank(this.chr_banks, false, 5, value);
                break;
            }
            case 49155: {
                this.setBank(this.chr_banks, true, 5, value);
                break;
            }
            case 53248: {
                this.setBank(this.chr_banks, false, 6, value);
                break;
            }
            case 53249: {
                this.setBank(this.chr_banks, true, 6, value);
                break;
            }
            case 53250: {
                this.setBank(this.chr_banks, false, 7, value);
                break;
            }
            case 53251: {
                this.setBank(this.chr_banks, true, 7, value);
                break;
            }
            case 57344: {
                this.irq_reload = this.irq_reload & 0xFFF0 | value & 0xF;
                break;
            }
            case 57345: {
                this.irq_reload = this.irq_reload & 0xFF0F | (value & 0xF) << 4;
                break;
            }
            case 57346: {
                this.irq_reload = this.irq_reload & 0xF0FF | (value & 0xF) << 8;
                break;
            }
            case 57347: {
                this.irq_reload = this.irq_reload & 0xFFF | (value & 0xF) << 12;
                break;
            }
            case 61440: {
                this.irq_counter = this.irq_reload;
                this.cartridge.nes.cpu.setIRQ(1, false);
                break;
            }
            case 61441: {
                this.irq_dec = (value & 1) != 0;
                switch ((value & 0xE) >> 1) {
                    case 0: {
                        this.irq_mask = 65535;
                        break;
                    }
                    case 1: {
                        this.irq_mask = 4095;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.irq_mask = 255;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.irq_mask = 15;
                    }
                }
                this.irq_const_mask = ~this.irq_mask & 0xFFFF;
                this.cartridge.nes.cpu.setIRQ(1, false);
                break;
            }
            case 61442: {
                switch (value & 3) {
                    case 0: {
                        this.setMirroring(1);
                        break block0;
                    }
                    case 1: {
                        this.setMirroring(0);
                        break block0;
                    }
                    case 2: {
                        this.setMirroring(3);
                        break block0;
                    }
                    case 3: {
                        this.setMirroring(2);
                    }
                }
            }
        }
        this.applyState();
    }

    private final void setBank(int[] regs, boolean high, int bank, int value) {
        regs[bank] = high ? regs[bank] & 0xF | (value & 0xF) << 4 : regs[bank] & 0xF0 | value & 0xF;
    }

    @Override
    public final void CPUTick() {
        if (this.irq_dec) {
            int c = this.irq_counter & this.irq_mask;
            this.irq_counter = this.irq_counter & this.irq_const_mask | c - 1 & this.irq_mask;
            if (c == 0) {
                this.cartridge.nes.cpu.setIRQ(1, true);
            }
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        ByteSerializer.serializationIntArray(info, this.prg_banks);
        ByteSerializer.serializationIntArray(info, this.chr_banks);
        this.irq_mask = ByteSerializer.serializationInt(info, this.irq_mask);
        this.irq_const_mask = ByteSerializer.serializationInt(info, this.irq_const_mask);
        this.irq_dec = ByteSerializer.serializationBoolean(info, this.irq_dec);
        this.irq_reload = ByteSerializer.serializationInt(info, this.irq_reload);
        this.irq_counter = ByteSerializer.serializationInt(info, this.irq_counter);
    }
}

