/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper185
extends NESMapper {
    private boolean chr_enabled;

    public Mapper185(NESCartridge cartridge) {
        super(cartridge, 1, false);
        this.mapPRG(32, 0, 0);
        this.mapCHR(8, 0, 0);
        this.chr_enabled = true;
    }

    @Override
    public final void writePRGROM(int address, int value) {
        this.chr_enabled = (value & 0xF) != 0 && value != 19;
    }

    @Override
    public int readCHR(int address) {
        if (this.chr_enabled) {
            return super.readCHR(address);
        }
        return 255;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.chr_enabled = ByteSerializer.serializationBoolean(info, this.chr_enabled);
    }
}

