/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.NESRegion;
import com.youkaicountry.anyyes.audio.IExpansionSoundChip;
import com.youkaicountry.anyyes.audio.chips.Namco163SoundChip;
import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper19
extends NESMapper {
    private final int[] prg_banks = new int[3];
    private final int[] chr_banks = new int[8];
    private final boolean[] chr_nt_ram = new boolean[8];
    private boolean mirror_mode;
    private final int[] nt_bank = new int[4];
    private final boolean[] nt_chr = new boolean[4];
    private int irq_counter;
    private boolean irq_inc;
    private final Namco163SoundChip sound;

    public Mapper19(NESCartridge cartridge) {
        super(cartridge, 1, false, true, false);
        this.mapPRG(8, 3, -1);
        this.sound = new Namco163SoundChip(NESRegion.NTSC);
        this.applyState();
    }

    private void applyState() {
        this.mapPRG(8, 0, this.prg_banks[0] & 0x3F);
        this.mapPRG(8, 1, this.prg_banks[1] & 0x3F);
        this.mapPRG(8, 2, this.prg_banks[2] & 0x3F);
        this.mapCHR(1, 0, this.chr_banks[0]);
        this.mapCHR(1, 1, this.chr_banks[1]);
        this.mapCHR(1, 2, this.chr_banks[2]);
        this.mapCHR(1, 3, this.chr_banks[3]);
        this.mapCHR(1, 4, this.chr_banks[4]);
        this.mapCHR(1, 5, this.chr_banks[5]);
        this.mapCHR(1, 6, this.chr_banks[6]);
        this.mapCHR(1, 7, this.chr_banks[7]);
        switch ((this.prg_banks[0] & 0xC0) >> 6) {
            case 0: {
                this.setMirroring(2);
            }
            case 1: {
                this.setMirroring(0);
            }
            case 2: {
                this.setMirroring(1);
            }
            case 3: {
                this.setMirroring(3);
            }
        }
    }

    @Override
    public IExpansionSoundChip[] getExpansionSoundChips() {
        return new IExpansionSoundChip[]{this.sound};
    }

    @Override
    public void writePRGROM(int address, int value) {
        if (address < 49152) {
            int r = (address - 32768) / 2048;
            if (value < 224) {
                this.chr_banks[r] = value;
                this.chr_nt_ram[r] = false;
            } else {
                boolean rom;
                boolean bl = r < 4 ? (0x40 & this.prg_banks[1]) != 0 : (rom = (0x80 & this.prg_banks[1]) != 0);
                if (rom) {
                    this.chr_banks[r] = value;
                    this.chr_nt_ram[r] = false;
                } else {
                    this.chr_banks[r] = value & 1;
                    this.chr_nt_ram[r] = true;
                }
            }
        } else if (address < 57344) {
            this.mirror_mode = true;
            int r = (address - 49152) / 2048;
            if (value < 224) {
                this.nt_bank[r] = 1024 * value % this.chr_size;
                this.nt_chr[r] = true;
            } else {
                this.nt_bank[r] = value & 1;
                this.nt_chr[r] = false;
            }
        } else if (address == 63488) {
            this.sound.writeRegister(value);
        } else if (address < 63488) {
            switch ((address - 57344) / 2048) {
                case 0: {
                    this.prg_banks[0] = value;
                    break;
                }
                case 1: {
                    this.prg_banks[1] = value;
                    break;
                }
                case 2: {
                    this.prg_banks[2] = value;
                }
            }
        }
        this.applyState();
    }

    @Override
    public void writeCartRAM(int address, int value) {
        if (address == 22528) {
            this.irq_counter = this.irq_counter & 0xFF | (value & 0x7F) << 8;
            this.irq_inc = (value & 0x80) != 0;
            this.cartridge.nes.cpu.setIRQ(1, false);
        } else if (address == 20480) {
            this.irq_counter = this.irq_counter & 0x7F00 | value;
            this.cartridge.nes.cpu.setIRQ(1, false);
        } else if (address == 18432) {
            this.sound.writeData(address, value);
        }
    }

    @Override
    public int readCartRAM(int address) {
        if (address == 22528) {
            return (this.irq_counter & 0x7F00) >> 8 | (this.irq_inc ? 1 : 0) << 7;
        }
        if (address == 20480) {
            return this.irq_counter & 0xFF;
        }
        if (address == 18432) {
            return this.sound.readData(address);
        }
        return -1;
    }

    @Override
    public int readCHR(int address) {
        int slot = address / 1024;
        if (this.chr_nt_ram[slot]) {
            return this.ciRAM[(address & 0x3FF) + this.chr_banks[slot] * 1024];
        }
        return this.cartridge.chr_rom[this.chr_map[slot] + address % 1024] & 0xFF;
    }

    @Override
    public void writeCHR(int address, int value) {
        int slot = address / 1024;
        if (this.chr_nt_ram[slot]) {
            this.ciRAM[(address & 0x3FF) + this.chr_banks[slot] * 1024] = value;
        }
    }

    @Override
    public final int readNT(int address) {
        if (!this.mirror_mode) {
            return this.ciRAM[this.mirrorNTAddr(address)];
        }
        int r = (address - 8192) / 1024;
        if (this.nt_chr[r]) {
            return this.cartridge.chr_rom[this.nt_bank[r] + (address & 0x3FF)] & 0xFF;
        }
        return this.ciRAM[(address & 0x3FF) + this.nt_bank[r] * 1024];
    }

    @Override
    public final void writeNT(int address, int value) {
        int r;
        if (!this.mirror_mode) {
            this.ciRAM[this.mirrorNTAddr((int)address)] = value;
        }
        if (!this.nt_chr[r = (address - 8192) / 1024]) {
            this.ciRAM[(address & 0x3FF) + this.nt_bank[r] * 1024] = value;
        }
    }

    @Override
    public final void CPUTick() {
        if (this.irq_inc && this.irq_counter++ == Short.MAX_VALUE) {
            this.cartridge.nes.cpu.setIRQ(1, true);
            this.irq_counter = Short.MAX_VALUE;
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        ByteSerializer.serializationIntArray(info, this.prg_banks);
        ByteSerializer.serializationIntArray(info, this.chr_banks);
        ByteSerializer.serializationBooleanArray(info, this.chr_nt_ram);
        this.mirror_mode = ByteSerializer.serializationBoolean(info, this.mirror_mode);
        ByteSerializer.serializationIntArray(info, this.nt_bank);
        ByteSerializer.serializationBooleanArray(info, this.nt_chr);
        this.irq_counter = ByteSerializer.serializationInt(info, this.irq_counter);
        this.irq_inc = ByteSerializer.serializationBoolean(info, this.irq_inc);
    }
}

