/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper2
extends NESMapper {
    private int reg;
    private final boolean uxrom;

    public Mapper2(NESCartridge cartridge) {
        super(cartridge, 1, false);
        this.uxrom = this.cartridge.prg_rom_chunk_size > 16;
        boolean v_mirror = this.mirroring == 0;
        this.setMirroring(v_mirror ? 0 : 1);
        this.mapPRG(16, 1, -1);
        this.mapCHR(8, 0, 0);
        this.applyState();
    }

    private void applyState() {
        this.mapPRG(16, 0, this.reg & (this.uxrom ? 255 : 15));
    }

    @Override
    public final void writePRGROM(int address, int value) {
        this.reg = value;
        this.applyState();
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.reg = ByteSerializer.serializationInt(info, this.reg);
    }
}

