/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper228
extends NESMapper {
    private boolean h_mirror;
    private int prg_chip;
    private int prg_page;
    private boolean prg_mode;
    private int chr_page;
    private final boolean multi_chip;

    public Mapper228(NESCartridge cartridge) {
        super(cartridge, -1, false);
        if (this.cartridge.prg_rom_chunk_size >= 32) {
            this.multi_chip = true;
            this.setPRGChipSize(524288);
        } else {
            this.multi_chip = false;
        }
        this.applyState();
    }

    private final void applyState() {
        this.setMirroring(this.h_mirror ? 1 : 0);
        if (this.multi_chip) {
            this.setPRGChip(this.prg_chip);
        }
        if (this.prg_mode) {
            this.mapPRG(16, 0, this.prg_page);
            this.mapPRG(16, 1, this.prg_page);
        } else {
            this.mapPRG(32, 0, this.prg_page / 2);
        }
        this.mapCHR(8, 0, this.chr_page);
    }

    @Override
    public final void writePRGROM(int address, int value) {
        int chip = (address & 0x1800) >> 11;
        if (chip == 2) {
            return;
        }
        if (chip == 3) {
            chip = 2;
        }
        this.prg_chip = chip;
        this.h_mirror = (address & 0x2000) != 0;
        this.prg_page = (address & 0x7C0) >> 6;
        this.prg_mode = (address & 0x20) != 0;
        this.chr_page = (address & 0xF) << 2 | value & 3;
        this.applyState();
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.h_mirror = ByteSerializer.serializationBoolean(info, this.h_mirror);
        this.prg_chip = ByteSerializer.serializationInt(info, this.prg_chip);
        this.prg_page = ByteSerializer.serializationInt(info, this.prg_page);
        this.prg_mode = ByteSerializer.serializationBoolean(info, this.prg_mode);
        this.chr_page = ByteSerializer.serializationInt(info, this.chr_page);
    }
}

