/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper232
extends NESMapper {
    private int block;
    private int page;

    public Mapper232(NESCartridge cartridge) {
        super(cartridge, 1, false);
        this.mapCHR(8, 0, 0);
        this.applyState();
    }

    private final void applyState() {
        this.mapPRG(16, 0, this.block | this.page);
        this.mapPRG(16, 1, this.block | 3);
    }

    @Override
    public final void writePRGROM(int address, int value) {
        if ((address >> 13 & 3) == 0) {
            this.block = (value & 0x18) >> 1;
        } else {
            this.page = value & 3;
        }
        this.applyState();
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.block = ByteSerializer.serializationInt(info, this.block);
        this.page = ByteSerializer.serializationInt(info, this.page);
    }
}

