/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper28
extends NESMapper {
    private final int[] regs = new int[4];
    private int reg_i;

    public Mapper28(NESCartridge cartridge) {
        super(cartridge, 1, false);
        this.regs[3] = 63;
        this.applyState();
    }

    private final void applyState() {
        this.mapCHR(8, 0, this.regs[0] & 3);
        int outer_bank = (this.regs[3] & 0x3F) << 1;
        int inner_bank = this.regs[1] & 0xF;
        int game_size = this.regs[2] >> 4 & 3;
        int mask = (2 << game_size) - 1;
        if ((this.regs[2] & 8) == 0) {
            this.mapPRG(32, 0, (outer_bank & ~mask | inner_bank << 1 & mask) / 2);
        } else if ((this.regs[2] & 4) == 0) {
            this.mapPRG(16, 0, outer_bank);
            this.mapPRG(16, 1, outer_bank & ~mask | inner_bank & mask);
        } else {
            this.mapPRG(16, 0, outer_bank & ~mask | inner_bank & mask);
            this.mapPRG(16, 1, outer_bank + 1);
        }
        switch (this.regs[2] & 3) {
            case 0: {
                this.setMirroring(2);
                break;
            }
            case 1: {
                this.setMirroring(3);
                break;
            }
            case 2: {
                this.setMirroring(0);
                break;
            }
            case 3: {
                this.setMirroring(1);
            }
        }
    }

    @Override
    public final void writeCartRAM(int address, int value) {
        if (address < 20480) {
            this.prg_ram[address - 16416] = (byte)value;
        } else {
            this.reg_i = value >> 6 & 2 | value & 1;
        }
        this.applyState();
    }

    @Override
    public final void writePRGROM(int address, int value) {
        this.regs[this.reg_i] = value;
        if ((this.reg_i == 0 || this.reg_i == 1) && (this.regs[2] & 2) == 0) {
            this.regs[2] = this.regs[2] & 0xFFFFFFFE | value >> 4 & 1;
        }
        this.applyState();
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        ByteSerializer.serializationIntArray(info, this.regs);
        this.reg_i = ByteSerializer.serializationInt(info, this.reg_i);
    }
}

