/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper3
extends NESMapper {
    private int reg;
    private final boolean prg_16k;

    public Mapper3(NESCartridge cartridge) {
        super(cartridge, 1, false);
        this.prg_16k = this.cartridge.prg_rom_chunk_size == 1;
        boolean v_mirror = this.mirroring == 0;
        this.setMirroring(v_mirror ? 0 : 1);
        this.applyState();
    }

    private final void applyState() {
        if (this.prg_16k) {
            this.mapPRG(16, 0, 0);
            this.mapPRG(16, 1, 0);
        } else {
            this.mapPRG(16, 0, 0);
            this.mapPRG(16, 1, 1);
        }
        this.mapCHR(8, 0, this.reg & 3);
    }

    @Override
    public final void write(int address, int value) {
        this.reg = value;
        this.applyState();
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.reg = ByteSerializer.serializationInt(info, this.reg);
    }
}

