/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;

class Mapper34
extends NESMapper {
    private final boolean is_nina;

    public Mapper34(NESCartridge cartridge) {
        super(cartridge, 1, false);
        this.is_nina = this.chr_size > 0;
        this.mapPRG(32, 0, 0);
    }

    @Override
    public final void writePRGROM(int address, int value) {
        if (this.is_nina) {
            return;
        }
        this.mapPRG(32, 0, value);
    }

    @Override
    public final void writeSRAM(int address, int value) {
        if (!this.is_nina) {
            super.writeSRAM(address, value);
        }
        switch (address) {
            case 32765: {
                this.mapPRG(32, 0, value);
                break;
            }
            case 32766: {
                this.mapCHR(4, 0, value & 0xF);
                break;
            }
            case 32767: {
                this.mapCHR(4, 1, value & 0xF);
            }
        }
        super.writeSRAM(address, value);
    }
}

