/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper4
extends NESMapper {
    int reg_8000;
    final int[] regs = new int[8];
    private boolean h_mirror = true;
    private int irq_period;
    private int irq_counter;
    private boolean irq_enabled = false;
    private boolean irq_reset = false;
    private final boolean irq_alt;

    public Mapper4(NESCartridge cartridge, boolean revision_a) {
        this(cartridge, revision_a, true, false, 0);
    }

    Mapper4(NESCartridge cartridge, boolean revision_a, boolean apply, boolean chr_banked_ram, int forced_chr_ram_chunks) {
        super(cartridge, 1, chr_banked_ram, forced_chr_ram_chunks, 0, false, false);
        this.irq_alt = revision_a;
        this.mapPRG(8, 3, -1);
        if (apply) {
            this.applyState();
        }
    }

    void applyState() {
        this.mapPRG(8, 1, this.regs[7]);
        if ((this.reg_8000 & 0x40) == 0) {
            this.mapPRG(8, 0, this.regs[6]);
            this.mapPRG(8, 2, -2);
        } else {
            this.mapPRG(8, 0, -2);
            this.mapPRG(8, 2, this.regs[6]);
        }
        this.applyCHRModes();
        this.applyMirroring();
    }

    private void applyMirroring() {
        this.setMirroring(this.h_mirror ? 1 : 0);
    }

    void applyCHRModes() {
        if ((this.reg_8000 & 0x80) == 0) {
            this.mapCHR(2, 0, this.regs[0] >> 1);
            this.mapCHR(2, 1, this.regs[1] >> 1);
            for (int i = 0; i < 4; ++i) {
                this.mapCHR(1, 4 + i, this.regs[2 + i]);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.mapCHR(1, i, this.regs[2 + i]);
            }
            this.mapCHR(2, 2, this.regs[0] >> 1);
            this.mapCHR(2, 3, this.regs[1] >> 1);
        }
    }

    @Override
    public final void writePRGROM(int address, int value) {
        switch (address & 0xE001) {
            case 32768: {
                this.reg_8000 = value;
                break;
            }
            case 32769: {
                this.writeRegister(value);
                break;
            }
            case 40960: {
                this.h_mirror = (value & 1) != 0;
                break;
            }
            case 49152: {
                this.irq_period = value;
                break;
            }
            case 49153: {
                if (this.irq_alt) {
                    this.irq_reset = true;
                }
                this.irq_counter = 0;
                break;
            }
            case 57344: {
                this.cartridge.nes.cpu.setIRQ(1, false);
                this.irq_enabled = false;
                break;
            }
            case 57345: {
                this.irq_enabled = true;
            }
        }
        this.applyState();
    }

    void writeRegister(int value) {
        this.regs[this.reg_8000 & 7] = value;
    }

    @Override
    public final void signalScanline() {
        int old_counter = this.irq_counter;
        this.irq_counter = this.irq_counter == 0 || this.irq_reset ? this.irq_period : --this.irq_counter;
        if ((!this.irq_alt || old_counter != 0 || this.irq_reset) && this.irq_counter == 0 && this.irq_enabled) {
            this.cartridge.nes.cpu.setIRQ(1, true);
        }
        this.irq_reset = false;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.reg_8000 = ByteSerializer.serializationInt(info, this.reg_8000);
        ByteSerializer.serializationIntArray(info, this.regs);
        this.h_mirror = ByteSerializer.serializationBoolean(info, this.h_mirror);
        this.irq_period = ByteSerializer.serializationInt(info, this.irq_period);
        this.irq_counter = ByteSerializer.serializationInt(info, this.irq_counter);
        this.irq_enabled = ByteSerializer.serializationBoolean(info, this.irq_enabled);
        this.irq_reset = ByteSerializer.serializationBoolean(info, this.irq_reset);
    }
}

