/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;
import java.util.Arrays;

public class Mapper5
extends NESMapper {
    private final byte[] exram = new byte[1024];
    private int mirroring;
    private int exram_mode;
    private int prg_mode;
    private int chr_mode;
    private final int[] prg_banks;
    private final int[] sprite_chr_banks;
    private final int[] bg_chr_banks;
    private int wram_bank;
    private int high_chr_bits;
    private int multiplicand;
    private int multiplier;
    private boolean irq_pending;
    private boolean irq_enabled;
    private int irq_scanline;
    private int scanline_cnt;
    private boolean in_frame;
    private boolean using_bg_chr;
    private int fill_tile;
    private int fill_att;
    private int exram_val;
    private boolean split_enabled;
    private boolean split_on_right;
    private int split_tile_nr;
    private int split_y_scroll;
    private int split_chr_page;

    public Mapper5(NESCartridge cartridge) {
        super(cartridge, 1, false, 0, 65536, false, true);
        Arrays.fill(this.exram, (byte)-1);
        this.prg_banks = new int[4];
        Arrays.fill(this.prg_banks, 127);
        this.sprite_chr_banks = new int[8];
        Arrays.fill(this.sprite_chr_banks, 0);
        this.bg_chr_banks = new int[4];
        Arrays.fill(this.bg_chr_banks, 0);
        this.prg_mode = 3;
        this.chr_mode = 3;
        this.wram_bank = 7;
        this.mirroring = 255;
        this.applyState();
    }

    private void applyState() {
        switch (this.prg_mode) {
            case 0: {
                this.mapPRG(32, 0, this.prg_banks[3] >> 2);
                break;
            }
            case 1: {
                this.mapPRG(16, 0, this.prg_banks[1] & 0x3F, (this.prg_banks[1] & 0x80) == 0);
                this.mapPRG(16, 1, this.prg_banks[3] >> 1);
                break;
            }
            case 2: {
                this.mapPRG(16, 0, (this.prg_banks[1] & 0x7F) >> 1, (this.prg_banks[1] & 0x80) == 0);
                this.mapPRG(8, 2, this.prg_banks[2] & 0x7F, (this.prg_banks[2] & 0x80) == 0);
                this.mapPRG(8, 3, this.prg_banks[3]);
                break;
            }
            case 3: {
                this.mapPRG(8, 0, this.prg_banks[0] & 0x7F, (this.prg_banks[0] & 0x80) == 0);
                this.mapPRG(8, 1, this.prg_banks[1] & 0x7F, (this.prg_banks[1] & 0x80) == 0);
                this.mapPRG(8, 2, this.prg_banks[2] & 0x7F, (this.prg_banks[2] & 0x80) == 0);
                this.mapPRG(8, 3, this.prg_banks[3]);
            }
        }
        if (this.using_bg_chr) {
            if (this.exram_mode != 1) {
                this.useBGCHR();
            }
        } else {
            this.useSpriteCHR();
        }
    }

    private void useSpriteCHR() {
        this.using_bg_chr = false;
        switch (this.chr_mode) {
            case 0: {
                this.mapCHR(8, 0, this.sprite_chr_banks[7]);
                break;
            }
            case 1: {
                this.mapCHR(4, 0, this.sprite_chr_banks[3]);
                this.mapCHR(4, 1, this.sprite_chr_banks[7]);
                break;
            }
            case 2: {
                this.mapCHR(2, 0, this.sprite_chr_banks[1]);
                this.mapCHR(2, 1, this.sprite_chr_banks[3]);
                this.mapCHR(2, 2, this.sprite_chr_banks[5]);
                this.mapCHR(2, 3, this.sprite_chr_banks[7]);
                break;
            }
            case 3: {
                this.mapCHR(1, 0, this.sprite_chr_banks[0]);
                this.mapCHR(1, 1, this.sprite_chr_banks[1]);
                this.mapCHR(1, 2, this.sprite_chr_banks[2]);
                this.mapCHR(1, 3, this.sprite_chr_banks[3]);
                this.mapCHR(1, 4, this.sprite_chr_banks[4]);
                this.mapCHR(1, 5, this.sprite_chr_banks[5]);
                this.mapCHR(1, 6, this.sprite_chr_banks[6]);
                this.mapCHR(1, 7, this.sprite_chr_banks[7]);
            }
        }
    }

    private void useBGCHR() {
        this.using_bg_chr = true;
        switch (this.chr_mode) {
            case 0: {
                this.mapCHR(8, 0, this.bg_chr_banks[3]);
                break;
            }
            case 1: {
                this.mapCHR(4, 0, this.bg_chr_banks[3]);
                this.mapCHR(4, 1, this.bg_chr_banks[3]);
                break;
            }
            case 2: {
                this.mapCHR(2, 0, this.bg_chr_banks[1]);
                this.mapCHR(2, 1, this.bg_chr_banks[3]);
                this.mapCHR(2, 2, this.bg_chr_banks[1]);
                this.mapCHR(2, 3, this.bg_chr_banks[3]);
                break;
            }
            case 3: {
                this.mapCHR(1, 0, this.bg_chr_banks[0]);
                this.mapCHR(1, 1, this.bg_chr_banks[1]);
                this.mapCHR(1, 2, this.bg_chr_banks[2]);
                this.mapCHR(1, 3, this.bg_chr_banks[3]);
                this.mapCHR(1, 4, this.bg_chr_banks[0]);
                this.mapCHR(1, 5, this.bg_chr_banks[1]);
                this.mapCHR(1, 6, this.bg_chr_banks[2]);
                this.mapCHR(1, 7, this.bg_chr_banks[3]);
            }
        }
    }

    @Override
    public void writeCartRAM(int address, int value) {
        if (address < 20736) {
            return;
        }
        if (address == 20736) {
            this.prg_mode = value & 3;
        } else if (address == 20737) {
            this.chr_mode = value & 3;
        } else if (address == 20740) {
            this.exram_mode = value & 3;
        } else if (address == 20741) {
            this.mirroring = value;
        } else if (address == 20742) {
            this.fill_tile = value;
        } else if (address == 20743) {
            int att_b = value & 3;
            this.fill_att = att_b << 6 | att_b << 4 | att_b << 2 | att_b;
        } else if (address == 20755) {
            this.wram_bank = value & 7;
        } else if (address >= 20756 && address <= 20759) {
            this.prg_banks[address - 20756] = value;
        } else if (address >= 20768 && address <= 20775) {
            this.sprite_chr_banks[address - 20768] = this.high_chr_bits | value;
        } else if (address >= 20776 && address <= 20779) {
            this.bg_chr_banks[address - 20776] = this.high_chr_bits | value;
        } else if (address == 20784) {
            this.high_chr_bits = (value & 3) << 6;
        } else if (address == 20992) {
            this.split_enabled = (value & 0x80) != 0;
            this.split_on_right = (value & 0x40) != 0;
            this.split_tile_nr = value & 0x1F;
        } else if (address == 20993) {
            this.split_y_scroll = value;
        } else if (address == 20994) {
            this.split_chr_page = value;
        } else if (address == 20995) {
            this.irq_scanline = value;
        } else if (address == 20996) {
            this.irq_enabled = (value & 0x80) != 0;
            this.cartridge.nes.cpu.setIRQ(1, this.irq_enabled && this.irq_pending);
        } else if (address == 20997) {
            this.multiplicand = value;
        } else if (address == 20998) {
            this.multiplier = value;
        } else if (address >= 23552 && address <= 24575) {
            switch (this.exram_mode) {
                case 0: 
                case 1: {
                    this.exram[address - 23552] = (byte)(this.in_frame ? value : 0);
                    break;
                }
                case 2: {
                    this.exram[address - 23552] = (byte)value;
                }
            }
        }
        this.applyState();
    }

    @Override
    public int readCartRAM(int address) {
        if (address == 20996) {
            int res = (this.irq_pending ? 1 : 0) << 7 | (this.in_frame ? 1 : 0) << 6 | this.cartridge.nes.cpu.data_bus & 0x3F;
            this.irq_pending = false;
            this.cartridge.nes.cpu.setIRQ(1, false);
            return res;
        }
        if (address == 20997) {
            return this.multiplicand * this.multiplier & 0xFF;
        }
        if (address == 20998) {
            return this.multiplicand * this.multiplier >> 8;
        }
        if (address >= 23552 && address <= 24575 && (this.exram_mode == 2 || this.exram_mode == 3)) {
            return this.exram[address - 23552] & 0xFF;
        }
        return this.cartridge.nes.cpu.data_bus;
    }

    @Override
    public int readNT(int address) {
        if (this.exram_mode == 1) {
            if ((~address & 0x3C0) != 0) {
                int coarse_x = address & 0x1F;
                int coarse_y = address >> 5 & 0x1F;
                this.exram_val = this.exram[32 * coarse_y + coarse_x] & 0xFF;
                int four_k_bank = this.high_chr_bits | this.exram_val & 0x3F;
                this.mapCHR(4, 0, four_k_bank);
                this.mapCHR(4, 1, four_k_bank);
            } else {
                int att_b = this.exram_val >> 6;
                return att_b << 6 | att_b << 4 | att_b << 2 | att_b;
            }
        }
        if (this.split_enabled && this.exram_mode <= 1) {
            int tile_n = ((this.ppu.dot + 1) / 8 + 2) % 40;
            if (this.split_on_right && tile_n >= this.split_tile_nr || !this.split_on_right && tile_n < this.split_tile_nr) {
                this.mapCHR(4, 0, this.split_chr_page);
                this.mapCHR(4, 1, this.split_chr_page);
                int coarse_scroll = this.split_y_scroll >> 3;
                int coarse_y = (this.ppu.scanline / 8 + coarse_scroll) % (coarse_scroll < 30 ? 30 : 32);
                address = (this.ppu.dot + 1 & 2) != 0 ? coarse_y << 5 & 0x3E0 | tile_n : 0x23C0 | coarse_y << 1 & 0x38 | tile_n >> 2;
                return this.exram[address & 0x3FF] & 0xFF;
            }
            this.useBGCHR();
        }
        int bit_off = address >> 9 & 6;
        switch (this.mirroring >> bit_off & 3) {
            case 0: {
                return this.ciRAM[address & 0x3FF];
            }
            case 1: {
                return this.ciRAM[0x400 | address & 0x3FF];
            }
            case 2: {
                return this.exram_mode <= 1 ? this.exram[address & 0x3FF] & 0xFF : 0;
            }
            case 3: {
                return (~address & 0x3C0) != 0 ? this.fill_tile : this.fill_att;
            }
        }
        return -1;
    }

    @Override
    public void writeNT(int address, int value) {
        int bit_off = address >> 9 & 6;
        switch (this.mirroring >> bit_off & 3) {
            case 0: {
                this.ciRAM[address & 0x3FF] = value;
                break;
            }
            case 1: {
                this.ciRAM[0x400 | address & 0x3FF] = value;
                break;
            }
            case 2: {
                if (this.exram_mode > 1) break;
                this.exram[address & 0x3FF] = (byte)value;
            }
        }
    }

    @Override
    public final void PPUTick() {
        if (this.ppu.scanline >= 240 && this.ppu.scanline != 261) {
            this.in_frame = false;
            if (this.using_bg_chr) {
                this.useSpriteCHR();
            }
            return;
        }
        if (!this.ppu.is_rendering) {
            return;
        }
        if (this.ppu.dot == 257) {
            this.useSpriteCHR();
        } else if (this.ppu.dot == 321) {
            this.useBGCHR();
        } else if (this.ppu.dot == 336 && (this.ppu.scanline < 240 || this.ppu.scanline == 261)) {
            if (!this.in_frame) {
                this.in_frame = true;
                this.scanline_cnt = 0;
                this.irq_pending = false;
                this.cartridge.nes.cpu.setIRQ(1, false);
            } else if (++this.scanline_cnt == this.irq_scanline) {
                this.irq_pending = true;
                if (this.irq_enabled) {
                    this.cartridge.nes.cpu.setIRQ(1, true);
                }
            }
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        ByteSerializer.serializationByteArray(info, this.exram);
        this.mirroring = ByteSerializer.serializationInt(info, this.mirroring);
        this.exram_mode = ByteSerializer.serializationInt(info, this.exram_mode);
        this.prg_mode = ByteSerializer.serializationInt(info, this.prg_mode);
        this.chr_mode = ByteSerializer.serializationInt(info, this.chr_mode);
        ByteSerializer.serializationIntArray(info, this.prg_banks);
        ByteSerializer.serializationIntArray(info, this.sprite_chr_banks);
        ByteSerializer.serializationIntArray(info, this.bg_chr_banks);
        this.wram_bank = ByteSerializer.serializationInt(info, this.wram_bank);
        this.high_chr_bits = ByteSerializer.serializationInt(info, this.high_chr_bits);
        this.multiplicand = ByteSerializer.serializationInt(info, this.multiplicand);
        this.multiplier = ByteSerializer.serializationInt(info, this.multiplier);
        this.irq_pending = ByteSerializer.serializationBoolean(info, this.irq_pending);
        this.irq_enabled = ByteSerializer.serializationBoolean(info, this.irq_enabled);
        this.irq_scanline = ByteSerializer.serializationInt(info, this.irq_scanline);
        this.scanline_cnt = ByteSerializer.serializationInt(info, this.scanline_cnt);
        this.in_frame = ByteSerializer.serializationBoolean(info, this.in_frame);
        this.using_bg_chr = ByteSerializer.serializationBoolean(info, this.using_bg_chr);
        this.fill_tile = ByteSerializer.serializationInt(info, this.fill_tile);
        this.fill_att = ByteSerializer.serializationInt(info, this.fill_att);
        this.exram_val = ByteSerializer.serializationInt(info, this.exram_val);
        this.split_enabled = ByteSerializer.serializationBoolean(info, this.split_enabled);
        this.split_on_right = ByteSerializer.serializationBoolean(info, this.split_on_right);
        this.split_tile_nr = ByteSerializer.serializationInt(info, this.split_tile_nr);
        this.split_y_scroll = ByteSerializer.serializationInt(info, this.split_y_scroll);
        this.split_chr_page = ByteSerializer.serializationInt(info, this.split_chr_page);
    }
}

