/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper66
extends NESMapper {
    private int prg_bank;
    private int chr_bank;

    public Mapper66(NESCartridge cartridge) {
        super(cartridge, -1, false);
        this.applyState();
    }

    private final void applyState() {
        this.mapPRG(32, 0, this.prg_bank);
        this.mapCHR(8, 0, this.chr_bank);
    }

    @Override
    public final void writePRGROM(int address, int value) {
        this.chr_bank = value & 3;
        this.prg_bank = (value & 0x30) >> 4;
        this.applyState();
    }

    @Override
    public final void writeSRAM(int address, int value) {
        this.chr_bank = value & 0xF;
        this.prg_bank = value >> 4;
        this.applyState();
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.prg_bank = ByteSerializer.serializationInt(info, this.prg_bank);
        this.chr_bank = ByteSerializer.serializationInt(info, this.chr_bank);
    }
}

