/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper69
extends NESMapper {
    private int command;
    private final int[] chr_bank;
    private final int[] prg_bank = new int[3];
    private int mirroring;
    private int ram_prg_bank;
    private int prg_ram_map;
    private boolean ram_enabled;
    private int irq_counter;
    private boolean irq_dec;
    private boolean irq_enable;

    public Mapper69(NESCartridge cartridge) {
        super(cartridge, 0, false, true, false);
        this.chr_bank = new int[8];
        this.mapPRG(8, 3, -1);
        this.ram_enabled = true;
        this.applyState();
    }

    private void applyState() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.mapPRG(8, i, this.prg_bank[i]);
        }
        for (i = 0; i < 8; ++i) {
            this.mapCHR(1, i, this.chr_bank[i]);
        }
        if (!this.ram_enabled) {
            this.prg_ram_map = (8192 * this.ram_prg_bank + 8192) % this.program_size;
        }
        switch (this.mirroring) {
            case 0: {
                this.setMirroring(0);
                break;
            }
            case 1: {
                this.setMirroring(1);
                break;
            }
            case 2: {
                this.setMirroring(2);
                break;
            }
            case 3: {
                this.setMirroring(3);
            }
        }
    }

    @Override
    public final void writePRGROM(int address, int value) {
        if (address < 40960) {
            this.command = value & 0xF;
        } else if (address < 49152) {
            if (this.command <= 7) {
                this.chr_bank[this.command] = value;
            } else if (this.command == 8) {
                if (value <= 127 && value >= 64) {
                    return;
                }
                this.ram_enabled = (value & 0x40) != 0;
                this.ram_prg_bank = value & 0x3F;
            } else if (this.command <= 11) {
                this.prg_bank[this.command - 9] = value & 0x3F;
            } else if (this.command == 12) {
                this.mirroring = value & 3;
            } else if (this.command <= 15) {
                if (this.command == 13) {
                    if ((value & 1) != 0) {
                        this.irq_enable = true;
                    }
                    this.irq_dec = (value & 0x80) != 0;
                    this.cartridge.nes.cpu.setIRQ(1, false);
                } else if (this.command == 14) {
                    this.irq_counter = this.irq_counter & 0xFF00 | value;
                } else if (this.command == 15) {
                    this.irq_counter = this.irq_counter & 0xFF | value << 8;
                }
            }
            this.applyState();
        }
    }

    @Override
    public final int readSRAM(int address) {
        if (this.ram_enabled) {
            return this.cartridge.readFromSRAM(address);
        }
        return this.cartridge.prg_rom[this.prg_ram_map + (address - 24576)];
    }

    @Override
    public final void CPUTick() {
        if (this.irq_dec) {
            this.irq_counter = this.irq_counter - 1 & 0xFFFF;
            if (this.irq_enable && this.irq_counter == 65535) {
                this.cartridge.nes.cpu.setIRQ(1, true);
            }
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.command = ByteSerializer.serializationInt(info, this.command);
        ByteSerializer.serializationIntArray(info, this.chr_bank);
        ByteSerializer.serializationIntArray(info, this.prg_bank);
        this.mirroring = ByteSerializer.serializationInt(info, this.mirroring);
        this.ram_prg_bank = ByteSerializer.serializationInt(info, this.ram_prg_bank);
        this.prg_ram_map = ByteSerializer.serializationInt(info, this.prg_ram_map);
        this.ram_enabled = ByteSerializer.serializationBoolean(info, this.ram_enabled);
        this.irq_counter = ByteSerializer.serializationInt(info, this.irq_counter);
        this.irq_dec = ByteSerializer.serializationBoolean(info, this.irq_dec);
        this.irq_enable = ByteSerializer.serializationBoolean(info, this.irq_enable);
    }
}

