/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper71
extends NESMapper {
    private int prg_bank;

    public Mapper71(NESCartridge cartridge) {
        super(cartridge, 1, false);
        this.mapPRG(16, 1, -1);
        this.mapCHR(8, 0, 0);
        this.prg_bank = 0;
        this.applyState();
    }

    private final void applyState() {
        this.mapPRG(16, 0, this.prg_bank);
    }

    @Override
    public void writePRGROM(int address, int value) {
        if ((~address & 0xC000) == 0) {
            this.prg_bank = value;
            this.applyState();
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.prg_bank = ByteSerializer.serializationInt(info, this.prg_bank);
    }
}

