/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.audio.IExpansionSoundChip;
import com.youkaicountry.anyyes.audio.chips.VRC7SoundChip;
import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper85
extends NESMapper {
    private int irq_counter = 0;
    private int irq_prescaler = 0;
    private int irq_reload = 0;
    private int sound_register = 0;
    private boolean irq_enabled = false;
    private boolean irq_enabled_on_ack = false;
    private boolean irq_mode = false;
    private final VRC7SoundChip sound = new VRC7SoundChip();

    public Mapper85(NESCartridge cartridge) {
        super(cartridge, 1, true, true, false);
        this.mapPRG(8, 3, -1);
        this.mapCHR(8, 0, 0);
    }

    @Override
    public IExpansionSoundChip[] getExpansionSoundChips() {
        return new IExpansionSoundChip[]{this.sound};
    }

    @Override
    public final void writePRGROM(int address, int value) {
        switch (address) {
            case 32768: {
                this.mapPRG(8, 0, value & 0x3F);
                break;
            }
            case 32776: 
            case 32784: {
                this.mapPRG(8, 1, value & 0x3F);
                break;
            }
            case 36864: {
                this.mapPRG(8, 2, value & 0x3F);
                break;
            }
            case 40960: {
                this.mapCHR(1, 0, value);
                break;
            }
            case 40968: 
            case 40976: {
                this.mapCHR(1, 1, value);
                break;
            }
            case 45056: {
                this.mapCHR(1, 2, value);
                break;
            }
            case 45064: 
            case 45072: {
                this.mapCHR(1, 3, value);
                break;
            }
            case 49152: {
                this.mapCHR(1, 4, value);
                break;
            }
            case 49160: 
            case 49168: {
                this.mapCHR(1, 5, value);
                break;
            }
            case 53248: {
                this.mapCHR(1, 6, value);
                break;
            }
            case 53256: 
            case 53264: {
                this.mapCHR(1, 7, value);
                break;
            }
            case 36880: {
                this.sound_register = value;
                break;
            }
            case 36912: {
                this.sound.write(this.sound_register, value);
                break;
            }
            case 57344: {
                switch (value & 3) {
                    case 0: {
                        this.setMirroring(0);
                        break;
                    }
                    case 1: {
                        this.setMirroring(1);
                        break;
                    }
                    case 2: {
                        this.setMirroring(2);
                        break;
                    }
                    case 3: {
                        this.setMirroring(3);
                    }
                }
                break;
            }
            case 57352: 
            case 57360: {
                this.irq_reload = value;
                this.cartridge.nes.cpu.setIRQ(1, false);
                break;
            }
            case 61440: {
                this.irq_mode = (value & 4) != 0;
                this.irq_enabled = (value & 2) != 0;
                boolean bl = this.irq_enabled_on_ack = (value & 1) != 0;
                if (this.irq_enabled) {
                    this.irq_counter = this.irq_reload;
                    this.irq_prescaler = 341;
                }
                this.cartridge.nes.cpu.setIRQ(1, false);
                break;
            }
            case 61448: 
            case 61456: {
                this.irq_enabled = this.irq_enabled_on_ack;
                this.cartridge.nes.cpu.setIRQ(1, false);
                break;
            }
            default: {
                System.out.println("MISS ON: " + Integer.toHexString(address));
            }
        }
    }

    @Override
    public final void CPUTick() {
        if (this.irq_enabled) {
            if (this.irq_mode) {
                ++this.irq_counter;
                if (this.irq_counter == 256) {
                    this.irq_counter = this.irq_reload;
                    this.cartridge.nes.cpu.setIRQ(1, true);
                }
            } else {
                this.irq_prescaler -= 3;
                if (this.irq_prescaler <= 0) {
                    this.irq_prescaler += 341;
                    ++this.irq_counter;
                    if (this.irq_counter == 256) {
                        this.irq_counter = this.irq_reload;
                        this.cartridge.nes.cpu.setIRQ(1, true);
                    }
                }
            }
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.irq_counter = ByteSerializer.serializationInt(info, this.irq_counter);
        this.irq_prescaler = ByteSerializer.serializationInt(info, this.irq_prescaler);
        this.irq_reload = ByteSerializer.serializationInt(info, this.irq_reload);
        this.sound_register = ByteSerializer.serializationInt(info, this.sound_register);
        this.irq_enabled = ByteSerializer.serializationBoolean(info, this.irq_enabled);
        this.irq_enabled_on_ack = ByteSerializer.serializationBoolean(info, this.irq_enabled_on_ack);
        this.irq_mode = ByteSerializer.serializationBoolean(info, this.irq_mode);
    }
}

