/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper9
extends NESMapper {
    private int prg_bank;
    private final int[] chr_low_bank = new int[2];
    private final int[] chr_high_bank = new int[2];
    private boolean chr_low_C;
    private boolean chr_high_E;
    private int prev_ppu;
    private boolean h_mirror;

    public Mapper9(NESCartridge cartridge) {
        super(cartridge, -1, false, false, true);
        this.mapPRG(8, 1, -3);
        this.mapPRG(8, 2, -2);
        this.mapPRG(8, 3, -1);
        this.applyState();
    }

    private final void applyState() {
        this.mapPRG(8, 0, this.prg_bank);
        this.mapCHR(4, 0, this.chr_low_bank[this.chr_low_C ? 0 : 1]);
        this.mapCHR(4, 1, this.chr_high_bank[this.chr_high_E ? 1 : 0]);
        this.setMirroring(this.h_mirror ? 1 : 0);
    }

    @Override
    public final void writePRGROM(int address, int value) {
        switch (address >> 12 & 7) {
            case 2: {
                this.prg_bank = value & 0xF;
                break;
            }
            case 3: {
                this.chr_low_bank[0] = value & 0x1F;
                break;
            }
            case 4: {
                this.chr_low_bank[1] = value & 0x1F;
                break;
            }
            case 5: {
                this.chr_high_bank[0] = value & 0x1F;
                break;
            }
            case 6: {
                this.chr_high_bank[1] = value & 0x1F;
                break;
            }
            case 7: {
                this.h_mirror = (value & 1) != 0;
            }
        }
        this.applyState();
    }

    @Override
    public final void PPUTick() {
        int magic = this.ppu.address_bus & 0x2FF8;
        if (magic != 4056 && magic != 4072) {
            if (this.prev_ppu == 4056) {
                this.chr_low_C = false;
                this.applyState();
            } else if (this.prev_ppu == 4072) {
                this.chr_low_C = true;
                this.applyState();
            } else if (this.prev_ppu >= 8152 && this.prev_ppu <= 8159) {
                this.chr_high_E = false;
                this.applyState();
            } else if (this.prev_ppu >= 8168 && this.prev_ppu <= 8175) {
                this.chr_high_E = true;
                this.applyState();
            }
        }
        this.prev_ppu = this.ppu.address_bus;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.prg_bank = ByteSerializer.serializationInt(info, this.prg_bank);
        ByteSerializer.serializationIntArray(info, this.chr_low_bank);
        ByteSerializer.serializationIntArray(info, this.chr_high_bank);
        this.chr_low_C = ByteSerializer.serializationBoolean(info, this.chr_low_C);
        this.chr_high_E = ByteSerializer.serializationBoolean(info, this.chr_high_E);
        this.prev_ppu = ByteSerializer.serializationInt(info, this.prev_ppu);
        this.h_mirror = ByteSerializer.serializationBoolean(info, this.h_mirror);
    }
}

