/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.audio.IExpansionSoundChip;
import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.video.NESPPU;
import com.youkaicountry.emucore.IMemRW;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public abstract class NESMapper
implements IMemRW,
IByteSerialize {
    final NESCartridge cartridge;
    public NESPPU ppu;
    final int[] ciRAM;
    private final int[] program_map;
    final int[] chr_map;
    private final boolean[] prg_is_ram;
    private final boolean[] chr_is_ram;
    final byte[] prg_ram;
    private final byte[] chr_ram;
    final int program_size;
    final int chr_size;
    private final int chr_ram_size;
    private final boolean chr_ram_banked;
    private final byte[] prg_banked_ram;
    private int prg_chip_size;
    private int prg_offset;
    int mirroring;
    public final boolean cpu_tick;
    public final boolean ppu_tick;

    NESMapper(NESCartridge cartridge, int blank_chr_chunk, boolean chr_ram_banked, boolean cpu_tick, boolean ppu_tick) {
        this(cartridge, blank_chr_chunk, chr_ram_banked, 0, 0, cpu_tick, ppu_tick);
    }

    NESMapper(NESCartridge cartridge, int blank_chr_chunk, boolean chr_ram_banked) {
        this(cartridge, blank_chr_chunk, chr_ram_banked, 0, 0, false, false);
    }

    NESMapper(NESCartridge cartridge, int blank_chr_chunk, boolean chr_ram_banked, int forced_chr_ram_chunks, int prg_map_ram, boolean cpu_tick, boolean ppu_tick) {
        this.chr_ram_banked = chr_ram_banked;
        this.cartridge = cartridge;
        this.program_map = new int[4];
        this.prg_is_ram = new boolean[4];
        this.chr_map = new int[8];
        this.chr_is_ram = new boolean[8];
        this.mirroring = cartridge.getWiredMirroring();
        this.cpu_tick = cpu_tick;
        this.ppu_tick = ppu_tick;
        this.program_size = cartridge.prg_rom_chunk_size * 16384;
        if (cartridge.chr_rom_chunk_size == 0) {
            this.chr_ram_size = 8192 * blank_chr_chunk;
            this.chr_ram = new byte[this.chr_ram_size];
            this.mapCHR(8, 0, 0, true);
            this.chr_size = 0;
        } else if (forced_chr_ram_chunks > 0) {
            this.chr_ram_size = 8192 * forced_chr_ram_chunks;
            this.chr_ram = new byte[this.chr_ram_size];
            this.chr_size = 8192 * cartridge.chr_rom_chunk_size;
        } else {
            this.chr_ram_size = 0;
            this.chr_size = 8192 * cartridge.chr_rom_chunk_size;
            this.chr_ram = new byte[0];
        }
        this.prg_ram = new byte[8160];
        this.ciRAM = new int[this.mirroring == 4 ? 5632 : 2048];
        this.prg_banked_ram = prg_map_ram > 0 ? new byte[prg_map_ram] : new byte[0];
    }

    final void mapPRG(int pageKBs, int slot, int bank) {
        this.mapPRG(pageKBs, slot, bank, false);
    }

    final void mapPRG(int pageKBs, int slot, int bank, boolean ram) {
        int size;
        int n = size = ram ? this.prg_banked_ram.length : this.program_size;
        if (bank < 0) {
            bank = size / (1024 * pageKBs) + bank;
        }
        for (int i = 0; i < pageKBs / 8; ++i) {
            int slot8 = pageKBs / 8 * slot + i;
            this.program_map[slot8] = (pageKBs * 1024 * bank + 8192 * i) % size;
            this.prg_is_ram[slot8] = ram;
        }
    }

    final void mapCHR(int pageKBs, int slot, int bank) {
        for (int i = 0; i < pageKBs; ++i) {
            int slot1 = pageKBs * slot + i;
            this.chr_map[slot1] = (pageKBs * 1024 * bank + 1024 * i) % (this.chr_is_ram[slot1] ? this.chr_ram_size : this.chr_size);
        }
    }

    final void mapCHR(int pageKBs, int slot, int bank, boolean is_ram) {
        int size = is_ram ? this.chr_ram_size : this.chr_size;
        for (int i = 0; i < pageKBs; ++i) {
            int slot1 = pageKBs * slot + i;
            this.chr_map[slot1] = (pageKBs * 1024 * bank + 1024 * i) % size;
            this.chr_is_ram[slot1] = is_ram;
        }
    }

    @Override
    public int read(int address) {
        if (address >= 32768) {
            return this.readPRGROM(address);
        }
        if (address < 24576) {
            return this.readCartRAM(address);
        }
        return this.readSRAM(address);
    }

    int readCartRAM(int address) {
        return this.prg_ram[address - 16416] & 0xFF;
    }

    int readSRAM(int address) {
        return this.cartridge.readFromSRAM(address);
    }

    public int readCHR(int address) {
        int slot = address / 1024;
        if (this.chr_is_ram[slot]) {
            if (this.chr_ram_banked) {
                return this.chr_ram[this.chr_map[slot] + address % 1024] & 0xFF;
            }
            return this.chr_ram[address] & 0xFF;
        }
        return this.cartridge.chr_rom[this.chr_map[slot] + address % 1024] & 0xFF;
    }

    private int readPRGROM(int address) {
        int slot = (address - 32768) / 8192;
        int i = this.program_map[slot] + (address - 32768 & 0x1FFF) + this.prg_offset;
        byte oval = this.prg_is_ram[slot] ? this.prg_banked_ram[i] : this.cartridge.prg_rom[i];
        return oval & 0xFF;
    }

    @Override
    public void write(int address, int value) {
        if (address < 24576) {
            this.writeCartRAM(address, value);
        } else if (address < 32768) {
            this.writeSRAM(address, value);
        } else if (address >= 32768) {
            this.writePRGROM(address, value);
        }
    }

    void writeCartRAM(int address, int value) {
        this.prg_ram[address - 16416] = (byte)value;
    }

    void writeSRAM(int address, int value) {
        this.cartridge.writeToSRAM(address, value);
    }

    void writePRGROM(int address, int value) {
    }

    public void writeCHR(int address, int value) {
        int slot = address / 1024;
        if (this.chr_is_ram[slot]) {
            if (this.chr_ram_banked) {
                this.chr_ram[this.chr_map[slot] + address % 1024] = (byte)value;
            } else {
                this.chr_ram[address] = (byte)value;
            }
        }
    }

    public void signalScanline() {
    }

    int mirrorNTAddr(int address) {
        switch (this.mirroring) {
            case 0: {
                return address & 0x7FF;
            }
            case 1: {
                return (address >> 1 & 0x400) + (address & 0x3FF);
            }
            case 2: {
                return address & 0x3FF;
            }
            case 3: {
                return 1024 + (address & 0x3FF);
            }
            case 4: {
                return address & 0xFFF;
            }
        }
        return -1;
    }

    final void setMirroring(int mirroring) {
        if (this.mirroring != 4) {
            this.mirroring = mirroring;
        }
    }

    public void PPUTick() {
    }

    public void CPUTick() {
    }

    public int readNT(int address) {
        return this.ciRAM[this.mirrorNTAddr(address)];
    }

    public void writeNT(int address, int value) {
        this.ciRAM[this.mirrorNTAddr((int)address)] = value;
    }

    void setPRGChipSize(int chip_size) {
        this.prg_chip_size = chip_size;
    }

    void setPRGChip(int chip) {
        this.prg_offset = this.prg_chip_size * chip;
    }

    public IExpansionSoundChip[] getExpansionSoundChips() {
        return null;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        ByteSerializer.serializationIntArray(info, this.program_map);
        ByteSerializer.serializationIntArray(info, this.chr_map);
        ByteSerializer.serializationBooleanArray(info, this.prg_is_ram);
        ByteSerializer.serializationBooleanArray(info, this.chr_is_ram);
        ByteSerializer.serializationIntArray(info, this.ciRAM);
        ByteSerializer.serializationByteArray(info, this.prg_banked_ram);
        this.prg_chip_size = ByteSerializer.serializationInt(info, this.prg_chip_size);
        this.prg_offset = ByteSerializer.serializationInt(info, this.prg_offset);
        this.mirroring = ByteSerializer.serializationInt(info, this.mirroring);
        ByteSerializer.serializationByteArray(info, this.prg_ram);
        ByteSerializer.serializationByteArray(info, this.chr_ram);
    }
}

