/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.gdx.anyyes;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.youkaicountry.anyyes.video.NESTV;
import com.youkaicountry.vnand.actors.PixelActor;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;

public abstract class GdxNESTV
extends NESTV {
    private final Stage stage;
    public final PixelActor screen;
    private boolean requires_render;
    boolean f_odd;
    private boolean updated_latch;
    private final Pixmap pixmap;
    private final int width;
    private final int height;
    private final int start_index;
    private final int end_index;
    private final Thread thread;
    private final int[] rgb_temp;
    private final ArrayBlockingQueue<int[]> buffer_pool;
    private final ArrayBlockingQueue<int[]> screen_q;

    public GdxNESTV(Stage stage, int width, int height, PixelActor screen, int pool_size) {
        this.stage = stage;
        this.width = width;
        this.height = height;
        int top_cut = (240 - height) / 2;
        int bottom_cut = 240 - (top_cut + height);
        this.start_index = 256 * top_cut;
        this.end_index = this.start_index + 256 * height;
        this.rgb_temp = new int[61440];
        this.screen = screen;
        this.pixmap = screen.getPixmap();
        this.screen_q = new ArrayBlockingQueue(pool_size, false);
        this.buffer_pool = new ArrayBlockingQueue(pool_size + 2, false);
        for (int i = 0; i < pool_size + 1; ++i) {
            this.buffer_pool.add(new int[61440]);
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!GdxNESTV.this.thread.isInterrupted()) {
                        int[] next1 = (int[])GdxNESTV.this.screen_q.take();
                        GdxNESTV.this.processNESFrame(next1, GdxNESTV.this.rgb_temp);
                        GdxNESTV.this.rFrame();
                        GdxNESTV.this.buffer_pool.add(next1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected final void startThread() {
        this.thread.start();
    }

    @Override
    public int[] submitNESFrameImpl(int[] frame) {
        if (!this.screen_q.offer(frame)) {
            return frame;
        }
        this.requires_render = true;
        return this.buffer_pool.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rFrame() {
        PixelActor pixelActor = this.screen;
        synchronized (pixelActor) {
            int bi = 0;
            ByteBuffer buffer = this.pixmap.getPixels();
            for (int from_i = this.start_index; from_i < this.end_index; ++from_i) {
                int c = this.rgb_temp[from_i];
                buffer.put(bi, (byte)((c & 0xFF0000) >> 16));
                buffer.put(bi + 1, (byte)((c & 0xFF00) >> 8));
                buffer.put(bi + 2, (byte)(c & 0xFF));
                bi += 3;
            }
            this.requires_render = true;
            this.updated_latch = !this.f_odd;
        }
    }

    public abstract void processNESFrame(int[] var1, int[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawFrame() {
        PixelActor pixelActor = this.screen;
        synchronized (pixelActor) {
            if (!this.requires_render || this.f_odd == this.updated_latch) {
                return;
            }
            this.screen.setPixmap(this.pixmap);
            this.requires_render = false;
            this.f_odd = this.updated_latch;
        }
    }

    public void setTextureFilter(Texture.TextureFilter filter) {
        this.screen.setFilter(filter);
    }

    public void dispose() {
        this.screen.dispose();
        this.thread.interrupt();
        while (this.thread.isAlive()) {
            try {
                Thread.sleep(1L);
                this.thread.interrupt();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void onAttach() {
        this.stage.addActor(this.screen);
    }

    @Override
    public void onDetach() {
        this.screen.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.pixmap.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.pixmap.fill();
        PixelActor pixelActor = this.screen;
        synchronized (pixelActor) {
            this.screen.setPixmap(this.pixmap);
        }
    }
}

