/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.gdx.anyyes;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.kotcrab.vis.ui.widget.Menu;
import com.kotcrab.vis.ui.widget.MenuBar;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.FileTypeFilter;
import com.kotcrab.vis.ui.widget.file.StreamingFileChooserListener;
import com.youkaicountry.anyyes.gdx.anyyes.NESScreen;

public class NESMenuBar
extends Table {
    NESScreen screen;

    public NESMenuBar(NESScreen screen) {
        this.screen = screen;
        MenuBar menu_bar = new MenuBar();
        menu_bar.addMenu(this.setupFileMenu());
        menu_bar.addMenu(this.setupSystemMenu());
        this.add(menu_bar.getTable()).expandX().fillX().top().left().row();
        this.add().expand().fill().bottom().row();
        this.setFillParent(true);
    }

    private Menu setupFileMenu() {
        Menu menu = new Menu("File");
        menu.addItem(new MenuItem("Open ROM", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESMenuBar.this.openFileChooser();
            }
        }));
        MenuItem close = new MenuItem("Close ROM", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESMenuBar.this.screen.stopCartridge();
                NESMenuBar.this.reloadMenu();
            }
        });
        close.setDisabled(!this.screen.nes.isPowered());
        menu.addItem(close);
        menu.addSeparator();
        MenuItem ss = new MenuItem("Save State");
        if (this.screen.nes.isPowered()) {
            ss.setSubMenu(this.createSaveStateMenu(10, true));
        } else {
            ss.setDisabled(true);
        }
        menu.addItem(ss);
        MenuItem ls = new MenuItem("Load State");
        if (this.screen.nes.isPowered()) {
            ls.setSubMenu(this.createSaveStateMenu(10, false));
        } else {
            ls.setDisabled(true);
        }
        menu.addItem(ls);
        menu.addSeparator();
        menu.addItem(new MenuItem("Exit", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESMenuBar.this.screen.quit();
            }
        }));
        return menu;
    }

    private Menu setupSystemMenu() {
        Menu menu = new Menu("System");
        MenuItem input = new MenuItem("Input");
        PopupMenu input_sub = new PopupMenu();
        input_sub.addItem(new MenuItem("Remap Controller #1", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESMenuBar.this.screen.startRemap();
            }
        }));
        input.setSubMenu(input_sub);
        menu.addItem(input);
        MenuItem video = new MenuItem("Video");
        video.setSubMenu(this.createVideoMenu());
        menu.addItem(video);
        menu.addSeparator();
        MenuItem power = new MenuItem("Power " + (this.screen.nes.isPowered() ? "Off" : "On"), new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (NESMenuBar.this.screen.nes.isPowered()) {
                    NESMenuBar.this.screen.nes.powerOn(false);
                    NESMenuBar.this.screen.tv.clear();
                    NESMenuBar.this.reloadMenu();
                } else {
                    NESMenuBar.this.screen.nes.powerOn(true);
                    NESMenuBar.this.screen.closeSettingsMenu();
                }
            }
        });
        power.setDisabled(!this.screen.nes.hasCartridge());
        menu.addItem(power);
        MenuItem reset = new MenuItem("Reset", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESMenuBar.this.screen.nes.reset();
                NESMenuBar.this.screen.closeSettingsMenu();
            }
        });
        reset.setDisabled(!this.screen.nes.isPowered());
        menu.addItem(reset);
        return menu;
    }

    private PopupMenu createVideoMenu() {
        PopupMenu menu = new PopupMenu();
        menu.addItem(new MenuItem((this.screen.lcd ? "Enable" : "Disable") + " NTSC", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESMenuBar.this.screen.toggleScreen();
                NESMenuBar.this.reloadMenu();
            }
        }).setShortcut("Q"));
        menu.addItem(new MenuItem((this.screen.linear ? "Disable" : "Enable") + " Linear Filtering", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESMenuBar.this.screen.toggleFilter();
                NESMenuBar.this.reloadMenu();
            }
        }).setShortcut("W"));
        menu.addItem(new MenuItem((this.screen.scanlines != null ? "Disable" : "Enable") + " Scanlines", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESMenuBar.this.screen.toggleScanlines();
                NESMenuBar.this.reloadMenu();
            }
        }).setShortcut("S"));
        return menu;
    }

    private PopupMenu createSaveStateMenu(int num, final boolean save) {
        PopupMenu menu = new PopupMenu();
        for (int i = 0; i < num; ++i) {
            final int sn = i;
            MenuItem item = new MenuItem(String.format("State %1$d", i), new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    NESMenuBar.this.handleSaveState(sn, save);
                }
            });
            menu.addItem(item);
        }
        return menu;
    }

    private void handleSaveState(int num, boolean save) {
        if (save) {
            this.screen.saveStateFile(num);
        } else {
            this.screen.loadStateFile(num);
        }
        this.screen.closeSettingsMenu();
    }

    private void openFileChooser() {
        FileChooser.setDefaultPrefsName("com.youkaicountry.any-yes");
        FileChooser.setSaveLastDirectory(true);
        FileChooser chooser = new FileChooser(FileChooser.Mode.OPEN);
        chooser.setSelectionMode(FileChooser.SelectionMode.FILES_AND_DIRECTORIES);
        chooser.setFavoriteFolderButtonVisible(true);
        chooser.setIconProvider(new FileChooser.DefaultFileIconProvider(chooser));
        chooser.setListener(new StreamingFileChooserListener(){

            @Override
            public void selected(FileHandle file) {
                NESMenuBar.this.screen.stopCartridge();
                NESMenuBar.this.screen.loadCartridge(file, false);
                NESMenuBar.this.screen.startCartridge();
                NESMenuBar.this.screen.toggleSettingsMenu();
            }
        });
        FileTypeFilter typeFilter = new FileTypeFilter(true);
        typeFilter.addRule("NES ROM (*.nes, *.zip)", "nes", "zip");
        chooser.setFileTypeFilter(typeFilter);
        this.screen.ui_stage.addActor(chooser.fadeIn());
        chooser.setFillParent(true);
    }

    private void reloadMenu() {
        this.screen.closeSettingsMenu();
        this.screen.openSettingsMenu();
    }
}

