/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.gdx.anyyes;

import com.badlogic.gdx.scenes.scene2d.Stage;
import com.youkaicountry.anyyes.gdx.anyyes.GdxNESTV;
import com.youkaicountry.anyyes.video.NESNTSC;
import com.youkaicountry.util.math.SineTable;
import com.youkaicountry.vnand.actors.PixelActor;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NESNTSCTV
extends GdxNESTV {
    public boolean dirty;
    private final ExecutorService executor;
    private final ArrayList<Callable<Object>> worker_tasks = new ArrayList();
    private int[] read_frame;
    private int[] write_rgb;

    public NESNTSCTV(Stage stage, int width, int height, PixelActor screen, int worker_threads) {
        super(stage, width, height, screen, 2);
        SineTable sine_table = new SineTable(512);
        int length = 240 / worker_threads;
        int last_add = 240 - length * worker_threads;
        for (int i = 0; i < worker_threads; ++i) {
            int ul = length + (i == worker_threads - 1 ? last_add : 0);
            this.worker_tasks.add(Executors.callable(new WorkerRunnable(i * length, ul, sine_table)));
        }
        this.executor = Executors.newFixedThreadPool(worker_threads);
        this.startThread();
    }

    @Override
    public void processNESFrame(int[] frame, int[] rgb_target) {
        this.read_frame = frame;
        this.write_rgb = rgb_target;
        try {
            this.executor.invokeAll(this.worker_tasks);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.executor.shutdown();
    }

    public class WorkerRunnable
    implements Runnable {
        final int scanline;
        final int length;
        final NESNTSC ntsc;

        public WorkerRunnable(int scanline, int length, SineTable sine_table) {
            this.scanline = scanline;
            this.length = length;
            this.ntsc = new NESNTSC(256, sine_table);
        }

        @Override
        public void run() {
            int s_frame = this.scanline * 256 * 8 + (NESNTSCTV.this.f_odd ? 8 : 0);
            this.ntsc.calcRGB(NESNTSCTV.this.read_frame, NESNTSCTV.this.write_rgb, s_frame, this.scanline, this.length);
        }
    }
}

