/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.gdx.anyyes;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.FPSLogger;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.kotcrab.vis.ui.VisUI;
import com.youkaicountry.anyyes.IJoypadPusher;
import com.youkaicountry.anyyes.NES;
import com.youkaicountry.anyyes.NESDebugger;
import com.youkaicountry.anyyes.NESJoypad;
import com.youkaicountry.anyyes.NESRegion;
import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.NESGameCartridge;
import com.youkaicountry.anyyes.cartridges.NESGenieCartridge;
import com.youkaicountry.anyyes.gdx.anyyes.GdxNESTV;
import com.youkaicountry.anyyes.gdx.anyyes.NESLCDTV;
import com.youkaicountry.anyyes.gdx.anyyes.NESMenuBar;
import com.youkaicountry.anyyes.gdx.anyyes.NESNTSCTV;
import com.youkaicountry.anyyes.gdx.anyyes.NESSpeaker;
import com.youkaicountry.anyyes.gdx.anyyes.TextOverlayActor;
import com.youkaicountry.anyyes.joypads.NESController;
import com.youkaicountry.emucore.cpu.exceptions.OpcodeNotFoundException;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.actors.PixelActor;
import com.youkaicountry.vnand.actors.SimpleSpriteActor;
import com.youkaicountry.vnand.actors.inputmap.ButtonSetupActor;
import com.youkaicountry.vnand.actors.inputmap.IMapEvent;
import com.youkaicountry.vnand.utils.NoCloseZipInputStream;
import java.io.InputStream;
import java.util.zip.ZipInputStream;

public class NESScreen
implements Screen,
InputProcessor,
IJoypadPusher,
IMapEvent {
    SpriteBatch batch;
    VNAnd game;
    FileHandle rom_fh;
    Stage stage;
    Stage ui_stage;
    public static final float SIZE_CONSTANT = 145.0f;
    FPSLogger fps = new FPSLogger();
    public NES nes;
    NESDebugger debugger;
    NESCartridge current_cartridge;
    ButtonSetupActor btnActor;
    NESSpeaker speaker;
    GdxNESTV tv;
    FileHandle sram_file;
    public static final float SAVE_CHECK_TIME = 300.0f;
    float save_counter = 0.0f;
    Controller[] controllers;
    boolean manual_execution = false;
    ShaderProgram shader;
    boolean lcd;
    boolean linear;
    boolean super_sprite;
    TextOverlayActor text_actor;
    public int save_slot = 0;
    boolean time_modding;
    float time_mod;
    int old_frame_skip;
    boolean is_paused;
    String game_name;
    boolean error;
    String error_message;
    int frameskip;
    boolean check_playing;
    SimpleSpriteActor scanlines;
    NESMenuBar menu;
    float dt_max;
    float dt;
    float dt_deficit;
    float dt_deficit_degrade;
    float dt_deficit_max;
    float last_dt = 0.02f;
    float dt_momentum;

    public NESScreen(VNAnd game, SpriteBatch batch, FileHandle rom_fh, boolean genie) {
        this.init(game, batch);
        this.loadCartridge(rom_fh, genie);
    }

    public NESScreen(VNAnd game, SpriteBatch batch) {
        this.init(game, batch);
        this.toggleSettingsMenu();
    }

    private void init(VNAnd game, SpriteBatch batch) {
        this.btnActor = new ButtonSetupActor(this);
        this.game = game;
        this.batch = batch;
        VisUI.load(VisUI.SkinScale.X2);
        this.frameskip = 0;
        this.dt_deficit_degrade = 0.75f;
        if (Gdx.app.getType() == Application.ApplicationType.Android) {
            this.dt_max = 0.032f;
            this.dt_deficit_max = 0.008f;
        } else {
            this.dt_max = 0.028f;
            this.dt_deficit_max = 0.012f;
        }
        this.dt_momentum = 0.1f;
        this.time_mod = 1.0f;
        this.initSystem();
        this.initUI();
    }

    public void loadCartridge(FileHandle fh, boolean genie) {
        this.rom_fh = fh;
        this.game_name = this.rom_fh.nameWithoutExtension();
        FileHandle sram_fh = VNAnd.getSaveDirectory("any-yes").child("sram").child(this.game_name + ".sav");
        try {
            FileHandle genie_fh;
            NESCartridge cart;
            String ext = this.rom_fh.extension().toLowerCase();
            InputStream fis = this.rom_fh.read();
            if (ext.equals("zip")) {
                NoCloseZipInputStream zis = new NoCloseZipInputStream(fis);
                if (!sram_fh.exists()) {
                    cart = new NESGameCartridge(zis);
                } else {
                    InputStream sis = sram_fh.read();
                    cart = new NESGameCartridge(zis, sram_fh.read());
                    sis.close();
                }
                ((ZipInputStream)zis).close();
            } else if (!sram_fh.exists()) {
                cart = new NESGameCartridge(fis);
            } else {
                InputStream sis = sram_fh.read();
                cart = new NESGameCartridge(this.rom_fh.read(), sis);
                sis.close();
            }
            fis.close();
            if (cart.battery) {
                this.sram_file = sram_fh;
            }
            if (genie && (genie_fh = VNAnd.getSpecificGameDataDirectory("any-yes", "bios").child("genie.nes")).exists()) {
                NESGenieCartridge genie_cart = new NESGenieCartridge(genie_fh.read());
                genie_cart.insertCartridge(cart);
                cart = genie_cart;
            }
            this.current_cartridge = cart;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error = true;
            this.error_message = e.getMessage();
        }
    }

    private void initSystem() {
        this.nes = new NES(true, NESRegion.NTSC);
        float w_div = 145.0f / Gdx.graphics.getPpiX();
        ScreenViewport svp = new ScreenViewport();
        svp.setUnitsPerPixel(w_div);
        this.ui_stage = new Stage(svp);
        this.stage = new Stage(new FitViewport(256.0f, 224.0f));
        this.attachLCDTV();
        this.speaker = new NESSpeaker(Gdx.app.getType() == Application.ApplicationType.Android ? 22050 : 44100);
        this.nes.attachSpeaker(this.speaker);
        this.speaker.play();
        this.controllers = new Controller[2];
        this.nes.attachJoypad(0, new NESController(this, 0));
        this.debugger = new NESDebugger(this.nes);
    }

    private void initUI() {
        this.ui_stage.addActor(this.btnActor);
        this.setupBasicInput();
        FileHandle conf = VNAnd.getConfigDirectory("any-yes").child("input.txt");
        this.btnActor.loadConfig(conf);
        InputMultiplexer ip = new InputMultiplexer(this.btnActor, this.ui_stage, this);
        Gdx.input.setInputProcessor(ip);
        Gdx.input.setCatchBackKey(true);
        this.text_actor = new TextOverlayActor(4.0f);
        this.text_actor.setTextOrigin(80, 110);
        this.ui_stage.addActor(this.text_actor);
    }

    public void startCartridge() {
        if (this.error) {
            this.text_actor.addMessage(this.error_message, 5, 30, Float.MAX_VALUE);
            this.manual_execution = true;
            return;
        }
        this.text_actor.addMessage(this.game_name + "\nMapper:" + this.current_cartridge.mapper_number, 5, 32, 2.0f);
        this.nes.insertCartridge(this.current_cartridge);
        this.nes.powerOn(true);
    }

    public void stopCartridge() {
        this.trySave();
        this.nes.powerOn(false);
        this.nes.removeCartridge();
        this.tv.clear();
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 131: {
                this.toggleSettingsMenu();
                break;
            }
            case 4: {
                this.toggleSettingsMenu();
                break;
            }
            case 244: {
                this.saveQuickState();
                break;
            }
            case 245: {
                this.loadQuickState();
                break;
            }
            case 248: {
                this.saveStateFile(this.save_slot);
                break;
            }
            case 249: {
                this.loadStateFile(this.save_slot);
                break;
            }
            case 68: {
                this.startTimeMod(4.0f, 8);
                break;
            }
            case 45: {
                this.toggleScreen();
                break;
            }
            case 51: {
                this.toggleFilter();
                break;
            }
            case 33: {
                this.toggleSuperSprite();
                break;
            }
            case 41: {
                this.startRemap();
                break;
            }
            case 46: {
                this.handleRecording(false);
                break;
            }
            case 48: {
                this.playRecording();
                break;
            }
            case 47: {
                this.toggleScanlines();
            }
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 68: {
                this.stopTimeMod();
            }
        }
        return false;
    }

    public void handleRecording(boolean shutdown) {
        if (this.nes.isRecording()) {
            FileHandle rec = VNAnd.getRecordingDirectory("any-yes").child(this.game_name + ".rec");
            byte[] data = this.nes.stopRecording(false);
            rec.writeBytes(data, false);
            this.text_actor.addMessage("Recording ended.", 10, 15, 2.0f);
            this.closeSettingsMenu();
        } else if (!shutdown) {
            String m = this.nes.startRecording() ? "Recording started." : "Can't record now.";
            this.text_actor.addMessage(m, 10, 15, 2.0f);
            this.closeSettingsMenu();
        }
    }

    public void cancelRecording() {
        this.nes.stopRecording(true);
        this.closeSettingsMenu();
    }

    public void playRecording() {
        FileHandle rec = VNAnd.getRecordingDirectory("any-yes").child(this.game_name + ".rec");
        if (!rec.exists()) {
            this.text_actor.addMessage("No recording!.", 10, 15, 2.0f);
        }
        byte[] data = rec.readBytes();
        this.nes.playRecording(data);
        this.check_playing = true;
        this.text_actor.addMessage("Playing recording.", 10, 15, 2.0f);
        this.closeSettingsMenu();
    }

    public void stopPlayingRecording() {
        if (this.nes.stopPlayingRecording()) {
            this.text_actor.addMessage("Stopped recording.", 10, 15, 2.0f);
            this.check_playing = false;
        }
        this.closeSettingsMenu();
    }

    public void startRemap() {
        this.tv.screen.setVisible(false);
        if (this.menu != null) {
            this.menu.setVisible(false);
        }
        this.btnActor.remapFields();
    }

    @Override
    public void remapFinished() {
        this.btnActor.saveConfig(VNAnd.getConfigDirectory("any-yes").child("input.txt"));
        this.tv.screen.setVisible(true);
        if (this.menu != null) {
            this.menu.setVisible(true);
        }
    }

    @Override
    public void anyButtonPressed() {
        this.nes.setJoypadsDirty();
    }

    public void toggleScreen() {
        this.detachTV();
        if (this.lcd) {
            this.attachNTSCTV();
        } else {
            this.attachLCDTV();
        }
        this.reorderActors();
    }

    private void detachTV() {
        this.nes.detachTV();
        this.tv.dispose();
        this.tv = null;
    }

    private void attachLCDTV() {
        PixelActor pixels = new PixelActor(256, 224, Pixmap.Format.RGB888);
        this.tv = new NESLCDTV(this.stage, 256, 224, pixels);
        this.tv.setFrameSkip(this.frameskip);
        this.nes.attachTV(this.tv);
        this.setCurrentFilter();
        this.lcd = true;
    }

    private void attachNTSCTV() {
        PixelActor pixels = new PixelActor(256, 224, Pixmap.Format.RGB888);
        this.tv = new NESNTSCTV(this.stage, 256, 224, pixels, VNAnd.getHalfCores());
        this.tv.setFrameSkip(this.frameskip);
        this.nes.attachTV(this.tv);
        this.setCurrentFilter();
        this.lcd = false;
    }

    public void toggleFilter() {
        this.linear = !this.linear;
        this.setCurrentFilter();
    }

    private void setCurrentFilter() {
        this.tv.setTextureFilter(this.linear ? Texture.TextureFilter.Linear : Texture.TextureFilter.Nearest);
    }

    public void toggleScanlines() {
        if (this.scanlines == null) {
            Texture tscanlines = new Texture(Gdx.files.internal("sprites/any-yes/scanline.png"));
            tscanlines.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Sprite sscanlines = new Sprite(tscanlines);
            sscanlines.setPosition(-896.0f, -784.0f);
            sscanlines.setScale(0.125f);
            this.scanlines = new SimpleSpriteActor();
            this.scanlines.addSprite(sscanlines);
            this.stage.addActor(this.scanlines);
        } else {
            this.scanlines.remove();
            this.scanlines.clearSprites();
            this.scanlines = null;
        }
    }

    private void reorderActors() {
        if (this.scanlines != null) {
            this.scanlines.remove();
            this.stage.addActor(this.scanlines);
        }
    }

    public void toggleSuperSprite() {
        this.super_sprite = !this.super_sprite;
        this.nes.ppu.setSpriteLimit(this.super_sprite ? 15 : 8);
    }

    private void startTimeMod(float mod, int frame_skip) {
        if (this.time_modding) {
            return;
        }
        this.old_frame_skip = this.tv.getFrameSkip();
        this.tv.setFrameSkip(frame_skip);
        this.time_mod = mod;
        this.time_modding = true;
        this.text_actor.addMessage("FF", 5, 15, 2.0f);
    }

    private void stopTimeMod() {
        this.tv.setFrameSkip(this.old_frame_skip);
        this.time_mod = 1.0f;
        this.time_modding = false;
    }

    private FileHandle getSaveStateFile(int num) {
        return VNAnd.getSaveDirectory("any-yes").child("states").child(this.game_name + ".ns" + num);
    }

    public void saveStateFile(int num) {
        FileHandle fh = this.getSaveStateFile(num);
        byte[] buffer = this.nes.saveState(true);
        fh.writeBytes(buffer, false);
        this.text_actor.addMessage("State saved to slot " + num + ".", 5, 15, 1.0f);
    }

    public void loadStateFile(int num) {
        boolean is_recording = this.nes.isRecording();
        FileHandle fh = this.getSaveStateFile(num);
        if (!fh.exists()) {
            return;
        }
        byte[] buffer = fh.readBytes();
        this.nes.loadState(buffer, true);
        if (!is_recording && this.nes.isRecording()) {
            this.text_actor.addMessage("Recording continued.", 10, 15, 1.0f);
        } else if (is_recording && !this.nes.isRecording()) {
            this.text_actor.addMessage("Recording cancelled.", 10, 15, 1.0f);
        } else {
            this.text_actor.addMessage("State loaded from slot " + num + ".", 10, 15, 1.0f);
        }
    }

    public void saveQuickState() {
        this.nes.quickSave();
        this.text_actor.addMessage("Quick save created.", 10, 15, 1.0f);
    }

    public void loadQuickState() {
        String message = this.nes.quickLoad() ? "Quick save loaded." : "No quick save!";
        this.text_actor.addMessage(message, 10, 15, 1.0f);
    }

    public void setSaveSlot(int num) {
        this.save_slot = num;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.nes.setJoypadsDirty();
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.nes.setJoypadsDirty();
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    public void toggleSettingsMenu() {
        if (this.menu == null) {
            this.openSettingsMenu();
        } else {
            this.closeSettingsMenu();
        }
    }

    public void openSettingsMenu() {
        if (this.menu != null) {
            return;
        }
        this.menu = new NESMenuBar(this);
        this.ui_stage.addActor(this.menu);
        this.pauseEmulation();
    }

    public void closeSettingsMenu() {
        if (this.menu == null) {
            return;
        }
        this.menu.remove();
        this.menu = null;
        this.resumeEmulation();
    }

    public void pauseEmulation() {
        this.is_paused = true;
    }

    public void resumeEmulation() {
        this.is_paused = false;
    }

    public void quit() {
        this.game.quitGame();
    }

    @Override
    public void show() {
        if (this.current_cartridge != null) {
            this.startCartridge();
        }
    }

    private void setupBasicInput() {
        this.btnActor.addField("A");
        this.btnActor.addMapping(0).setAsKey(52).setBuiltin(true);
        this.btnActor.addField("B");
        this.btnActor.addMapping(1).setAsKey(54).setBuiltin(true);
        this.btnActor.addField("Up");
        this.btnActor.addMapping(2).setAsKey(19).setBuiltin(true);
        this.btnActor.addField("Down");
        this.btnActor.addMapping(3).setAsKey(20).setBuiltin(true);
        this.btnActor.addField("Left");
        this.btnActor.addMapping(4).setAsKey(21).setBuiltin(true);
        this.btnActor.addField("Right");
        this.btnActor.addMapping(5).setAsKey(22).setBuiltin(true);
        this.btnActor.addField("Select");
        this.btnActor.addMapping(6).setAsKey(61).setBuiltin(true);
        this.btnActor.addField("Start");
        this.btnActor.addMapping(7).setAsKey(66).setBuiltin(true);
    }

    private void setShader() {
        String vertexShader = Gdx.files.internal("shaders/ntsc/vertex1.glsl").readString();
        String fragmentShader = Gdx.files.internal("shaders/ntsc/fragment1.glsl").readString();
        this.shader = new ShaderProgram(vertexShader, fragmentShader);
        this.stage.getBatch().setShader(this.shader);
    }

    private final void calcDT(float delta) {
        if (delta > this.dt_max) {
            this.dt_deficit *= this.dt_deficit_degrade;
            this.dt = this.dt_max;
            this.dt_deficit += delta - this.dt_max;
            this.dt_deficit = Math.min(this.dt_deficit, this.dt_deficit_max);
        } else {
            this.dt = delta;
            if (this.dt_deficit > 0.0f) {
                float add = Math.min(this.dt_max - this.dt, this.dt_deficit);
                this.dt_deficit -= add;
                this.dt += add;
                this.dt_deficit *= this.dt_deficit_degrade;
            }
        }
        if (Gdx.app.getType() == Application.ApplicationType.Android) {
            this.dt += this.dt * 0.03f;
        }
        this.dt *= this.time_mod;
    }

    private final void calcDT2(float delta) {
        this.dt += (delta - this.last_dt) * this.dt_momentum;
        this.last_dt = this.dt;
        this.dt *= this.time_mod;
    }

    @Override
    public void render(float delta) {
        this.calcDT(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        if (this.stage == null) {
            return;
        }
        this.ui_stage.act();
        this.stage.act();
        if (!this.is_paused && !this.btnActor.record_mode) {
            if (!this.manual_execution) {
                this.tv.acceptFrame();
                try {
                    this.nes.executeTimeSlice(this.dt);
                }
                catch (OpcodeNotFoundException e) {
                    this.is_paused = true;
                    this.text_actor.addMessage("Unimplemented Opcode: 0x" + Integer.toHexString(e.opcode) + ". Halting emulation.", 10, 15, Float.MAX_VALUE);
                }
            }
            if (this.tv != null) {
                this.tv.drawFrame();
            }
            if (this.check_playing && !this.nes.isPlayingRecording()) {
                this.text_actor.addMessage("Recording ended.", 10, 15, 2.0f);
                this.check_playing = false;
            }
        }
        this.stage.getViewport().apply();
        this.stage.draw();
        this.ui_stage.getViewport().apply();
        this.ui_stage.draw();
        this.save_counter += delta;
        if (this.save_counter >= 300.0f) {
            this.trySave();
            this.save_counter -= 300.0f;
        }
    }

    private void trySave() {
        if (this.sram_file == null) {
            return;
        }
        if (this.nes.mem.cartridge == null || !this.nes.mem.cartridge.isSRAMDirty()) {
            return;
        }
        byte[] sram = this.nes.mem.cartridge.getSRAM();
        this.sram_file.writeBytes(sram, false);
        System.out.println("SAVING");
    }

    @Override
    public void resize(int width, int height) {
        if (this.stage == null) {
            return;
        }
        this.stage.getViewport().update(width, height);
        this.ui_stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
        this.trySave();
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.trySave();
    }

    @Override
    public void dispose() {
        this.trySave();
        this.handleRecording(true);
        VisUI.dispose();
        this.speaker.stop();
        this.detachTV();
        this.stage.dispose();
        this.ui_stage.dispose();
    }

    @Override
    public void getPushState(NESJoypad joypad, int slot) {
        joypad.setUpPressed(this.btnActor.isFieldPressed(2));
        joypad.setDownPressed(this.btnActor.isFieldPressed(3));
        joypad.setLeftPressed(this.btnActor.isFieldPressed(4));
        joypad.setRightPressed(this.btnActor.isFieldPressed(5));
        joypad.setAPressed(this.btnActor.isFieldPressed(0));
        joypad.setBPressed(this.btnActor.isFieldPressed(1));
        joypad.setSelectPressed(this.btnActor.isFieldPressed(6));
        joypad.setStartPressed(this.btnActor.isFieldPressed(7));
    }
}

