/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.gdx.anyyes;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.youkaicountry.anyyes.gdx.anyyes.NESScreen;
import com.youkaicountry.vnand.VNAnd;

public class NESSettingsWindow
extends Window {
    NESScreen screen;

    public NESSettingsWindow(NESScreen screen) {
        super("Settings", VNAnd.skin);
        this.screen = screen;
        this.init();
    }

    private void init() {
        this.setHeight(200.0f);
        this.setWidth(350.0f);
        this.addSaveState();
        this.row();
        this.add(this.createMapControlsButton()).pad(8.0f).fill();
        this.row();
        this.createRecordButtons();
        this.add(this.createQuitButton()).pad(8.0f);
    }

    private void addSaveState() {
        int slot = this.screen.save_slot;
        this.add(new Label((CharSequence)"Slot: ", VNAnd.skin));
        ButtonGroup<CheckBox> bg = new ButtonGroup<CheckBox>();
        HorizontalGroup hg = new HorizontalGroup();
        hg.space(8.0f);
        for (int i = 0; i < 5; ++i) {
            CheckBox b = this.createSSSlot(i);
            b.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (!((Button)actor).isChecked()) {
                        return;
                    }
                    NESSettingsWindow.this.screen.setSaveSlot(Integer.parseInt(((TextButton)actor).getText().toString().trim()));
                }
            });
            bg.add(b);
            hg.addActor(b);
        }
        this.add(hg);
        bg.setChecked(" " + slot + " ");
        bg.setMinCheckCount(1);
        bg.setMaxCheckCount(1);
        bg.setUncheckLast(true);
        this.row();
        TextButton ssb = new TextButton("Save State", VNAnd.skin);
        ssb.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESSettingsWindow.this.screen.saveStateFile(NESSettingsWindow.this.screen.save_slot);
                NESSettingsWindow.this.screen.closeSettingsMenu();
            }
        });
        this.add(ssb).pad(8.0f);
        TextButton lsb = new TextButton("Load State", VNAnd.skin);
        lsb.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESSettingsWindow.this.screen.loadStateFile(NESSettingsWindow.this.screen.save_slot);
                NESSettingsWindow.this.screen.closeSettingsMenu();
            }
        });
        this.add(lsb).pad(8.0f);
    }

    private CheckBox createSSSlot(int num) {
        CheckBox b = new CheckBox(" " + num + " ", VNAnd.skin);
        return b;
    }

    private TextButton createMapControlsButton() {
        TextButton b = new TextButton("Map Controls", VNAnd.skin);
        b.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESSettingsWindow.this.screen.startRemap();
            }
        });
        return b;
    }

    private TextButton createQuitButton() {
        TextButton b = new TextButton("Quit", VNAnd.skin);
        b.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                NESSettingsWindow.this.screen.quit();
            }
        });
        return b;
    }

    private void createRecordButtons() {
        this.add(new Label((CharSequence)"Recording:", VNAnd.skin));
        this.row();
        HorizontalGroup hg = new HorizontalGroup();
        if (this.screen.nes.isRecording()) {
            TextButton t = new TextButton("Finish", VNAnd.skin);
            t.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    NESSettingsWindow.this.screen.handleRecording(true);
                }
            });
            TextButton t2 = new TextButton("Cancel", VNAnd.skin);
            t2.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    NESSettingsWindow.this.screen.cancelRecording();
                }
            });
            hg.addActor(t);
            hg.addActor(t2);
        } else if (this.screen.nes.isPlayingRecording()) {
            TextButton t = new TextButton("Stop", VNAnd.skin);
            t.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    NESSettingsWindow.this.screen.stopPlayingRecording();
                }
            });
            hg.addActor(t);
        } else {
            TextButton t = new TextButton("Create", VNAnd.skin);
            t.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    NESSettingsWindow.this.screen.handleRecording(false);
                }
            });
            TextButton t2 = new TextButton("Play", VNAnd.skin);
            t2.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    NESSettingsWindow.this.screen.playRecording();
                }
            });
            hg.addActor(t);
            hg.addActor(t2);
        }
        this.add(hg);
    }
}

