/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.gdx.anyyes;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.AudioDevice;
import com.youkaicountry.anyyes.INESSpeaker;
import java.util.concurrent.ArrayBlockingQueue;

public class NESSpeaker
implements INESSpeaker {
    private final Thread player_thread;
    private final AudioDevice audio;
    public static final int INTERP_SIZE = 2;
    private int buffer_size;
    float last_val;
    private final int sample_rate;
    private final int pool_size;
    private final ArrayBlockingQueue<float[]> buffer_pool;
    private final ArrayBlockingQueue<float[]> sound_q = new ArrayBlockingQueue(this.pool_size, false);
    private boolean playing = false;

    public NESSpeaker(int sample_rate) {
        this.pool_size = 2;
        this.buffer_pool = new ArrayBlockingQueue(this.pool_size + 2, false);
        this.sample_rate = sample_rate;
        this.audio = Gdx.audio.newAudioDevice(sample_rate, true);
        this.player_thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!NESSpeaker.this.player_thread.isInterrupted()) {
                        float[] next1 = (float[])NESSpeaker.this.sound_q.take();
                        NESSpeaker.this.audio.writeSamples(next1, 0, next1.length);
                        NESSpeaker.this.buffer_pool.add(next1);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("Audio dispose I");
                    NESSpeaker.this.audio.dispose();
                }
                System.out.println("Audio dispose");
                NESSpeaker.this.audio.dispose();
            }
        });
    }

    @Override
    public int getSampleRate() {
        return this.sample_rate;
    }

    @Override
    public void init(int buffer_size) {
        this.buffer_size = buffer_size;
        for (int i = 0; i < this.pool_size + 1; ++i) {
            float[] b = new float[buffer_size];
            this.buffer_pool.add(b);
        }
    }

    @Override
    public final float[] playAudio(float[] buffer) {
        if (!this.sound_q.offer(buffer)) {
            return buffer;
        }
        return this.buffer_pool.poll();
    }

    public void play() {
        this.playing = true;
        this.player_thread.start();
    }

    public void stop() {
        this.playing = false;
        this.player_thread.interrupt();
        while (this.player_thread.isAlive()) {
            try {
                Thread.sleep(1L);
                this.player_thread.interrupt();
            }
            catch (Exception exception) {}
        }
    }
}

