/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.gdx.anyyes;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import java.util.ArrayList;

public class TextOverlayActor
extends Actor {
    BitmapFont font = new BitmapFont();
    ArrayList<TextOverlay> text;
    ArrayList<Integer> remove;
    int origin_x;
    int origin_y;

    public TextOverlayActor(float scale) {
        this.font.getData().setScale(scale);
        this.text = new ArrayList();
        this.remove = new ArrayList();
    }

    public void setTextOrigin(int x, int y) {
        this.origin_x = x;
        this.origin_y = y;
    }

    public void addMessage(String text, int x, int y, float time) {
        this.text.add(new TextOverlay(text, x + this.origin_x, y + this.origin_y, time));
    }

    @Override
    public void act(float delta) {
        int i;
        for (i = 0; i < this.text.size(); ++i) {
            if (!this.text.get(i).tick(delta)) continue;
            this.remove.add(i);
        }
        if (this.remove.size() == 0) {
            return;
        }
        for (i = 0; i < this.remove.size(); ++i) {
            this.text.remove(this.remove.get(i) - i);
        }
        this.remove.clear();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        for (int i = 0; i < this.text.size(); ++i) {
            TextOverlay to = this.text.get(i);
            this.font.draw(batch, to.text, (float)to.x, (float)to.y);
        }
    }

    public class TextOverlay {
        float time_left;
        int x;
        int y;
        String text;

        public TextOverlay(String text, int x, int y, float time) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.time_left = time;
        }

        public boolean tick(float delta) {
            this.time_left -= delta;
            return this.time_left <= 0.0f;
        }
    }
}

