/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.video;

import com.youkaicountry.util.math.SineTable;

public class NESNTSC {
    private final int width;
    private final float[] signal_scan;
    private final int[] rgb_scan;
    private float gamma;
    private float gamma_pow;
    private final SineTable sine_table;
    private static final float V_BLACK = 0.518f;
    private static final float V_WHITE = 1.962f;
    private static final float V_ATTEN = 0.746f;
    private static final float V_WHITE_M_BLACK = 1.444f;
    private static final float[] levels = new float[]{0.35f, 0.518f, 0.962f, 1.55f, 1.094f, 1.506f, 1.962f, 1.962f};

    public NESNTSC(int width, SineTable sine_table) {
        this.gamma_pow = 2.2f / this.gamma;
        this.width = width;
        this.sine_table = sine_table;
        this.signal_scan = new float[width * 8];
        this.rgb_scan = new int[width];
        this.setGamma(2.0f);
    }

    private static final boolean isInColorPhase(int color, int phase) {
        return (color + phase) % 12 < 6;
    }

    private void setGamma(float gamma) {
        this.gamma = gamma;
        this.gamma_pow = 2.2f / gamma;
    }

    private static float calcNTSCSignal(int nes_color, int phase) {
        float signal;
        int color = nes_color & 0xF;
        int level = nes_color >> 4 & 3;
        int emphasis = nes_color >> 6;
        if (color > 13) {
            level = 1;
        }
        float low = levels[level];
        float high = levels[4 + level];
        if (color == 0) {
            low = high;
        }
        if (color > 12) {
            high = low;
        }
        float f = signal = NESNTSC.isInColorPhase(color, phase) ? high : low;
        if (emphasis != 0 && ((emphasis & 1) != 0 && NESNTSC.isInColorPhase(0, phase) || (emphasis & 2) != 0 && NESNTSC.isInColorPhase(4, phase) || (emphasis & 4) != 0 && NESNTSC.isInColorPhase(8, phase))) {
            signal *= 0.746f;
        }
        return signal;
    }

    private static void calcNTSCPixel(float[] scan, int x, int nes_color, int phase) {
        for (int p = 0; p < 8; ++p) {
            float signal = NESNTSC.calcNTSCSignal(nes_color, phase + p);
            scan[x * 8 + p] = signal = (signal - 0.518f) / 1.444f;
        }
    }

    private void calcYIQColors(float[] scan, int[] rgb, int scanline, int width, int phase) {
        float fphase = ((float)phase + 8.2f) % 12.0f;
        int base = scanline * width;
        for (int x = 0; x < width; ++x) {
            int end;
            int center = x * 2048 / width;
            int begin = center - 6;
            if (begin < 0) {
                begin = 0;
            }
            if ((end = center + 6) > 2048) {
                end = 2048;
            }
            float y = 0.0f;
            float i = 0.0f;
            float q = 0.0f;
            for (int p = begin; p < end; ++p) {
                float level = scan[p] / 12.0f;
                y += level;
                i += level * this.sine_table.cos((float)(Math.PI * (double)(fphase + (float)p) / 6.0));
                q += level * this.sine_table.sin((float)(Math.PI * (double)(fphase + (float)p) / 6.0));
            }
            rgb[base + x] = this.YIQ2RGB(y, i, q);
        }
    }

    private int YIQ2RGB(float y, float i, float q) {
        return 65536 * NESNTSC.clamp((int)(255.95 * (double)this.gammaFix(y + 0.946882f * i + 0.623557f * q))) + 256 * NESNTSC.clamp((int)(255.95 * (double)this.gammaFix(y + -0.274788f * i + -0.635691f * q))) + NESNTSC.clamp((int)(255.95 * (double)this.gammaFix(y + -1.108545f * i + 1.709007f * q)));
    }

    private final float gammaFix(float f) {
        return f <= 0.0f ? 0.0f : (float)Math.pow(f, this.gamma_pow);
    }

    private static final int clamp(int val) {
        return val > 255 ? 255 : val;
    }

    private void calcScanlineRGB(int[] nes_colors, int[] rgb, int scanline, int phase) {
        int base = scanline * this.width;
        for (int x = 0; x < this.width; ++x) {
            int i = base + x;
            NESNTSC.calcNTSCPixel(this.signal_scan, x, nes_colors[i], phase);
            phase += 8;
        }
        this.calcYIQColors(this.signal_scan, rgb, scanline, this.width, phase);
    }

    public final void calcRGB(int[] nes_colors, int[] rgb, int phase, int start, int length) {
        int phase_jump = this.width * 8;
        for (int scanline = start; scanline < start + length; ++scanline) {
            this.calcScanlineRGB(nes_colors, rgb, scanline, phase);
            phase += phase_jump;
        }
    }
}

