/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.video;

import com.youkaicountry.anyyes.NES;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.emucore.IMemRW;
import com.youkaicountry.util.BitUtil;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;
import java.util.Arrays;

public class NESPPU
implements IMemRW,
IByteSerialize {
    public static final int MIRROR_VERTICAL = 0;
    public static final int MIRROR_HORIZONTAL = 1;
    public static final int MIRROR_ONE_SCREEN_LOW = 2;
    public static final int MIRROR_ONE_SCREEN_HIGH = 3;
    public static final int MIRROR_FOUR_SCREEN = 4;
    private final NES nes;
    public NESMapper mapper;
    private final int[] cgRAM;
    private final int[] oamMem;
    private int oam_address;
    private int vram_buffer;
    private int[] vbuffer;
    private int dirty = 2;
    private int rend_cycle = 0;
    private boolean skipping_render;
    public boolean is_rendering;
    private int fx;
    private final Ctrl ctrl;
    private final Mask mask;
    private final Status status;
    private final Addr v_addr;
    private final Addr t_addr;
    private int sprite_limit;
    private Sprite[] oam;
    private Sprite[] s_oam;
    private int ppu_bus;
    private boolean read_latch;
    public int address_bus;
    public int scanline;
    public int dot;
    private boolean frame_odd;
    private int nt;
    private int at;
    private int bg_l;
    private int bg_h;
    private int at_shift_l;
    private int at_shift_h;
    private int bg_shift_l;
    private int bg_shift_h;
    private boolean at_latch_l;
    private boolean at_latch_h;
    int last = 0;

    public NESPPU(NES nes) {
        this.nes = nes;
        this.cgRAM = new int[32];
        this.oamMem = new int[256];
        this.ctrl = new Ctrl();
        this.mask = new Mask();
        this.status = new Status();
        this.v_addr = new Addr();
        this.t_addr = new Addr();
        this.calcMaskValues();
        this.vbuffer = new int[61440];
        this.setSpriteLimit(8);
    }

    public final void setSpriteLimit(int limit) {
        if (this.sprite_limit == limit) {
            return;
        }
        Sprite[] n_oam = new Sprite[limit];
        Sprite[] n_s_oam = new Sprite[limit];
        int copy = Math.min(limit, this.sprite_limit);
        for (int i = 0; i < copy; ++i) {
            n_oam[i] = this.oam[i];
            n_s_oam[i] = this.s_oam[i];
        }
        int create = limit - copy;
        if (create > 0) {
            for (int i = copy; i < limit; ++i) {
                n_oam[i] = new Sprite();
                n_s_oam[i] = new Sprite();
            }
        }
        this.oam = n_oam;
        this.s_oam = n_s_oam;
        this.sprite_limit = limit;
    }

    private int spriteHeight() {
        return this.ctrl.h != 0 ? 16 : 8;
    }

    private final int getNTAddress() {
        return 0x2000 | this.v_addr.getR() & 0xFFF;
    }

    private final int getATAddress() {
        return 0x23C0 | this.v_addr.getNT() << 10 & 0xFFFF | this.v_addr.getCY() / 4 << 3 & 0xFFFF | this.v_addr.getCX() / 4;
    }

    private final int getBGAddress() {
        return this.ctrl.b * 4096 + this.nt * 16 + this.v_addr.getFY();
    }

    private final void loadShiftReg() {
        this.bg_shift_l = this.bg_shift_l & 0xFF00 | this.bg_l & 0xFF;
        this.bg_shift_h = this.bg_shift_h & 0xFF00 | this.bg_h & 0xFF;
        this.at_latch_l = (this.at & 1) != 0;
        this.at_latch_h = (this.at & 2) != 0;
    }

    private final void hScroll() {
        if (!this.is_rendering) {
            return;
        }
        if (this.v_addr.getCX() == 31) {
            this.v_addr.setR((this.v_addr.getR() ^ 0x41F) & Short.MAX_VALUE);
        } else {
            this.v_addr.setCX(this.v_addr.getCX() + 1 & 0x1F);
        }
    }

    private final void hUpdate() {
        if (!this.is_rendering) {
            return;
        }
        this.v_addr.setR(this.v_addr.getR() & 0xFFFFFBE0 | this.t_addr.getR() & 0x41F);
    }

    private final void vScroll() {
        if (!this.is_rendering) {
            return;
        }
        if (this.v_addr.getFY() < 7) {
            this.v_addr.setFY(this.v_addr.getFY() + 1 & 7);
        } else {
            this.v_addr.setFY(0);
            if (this.v_addr.getCY() == 31) {
                this.v_addr.setCY(0);
            } else if (this.v_addr.getCY() == 29) {
                this.v_addr.setCY(0);
                this.v_addr.setNT(this.v_addr.getNT() ^ 2);
            } else {
                this.v_addr.setCY(this.v_addr.getCY() + 1 & 0x1F);
            }
        }
    }

    private final void vUpdate() {
        if (!this.is_rendering) {
            return;
        }
        this.v_addr.setR(this.v_addr.getR() & 0xFFFF841F | this.t_addr.getR() & 0x7BE0);
    }

    @Override
    public final int read(int address) {
        if (address <= 8191) {
            return this.mapper.readCHR(address);
        }
        if (address <= 16127) {
            return this.mapper.readNT(address);
        }
        if (address <= 16383) {
            if ((address & 0x13) == 16) {
                address = address & 0xFFFFFFEF & 0x3FFF;
            }
            return this.cgRAM[address & 0x1F] & (this.mask.gray != 0 ? 48 : 255);
        }
        System.out.println("RETURNING ZERO");
        return 0;
    }

    @Override
    public final void write(int address, int value) {
        if (address <= 8191) {
            this.mapper.writeCHR(address, value);
        } else if (address <= 16127) {
            this.mapper.writeNT(address, value);
        } else if (address <= 16383) {
            if ((address & 0x13) == 16) {
                address = address & 0xFFFFFFEF & 0x3FFF;
            }
            this.cgRAM[address & 0x1F] = value;
        }
    }

    private final void incV() {
        int o = this.v_addr.getAddr();
        int n = o + (this.ctrl.i == 0 ? 1 : 32) & 0x3FFF;
        this.v_addr.setAddr(n);
        this.sendA12Clock(o, n);
    }

    public final int read_register(int index) {
        this.dirty = 2;
        switch (index) {
            case 2: {
                this.read2002();
                break;
            }
            case 4: {
                this.read2004();
                break;
            }
            case 7: {
                int pbuf = this.vram_buffer;
                int va = this.v_addr.getAddr();
                this.vram_buffer = this.read(va);
                if (va <= 16127) {
                    this.ppu_bus = pbuf;
                } else {
                    this.ppu_bus = this.vram_buffer;
                    this.vram_buffer = this.mapper.readNT(va);
                }
                this.incV();
            }
        }
        return this.ppu_bus;
    }

    private void read2004() {
        this.ppu_bus = this.dot <= 64 ? 255 : (this.dot <= 256 ? 0 : (this.dot <= 320 ? 255 : this.oamMem[this.oam_address] & 0xFF));
    }

    public final void write_register(int index, int val) {
        this.ppu_bus = val;
        this.dirty = 2;
        switch (index) {
            case 0: {
                this.ctrl.setValues(val, true);
                this.t_addr.setNT(this.ctrl.n);
                break;
            }
            case 1: {
                this.mask.value = val;
                this.calcMaskValues();
                break;
            }
            case 3: {
                this.oam_address = val;
                break;
            }
            case 4: {
                this.writeOAM(val);
                break;
            }
            case 5: {
                if (!this.read_latch) {
                    this.fx = val & 7;
                    this.t_addr.setCX(val >> 3);
                } else {
                    this.t_addr.setFY(val & 7);
                    this.t_addr.setCY(val >> 3);
                }
                this.read_latch = !this.read_latch;
                break;
            }
            case 6: {
                if (!this.read_latch) {
                    this.t_addr.setH(val & 0x3F);
                } else {
                    int o = this.v_addr.getR();
                    this.t_addr.setL(val);
                    int n = this.t_addr.getR();
                    this.v_addr.setR(n);
                    this.sendA12Clock(o, n);
                }
                this.read_latch = !this.read_latch;
                break;
            }
            case 7: {
                this.write(this.v_addr.getAddr(), val);
                this.incV();
            }
        }
    }

    private final void calcMaskValues() {
        this.mask.setValues();
        this.is_rendering = this.mask.bg != 0 || this.mask.sprite != 0;
    }

    private final void read2002() {
        this.read_latch = false;
        this.ppu_bus = this.ppu_bus & 0x1F | this.status.value & 0xE0;
        this.status.setVBlank(0);
        this.triggerNMI();
    }

    private final void writeOAM(int val) {
        if (this.is_rendering && (this.scanline < 240 || this.scanline == 261)) {
            return;
        }
        this.oamMem[this.oam_address] = val;
        this.oam_address = this.oam_address + 1 & 0xFF;
    }

    private final void sendA12Clock(int old_address, int new_address) {
        if ((old_address & 0x1000) == 0 && (new_address & 0x1000) != 0) {
            this.nes.mem.cartridge.getMapper().signalScanline();
        }
    }

    private void triggerNMI() {
        this.nes.cpu.setNMI(this.ctrl.getNMIOutput() != 0 && this.status.getVBlank() != 0);
    }

    private final void clearOAM() {
        for (int i = 0; i < this.sprite_limit; ++i) {
            this.s_oam[i].id = 64;
            this.s_oam[i].y = 255;
            this.s_oam[i].tile = 255;
            this.s_oam[i].attr = 255;
            this.s_oam[i].x = 255;
            this.s_oam[i].data_l = 0;
            this.s_oam[i].data_h = 0;
        }
    }

    private final void evalSprites() {
        if (!this.is_rendering) {
            return;
        }
        int n = -1;
        for (int i = 0; i < 64; ++i) {
            int j;
            int line = (this.scanline == 261 ? -1 : this.scanline) - this.oamMem[j = i * 4];
            if (line < 0 || line >= this.spriteHeight() || this.oamMem[j] == 255) continue;
            if (++n == 8) {
                this.status.setSpriteOF(1);
            }
            if (n == this.sprite_limit) break;
            this.s_oam[n].id = i;
            this.s_oam[n].y = this.oamMem[j];
            this.s_oam[n].tile = this.oamMem[j + 1];
            this.s_oam[n].attr = this.oamMem[j + 2];
            this.s_oam[n].x = this.oamMem[j + 3];
        }
    }

    private final void loadSprites() {
        for (int i = 0; i < this.sprite_limit; ++i) {
            this.oam[i].copyFrom(this.s_oam[i]);
            int addr = this.spriteHeight() == 16 ? (this.oam[i].tile & 1) * 4096 + (this.oam[i].tile & 0xFFFFFFFE) * 16 : this.ctrl.s * 4096 + this.oam[i].tile * 16;
            int sprite_y = (this.scanline - this.oam[i].y) % this.spriteHeight();
            if ((this.oam[i].attr & 0x80) != 0) {
                sprite_y ^= this.spriteHeight() - 1;
            }
            this.oam[i].data_l = this.read(addr += sprite_y + (sprite_y & 8));
            this.oam[i].data_h = this.read(addr + 8);
        }
    }

    private final void renderPixel() {
        int x = this.dot - 2;
        if (!this.skipping_render && this.scanline < 240 && x >= 0 && x < 256) {
            int palette = 0;
            int obj_palette = 0;
            boolean obj_priority = false;
            if (this.mask.bg != 0 && (this.mask.bg_left != 0 || x >= 8) && (palette = BitUtil.getByteFlag(this.bg_shift_h, 15 - this.fx) << 1 | BitUtil.getByteFlag(this.bg_shift_l, 15 - this.fx)) != 0) {
                palette |= (BitUtil.getByteFlag(this.at_shift_h, 7 - this.fx) << 1 | BitUtil.getByteFlag(this.at_shift_l, 7 - this.fx)) << 2;
            }
            if (this.mask.sprite != 0 && (this.mask.sprite_left != 0 || x >= 8)) {
                for (int i = this.sprite_limit - 1; i >= 0; --i) {
                    int s_palette;
                    int sprite_x;
                    if (this.oam[i].id == 64 || (sprite_x = x - this.oam[i].x & 0xFFFF) >= 8) continue;
                    if ((this.oam[i].attr & 0x40) != 0) {
                        sprite_x ^= 7;
                    }
                    if ((s_palette = BitUtil.getByteFlag(this.oam[i].data_h, 7 - sprite_x) << 1 | BitUtil.getByteFlag(this.oam[i].data_l, 7 - sprite_x)) == 0) continue;
                    if (this.oam[i].id == 0 && palette != 0 && x != 255) {
                        this.status.setSpriteHit(1);
                    }
                    obj_palette = (s_palette |= (this.oam[i].attr & 3) << 2) + 16;
                    obj_priority = (this.oam[i].attr & 0x20) != 0;
                }
            }
            if (!(obj_palette == 0 || palette != 0 && obj_priority)) {
                palette = obj_palette;
            }
            this.vbuffer[this.scanline * 256 + x] = this.mask.emphasis_add + this.read(16128 + (this.is_rendering ? palette : 0)) % 64;
        }
        this.bg_shift_l <<= 1;
        this.bg_shift_h <<= 1;
        this.at_shift_l = this.at_shift_l << 1 | (this.at_latch_l ? 1 : 0);
        this.at_shift_h = this.at_shift_h << 1 | (this.at_latch_h ? 1 : 0);
    }

    private final void scanlineVISIBLE(boolean pre) {
        if (this.dot >= 2 && this.dot <= 255 || this.dot >= 322 && this.dot <= 337) {
            this.renderPixel();
            switch (this.dot % 8) {
                case 1: {
                    this.address_bus = this.getNTAddress();
                    this.loadShiftReg();
                    break;
                }
                case 2: {
                    this.nt = this.read(this.address_bus);
                    break;
                }
                case 3: {
                    this.address_bus = this.getATAddress();
                    break;
                }
                case 4: {
                    this.at = this.read(this.address_bus);
                    if ((this.v_addr.getCY() & 2) != 0) {
                        this.at >>= 4;
                    }
                    if ((this.v_addr.getCX() & 2) == 0) break;
                    this.at >>= 2;
                    break;
                }
                case 5: {
                    this.address_bus = this.getBGAddress();
                    break;
                }
                case 6: {
                    this.bg_l = this.read(this.address_bus);
                    break;
                }
                case 7: {
                    this.address_bus = this.address_bus + 8 & 0xFFFF;
                    break;
                }
                case 0: {
                    this.bg_h = this.read(this.address_bus);
                    this.hScroll();
                }
            }
        } else if (this.dot >= 280 && this.dot <= 304) {
            if (pre) {
                this.vUpdate();
            }
        } else {
            switch (this.dot) {
                case 1: {
                    this.clearOAM();
                    if (pre) {
                        this.status.setSpriteOF(0);
                        this.status.setSpriteHit(0);
                    }
                    this.address_bus = this.getNTAddress();
                    if (!pre) break;
                    this.status.setVBlank(0);
                    this.triggerNMI();
                    break;
                }
                case 256: {
                    this.renderPixel();
                    this.bg_h = this.read(this.address_bus);
                    this.vScroll();
                    break;
                }
                case 257: {
                    this.evalSprites();
                    this.renderPixel();
                    this.loadShiftReg();
                    this.hUpdate();
                    break;
                }
                case 321: {
                    this.loadSprites();
                }
                case 339: {
                    this.address_bus = this.getNTAddress();
                    break;
                }
                case 340: {
                    if (pre && this.is_rendering && this.frame_odd) {
                        ++this.dot;
                    }
                }
                case 338: {
                    this.nt = this.read(this.address_bus);
                    break;
                }
                case 264: {
                    if (!this.is_rendering) break;
                    this.nes.mem.cartridge.getMapper().signalScanline();
                }
            }
        }
    }

    public void setRenderDirty() {
        this.dirty = 2;
    }

    private final void scanlinePOST() {
        if (this.dot == 0) {
            if (this.skipping_render) {
                --this.dirty;
            }
            if (this.nes.hasTV()) {
                this.vbuffer = this.nes.tv.submitNESFrame(this.vbuffer, this.dirty > 0);
                --this.dirty;
            }
        }
    }

    private final void scanlineNMI() {
        if (this.dot == 1) {
            this.status.setVBlank(1);
        } else if (this.dot == 4) {
            this.triggerNMI();
        }
    }

    public final void cycle() {
        if (++this.dot > 340) {
            this.dot %= 341;
            if (++this.scanline > 261) {
                this.scanline = 0;
                this.frame_odd = !this.frame_odd;
                ++this.rend_cycle;
            }
        }
        if (this.scanline <= 239) {
            this.scanlineVISIBLE(false);
        } else if (this.scanline == 240) {
            this.scanlinePOST();
        } else if (this.scanline == 241) {
            this.scanlineNMI();
        } else if (this.scanline == 261) {
            this.scanlineVISIBLE(true);
        }
        if (this.mapper.ppu_tick) {
            this.mapper.PPUTick();
        }
    }

    public final void reset() {
        this.frame_odd = false;
        this.scanline = 0;
        this.dot = 0;
        this.ctrl.value = 0;
        this.mask.value = 0;
        this.v_addr.value = 0;
        this.t_addr.value = 0;
        this.fx = 0;
        this.status.value = 0;
        this.nt = 0;
        this.at = 0;
        this.bg_l = 0;
        this.bg_h = 0;
        this.at_shift_l = 0;
        this.at_shift_h = 0;
        this.bg_shift_l = 0;
        this.bg_shift_h = 0;
        this.at_latch_l = false;
        this.at_latch_h = false;
        this.address_bus = 0;
        this.ppu_bus = 0;
        this.read_latch = false;
        Arrays.fill(this.vbuffer, 0);
        Arrays.fill(this.oamMem, 255);
        int[] cp = new int[]{9, 1, 0, 1, 0, 2, 2, 13, 8, 16, 8, 36, 0, 0, 4, 44, 9, 1, 52, 3, 0, 4, 0, 20, 8, 58, 0, 2, 0, 32, 44, 8};
        System.arraycopy(cp, 0, this.cgRAM, 0, cp.length);
        this.calcMaskValues();
        this.ctrl.setValues(this.ctrl.value, false);
        this.dirty = 2;
    }

    public void changeMapper(NESMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        ByteSerializer.serializationIntArray(info, this.cgRAM);
        ByteSerializer.serializationIntArray(info, this.oamMem);
        this.oam_address = ByteSerializer.serializationInt(info, this.oam_address);
        this.vram_buffer = ByteSerializer.serializationInt(info, this.vram_buffer);
        this.ctrl.value = ByteSerializer.serializationInt(info, this.ctrl.value);
        this.mask.value = ByteSerializer.serializationInt(info, this.mask.value);
        this.status.value = ByteSerializer.serializationInt(info, this.status.value);
        this.v_addr.value = ByteSerializer.serializationInt(info, this.v_addr.value);
        this.t_addr.value = ByteSerializer.serializationInt(info, this.t_addr.value);
        this.fx = ByteSerializer.serializationInt(info, this.fx);
        this.scanline = ByteSerializer.serializationInt(info, this.scanline);
        this.dot = ByteSerializer.serializationInt(info, this.dot);
        this.frame_odd = ByteSerializer.serializationBoolean(info, this.frame_odd);
        this.nt = ByteSerializer.serializationInt(info, this.nt);
        this.at = ByteSerializer.serializationInt(info, this.at);
        this.bg_l = ByteSerializer.serializationInt(info, this.bg_l);
        this.bg_h = ByteSerializer.serializationInt(info, this.bg_h);
        this.at_shift_l = ByteSerializer.serializationInt(info, this.at_shift_l);
        this.at_shift_h = ByteSerializer.serializationInt(info, this.at_shift_h);
        this.bg_shift_l = ByteSerializer.serializationInt(info, this.bg_shift_l);
        this.bg_shift_h = ByteSerializer.serializationInt(info, this.bg_shift_h);
        this.at_latch_l = ByteSerializer.serializationBoolean(info, this.at_latch_l);
        this.at_latch_h = ByteSerializer.serializationBoolean(info, this.at_latch_h);
        this.address_bus = ByteSerializer.serializationInt(info, this.address_bus);
        this.ppu_bus = ByteSerializer.serializationInt(info, this.ppu_bus);
        this.read_latch = ByteSerializer.serializationBoolean(info, this.read_latch);
        if (info.serializing) {
            ByteSerializer.serializationInt(info, this.sprite_limit);
        } else {
            int limit = ByteSerializer.serializationInt(info, -1);
            this.setSpriteLimit(limit);
            this.calcMaskValues();
            this.ctrl.setValues(this.ctrl.value, false);
            this.dirty = 2;
        }
    }

    public class Sprite {
        public int id;
        public int x;
        public int y;
        public int tile;
        public int attr;
        public int data_l;
        public int data_h;

        public final void copyFrom(Sprite s) {
            this.id = s.id;
            this.x = s.x;
            this.y = s.y;
            this.tile = s.tile;
            this.attr = s.attr;
            this.data_l = s.data_l;
            this.data_h = s.data_h;
        }
    }

    public class Addr {
        private int value;

        public final void setAddr(int v) {
            this.value = BitUtil.setBytePortion(this.value, 16383, v, 0);
        }

        public final int getAddr() {
            return this.value & 0x3FFF;
        }

        public final void setR(int v) {
            this.value = BitUtil.setBytePortion(this.value, Short.MAX_VALUE, v, 0);
        }

        public final int getR() {
            return this.value & Short.MAX_VALUE;
        }

        public final void setCX(int v) {
            this.value = BitUtil.setBytePortion(this.value, 31, v, 0);
        }

        public final int getCX() {
            return this.value & 0x1F;
        }

        public final void setCY(int v) {
            this.value = BitUtil.setBytePortion(this.value, 992, v, 5);
        }

        public final int getCY() {
            return (this.value & 0x3E0) >> 5;
        }

        public final void setNT(int v) {
            this.value = BitUtil.setBytePortion(this.value, 3072, v, 10);
        }

        public final int getNT() {
            return (this.value & 0xC00) >> 10;
        }

        public final void setFY(int v) {
            this.value = BitUtil.setBytePortion(this.value, 28672, v, 12);
        }

        public final int getFY() {
            return (this.value & 0x7000) >> 12;
        }

        public final void setL(int v) {
            this.value = BitUtil.setBytePortion(this.value, 255, v, 0);
        }

        public final int getL() {
            return this.value & 0xFF;
        }

        public final void setH(int v) {
            this.value = BitUtil.setBytePortion(this.value, 32512, v, 8);
        }

        public final int getH() {
            return (this.value & 0x7F00) >> 8;
        }
    }

    public class Status {
        public int value;

        public final void setSpriteOF(int v) {
            this.value = BitUtil.setByteFlag(this.value, 32, v);
        }

        public final void setSpriteHit(int v) {
            this.value = BitUtil.setByteFlag(this.value, 64, v);
        }

        public final void setVBlank(int v) {
            this.value = BitUtil.setByteFlag(this.value, 128, v);
        }

        public int getVBlank() {
            return (this.value & 0x80) >> 7;
        }
    }

    public class Mask {
        private int value;
        public int bg;
        public int bg_left;
        public int sprite;
        public int sprite_left;
        public int gray;
        public int emphasis_add;

        public final void setValues() {
            this.gray = this.value & 1;
            this.bg_left = this.value & 2;
            this.sprite_left = this.value & 4;
            this.bg = this.value & 8;
            this.sprite = this.value & 0x10;
            this.emphasis_add = (this.value & 0xE0) << 1;
        }

        public final int getEmphasis() {
            return (this.value & 0xE0) >> 5;
        }
    }

    public class Ctrl {
        public int value;
        public int n;
        public int i;
        public int s;
        public int b;
        public int h;
        public int p;

        public void setValues(int nvalue, boolean trigger) {
            int oldv = this.getNMIOutput();
            this.value = nvalue;
            this.n = this.value & 3;
            this.i = this.value & 4;
            this.s = (this.value & 8) >> 3;
            this.b = (this.value & 0x10) >> 4;
            this.h = this.value & 0x20;
            this.p = this.value & 0x40;
            if (trigger && oldv == 0) {
                NESPPU.this.triggerNMI();
            }
        }

        public int getNMIOutput() {
            return (this.value & 0x80) >> 7;
        }
    }
}

