/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.emucore.cpu.mos6502;

import com.youkaicountry.emucore.ICPUCall;
import com.youkaicountry.emucore.IMemRW;
import com.youkaicountry.emucore.cpu.exceptions.OpcodeNotFoundException;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class CPU6502
implements IByteSerialize {
    public final IMemRW memory;
    private float clock_speed;
    private float time_per_cycle;
    public int cycles_elapsed;
    public boolean cycle_odd = false;
    public static final int FLAG_NEGATIVE = 128;
    public static final int FLAG_OVERFLOW = 64;
    public static final int FLAG_UNUSED = 32;
    public static final int FLAG_BREAK = 16;
    public static final int FLAG_DECIMAL = 8;
    public static final int FLAG_INTERRUPT = 4;
    public static final int FLAG_ZERO = 2;
    public static final int FLAG_CARRY = 1;
    public static final int INT_NMI = 0;
    public static final int INT_RESET = 1;
    public static final int INT_IRQ = 2;
    public static final int INT_BRK = 3;
    public static final int[] IntVectors = new int[]{65530, 65532, 65534, 65534};
    public boolean pre_call_flag = false;
    ICPUCall pre_call;
    public int pc;
    public int a;
    public int x;
    public int y;
    public int s;
    public int p;
    protected boolean nmi;
    protected boolean irq;
    public int stack_start = 256;
    private final boolean decimal_math;
    public final boolean in_jmp_bug;
    int upc;
    boolean jumped;
    int branch_offset;
    public int data_bus;
    private boolean[] irq_lines;
    boolean irq_clearflag_delay;
    boolean irq_setflag_delay;
    private boolean nmi_delay;

    public CPU6502(IMemRW memory, int irq_lines, boolean decimal_math, boolean in_jmp_bug) {
        this.decimal_math = decimal_math;
        this.in_jmp_bug = in_jmp_bug;
        this.memory = memory;
        this.s = 255;
        this.initIRQ(irq_lines);
    }

    public float getClockSpeed() {
        return this.clock_speed;
    }

    private void initIRQ(int num) {
        this.irq_lines = new boolean[num];
    }

    private void clearIRQ() {
        for (int i = 0; i < this.irq_lines.length; ++i) {
            this.irq_lines[i] = false;
        }
        this.irq = false;
    }

    public final void setPreCall(ICPUCall call) {
        this.pre_call = call;
    }

    public void setPC(int pc) {
        this.pc = pc;
    }

    public void setClockSpeed(float clock_speed) {
        this.clock_speed = clock_speed;
        this.time_per_cycle = 1.0f / this.clock_speed;
    }

    protected void tk() {
        ++this.cycles_elapsed;
        this.cycle_odd = !this.cycle_odd;
    }

    public void doTicks(int num) {
        for (int i = 0; i < num; ++i) {
            this.tk();
        }
    }

    public void executeCycles(int cycles) {
    }

    public void setIRQ(int line, boolean value) {
        this.irq_lines[line] = value;
        this.irq = false;
        for (int i = 0; i < this.irq_lines.length; ++i) {
            if (!this.irq_lines[i]) continue;
            this.irq = true;
            return;
        }
    }

    public void setNMI(boolean value) {
        this.nmi = value;
    }

    public float executeTimeSlice(float time) throws OpcodeNotFoundException {
        float time_elapsed;
        for (time_elapsed = 0.0f; time_elapsed < time; time_elapsed += (float)this.cycles_elapsed * this.time_per_cycle) {
            this.executeInstruction();
        }
        return time_elapsed - time;
    }

    public boolean hasInterrupt() {
        return this.irq || this.irq && !this.getFlag(4);
    }

    protected void executeInstruction() throws OpcodeNotFoundException {
        this.cycles_elapsed = 0;
        if (this.nmi) {
            if (this.nmi_delay) {
                this.nmi_delay = false;
            } else {
                this.interrupt(0);
            }
        } else if (this.irq && (!this.getFlag(4) && !this.irq_clearflag_delay || this.getFlag(4) && this.irq_setflag_delay)) {
            this.interrupt(2);
        }
        this.irq_clearflag_delay = false;
        this.irq_setflag_delay = false;
        this.jumped = false;
        this.upc = this.pc;
        this.branch_offset = 0;
        if (this.pre_call_flag) {
            this.pre_call_flag = false;
            this.pre_call.call();
        }
        this.dispatchInstruction();
        if (!this.jumped) {
            if (this.branch_offset != 0) {
                int h = this.upc & 0xFF00;
                this.upc += (byte)this.branch_offset;
                if ((this.upc & 0xFF00) != h) {
                    this.tk();
                }
            }
            this.pc = this.upc & 0xFFFF;
        }
    }

    public void interrupt(int itype) {
        if (itype != 3) {
            this.tk();
            this.tk();
        }
        if (itype != 1) {
            if (itype == 3) {
                this.pc += 2;
            }
            this.stackPush(this.pc >> 8);
            this.stackPush(this.pc & 0xFF);
            this.stackPush(this.p | (itype == 3 ? 1 : 0) << 4);
        } else {
            this.s = this.s - 3 & 0xFF;
            this.tk();
            this.tk();
            this.tk();
        }
        this.p |= 4;
        int add = IntVectors[itype];
        this.pc = this.rd(add) | this.rd(add + 1) << 8;
        if (itype == 0) {
            this.setNMI(false);
        }
        this.jumped = true;
    }

    protected void dispatchInstruction() throws OpcodeNotFoundException {
        int opcode = this.consumeByte();
        switch (opcode) {
            case 0: {
                this.dummyRead();
                this.interrupt(3);
                break;
            }
            case 1: {
                this.a |= this.getMemIN(this.consumeByte(), this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 3: {
                int ad = this.getAddressIN(this.consumeByte(), this.x);
                int v = this.rd(ad);
                int c = v & 0x80;
                v = (v << 1 | this.p & 1) & 0xFF;
                this.wr(ad, v);
                this.setFlag(1, c);
                this.a |= v;
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 5: {
                this.a |= this.getMemZP();
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 6: {
                int add = this.consumeByte();
                int v = this.rd(add);
                this.setFlag(1, v & 0x80);
                v = v << 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 8: {
                this.tk();
                this.stackPush(this.p | 0x10);
                break;
            }
            case 9: {
                this.a |= this.consumeByte();
                this.setArithmeticFlags(this.a);
                break;
            }
            case 10: {
                this.setFlag(1, this.a & 0x80);
                this.a = this.a << 1 & 0xFF;
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 11: {
                this.a &= this.consumeByte();
                this.setArithmeticFlags(this.a);
                this.setFlag(1, this.a & 0x80);
                break;
            }
            case 12: {
                this.consumeByte();
                this.consumeByte();
                this.tk();
            }
            case 13: {
                int arg1 = this.consumeByte();
                this.a |= this.getMemAB(arg1, this.consumeByte(), 0);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 14: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                int v = this.rd(add);
                this.setFlag(1, v & 0x80);
                v = v << 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 16: {
                int s1 = this.consumeByte();
                if (this.getFlag(128)) break;
                this.tk();
                this.branch_offset = s1;
                break;
            }
            case 17: {
                this.a |= this.getMemIIX(this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 21: {
                this.a |= this.getMemZPX(this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 22: {
                int add = this.getAddressZPX(this.x);
                int v = this.rd(add);
                this.setFlag(1, v & 0x80);
                v = v << 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 24: {
                this.setFlag(1, 0);
                this.tk();
                break;
            }
            case 25: {
                int arg1 = this.consumeByte();
                this.a |= this.getMemABX(arg1, this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 29: {
                int arg1 = this.consumeByte();
                this.a |= this.getMemABX(arg1, this.consumeByte(), this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 30: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                int v = this.rd(add);
                this.setFlag(1, v & 0x80);
                v = v << 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                this.tk();
                break;
            }
            case 32: {
                int r2 = this.pc + 2;
                this.tk();
                this.stackPush((r2 & 0xFF00) >> 8);
                this.stackPush(r2 & 0xFF);
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                this.pc = this.getAddressAB(arg1, arg2, 0);
                this.jumped = true;
                break;
            }
            case 33: {
                this.a &= this.getMemIN(this.consumeByte(), this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 36: {
                int t1 = this.rd(this.consumeByte());
                this.setFlag(2, (t1 & this.a) == 0 ? 1 : 0);
                this.setFlag(64, t1 & 0x40);
                this.setFlag(128, t1 & 0x80);
                break;
            }
            case 37: {
                this.a &= this.getMemZP();
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 38: {
                int add = this.consumeByte();
                int v = this.rd(add);
                int c = v & 0x80;
                v = (v << 1 | this.p & 1) & 0xFF;
                this.wr(add, v);
                this.setFlag(1, c);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 40: {
                boolean oldi = this.getFlag(4);
                this.tk();
                int old = 0x30 & this.p;
                this.p = this.stackPop() & 0xCF | old;
                this.tk();
                boolean newi = this.getFlag(4);
                this.delayIFlag(oldi, newi);
                break;
            }
            case 41: {
                this.a &= this.consumeByte();
                this.setArithmeticFlags(this.a);
                break;
            }
            case 42: {
                int c = this.a & 0x80;
                this.a = (this.a << 1 | this.p & 1) & 0xFF;
                this.setFlag(1, c);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 44: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                int t1 = this.getMemAB(arg1, arg2, 0);
                this.setFlag(2, (t1 & this.a) == 0 ? 1 : 0);
                this.setFlag(64, t1 & 0x40);
                this.setFlag(128, t1 & 0x80);
                this.tk();
                break;
            }
            case 45: {
                int arg1 = this.consumeByte();
                this.a &= this.getMemAB(arg1, this.consumeByte(), 0);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 46: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                int v = this.rd(add);
                int c = v & 0x80;
                v = (v << 1 | this.p & 1) & 0xFF;
                this.wr(add, v);
                this.setFlag(1, c);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 48: {
                int s1 = this.consumeByte();
                if (!this.getFlag(128)) break;
                this.tk();
                this.branch_offset = s1;
                break;
            }
            case 49: {
                this.a &= this.getMemIIX(this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 53: {
                this.a &= this.getMemZPX(this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 54: {
                int add = this.getAddressZPX(this.x);
                int v = this.rd(add);
                int c = v & 0x80;
                v = (v << 1 | this.p & 1) & 0xFF;
                this.wr(add, v);
                this.setFlag(1, c);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 56: {
                this.setFlag(1, 1);
                this.tk();
                break;
            }
            case 57: {
                int arg1 = this.consumeByte();
                this.a &= this.getMemABX(arg1, this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 61: {
                int arg1 = this.consumeByte();
                this.a &= this.getMemABX(arg1, this.consumeByte(), this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 62: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                int v = this.rd(add);
                int c = v & 0x80;
                v = (v << 1 | this.p & 1) & 0xFF;
                this.wr(add, v);
                this.setFlag(1, c);
                this.setArithmeticFlags(v);
                this.tk();
                this.tk();
                break;
            }
            case 64: {
                this.tk();
                this.dummyRead();
                this.p = this.stackPop() | 0x20;
                int arg1 = this.stackPop();
                this.pc = this.getAddressAB(arg1, this.stackPop(), 0);
                this.jumped = true;
                break;
            }
            case 65: {
                this.a ^= this.getMemIN(this.consumeByte(), this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 69: {
                this.a ^= this.getMemZP();
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 70: {
                int add = this.consumeByte();
                int v = this.rd(add);
                this.setFlag(1, v & 1);
                this.wr(add, v >>= 1);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 72: {
                this.tk();
                this.stackPush(this.a);
                break;
            }
            case 73: {
                this.a ^= this.consumeByte();
                this.setArithmeticFlags(this.a);
                break;
            }
            case 74: {
                this.setFlag(1, this.a & 1);
                this.a >>= 1;
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 76: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                this.pc = this.getAddressAB(arg1, arg2, 0);
                this.jumped = true;
                break;
            }
            case 77: {
                int arg1 = this.consumeByte();
                this.a ^= this.getMemAB(arg1, this.consumeByte(), 0);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 78: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                int v = this.rd(add);
                this.setFlag(1, v & 1);
                this.wr(add, v >>= 1);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 80: {
                int s1 = this.consumeByte();
                if (this.getFlag(64)) break;
                this.tk();
                this.branch_offset = s1;
                break;
            }
            case 81: {
                this.a ^= this.getMemIIX(this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 85: {
                this.a ^= this.getMemZPX(this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 86: {
                int add = this.getAddressZPX(this.x);
                int v = this.rd(add);
                this.setFlag(1, v & 1);
                this.wr(add, v >>= 1);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 88: {
                this.irq_clearflag_delay = this.getFlag(4);
                this.setFlag(4, 0);
                this.tk();
                break;
            }
            case 89: {
                int arg1 = this.consumeByte();
                this.a ^= this.getMemABX(arg1, this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 93: {
                int arg1 = this.consumeByte();
                this.a ^= this.getMemABX(arg1, this.consumeByte(), this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 94: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                int v = this.rd(add);
                this.setFlag(1, v & 1);
                this.wr(add, v >>= 1);
                this.setArithmeticFlags(v);
                this.tk();
                this.tk();
                break;
            }
            case 96: {
                this.tk();
                this.tk();
                int arg1 = this.stackPop();
                int arg2 = this.stackPop();
                this.pc = this.getAddressAB(arg1, arg2, 0) + 1;
                this.dummyRead();
                this.jumped = true;
                break;
            }
            case 97: {
                this.add(this.getMemIN(this.consumeByte(), this.x));
                this.tk();
                break;
            }
            case 101: {
                this.add(this.getMemZP());
                this.tk();
                break;
            }
            case 102: {
                int add = this.consumeByte();
                int v = this.rd(add);
                int c = v & 1;
                v = v >> 1 | (this.p & 1) << 7;
                this.wr(add, v);
                this.setFlag(1, c);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 104: {
                this.tk();
                this.tk();
                this.a = this.stackPop();
                this.setArithmeticFlags(this.a);
                break;
            }
            case 105: {
                this.add(this.consumeByte());
                break;
            }
            case 106: {
                int c = this.a & 1;
                this.a = this.a >> 1 | (this.p & 1) << 7;
                this.setFlag(1, c);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 108: {
                if (this.in_jmp_bug) {
                    int arg1 = this.consumeByte();
                    int r1 = this.getAddressAB(arg1, this.consumeByte(), 0);
                    this.pc = this.getAddressAB(this.memory.read(r1), this.rd(r1 & 0xFF00 | (r1 & 0xFF) + 1 & 0xFF), 0);
                    this.jumped = true;
                    this.tk();
                    break;
                }
                int arg1 = this.consumeByte();
                int r1 = this.getAddressAB(arg1, this.consumeByte(), 0);
                this.pc = this.getAddressAB(this.rd(r1), this.memory.read(r1 + 1), 0);
                this.jumped = true;
                this.tk();
                break;
            }
            case 109: {
                int arg1 = this.consumeByte();
                this.add(this.getMemAB(arg1, this.consumeByte(), 0));
                this.tk();
                break;
            }
            case 110: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                int v = this.rd(add);
                int c = v & 1;
                v = v >> 1 | (this.p & 1) << 7;
                this.wr(add, v);
                this.setFlag(1, c);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 112: {
                int s1 = this.consumeByte();
                if (!this.getFlag(64)) break;
                this.tk();
                this.branch_offset = s1;
                break;
            }
            case 113: {
                this.add(this.getMemIIX(this.consumeByte(), this.y));
                this.tk();
                break;
            }
            case 117: {
                this.add(this.getMemZPX(this.x));
                this.tk();
                break;
            }
            case 118: {
                int add = this.getAddressZPX(this.x);
                int v = this.rd(add);
                int c = v & 1;
                v = v >> 1 | (this.p & 1) << 7;
                this.wr(add, v);
                this.setFlag(1, c);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 120: {
                this.irq_setflag_delay = !this.getFlag(4);
                this.setFlag(4, 1);
                this.tk();
                break;
            }
            case 121: {
                int arg1 = this.consumeByte();
                this.add(this.getMemABX(arg1, this.consumeByte(), this.y));
                this.tk();
                break;
            }
            case 125: {
                int arg1 = this.consumeByte();
                this.add(this.getMemABX(arg1, this.consumeByte(), this.x));
                this.tk();
                break;
            }
            case 126: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                int v = this.rd(add);
                int c = v & 1;
                v = v >> 1 | (this.p & 1) << 7;
                this.wr(add, v);
                this.setFlag(1, c);
                this.setArithmeticFlags(v);
                this.tk();
                this.tk();
                break;
            }
            case 129: {
                int r1 = this.getAddressIN(this.consumeByte(), this.x);
                this.wr(r1, this.a);
                this.tk();
                break;
            }
            case 132: {
                int r1 = this.consumeByte();
                this.wr(r1, this.y);
                break;
            }
            case 133: {
                int r1 = this.consumeByte();
                this.wr(r1, this.a);
                break;
            }
            case 134: {
                int r1 = this.consumeByte();
                this.wr(r1, this.x);
                break;
            }
            case 136: {
                this.y = this.y - 1 & 0xFF;
                this.setArithmeticFlags(this.y);
                this.tk();
                break;
            }
            case 138: {
                this.a = this.x;
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 140: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                int r1 = this.getAddressAB(arg1, arg2, 0);
                this.wr(r1, this.y);
                break;
            }
            case 141: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                int r1 = this.getAddressAB(arg1, arg2, 0);
                this.wr(r1, this.a);
                break;
            }
            case 142: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                int r1 = this.getAddressAB(arg1, arg2, 0);
                this.wr(r1, this.x);
                break;
            }
            case 143: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                int abs = this.getAddressAB(arg1, arg2, 0);
                int r = this.a & this.x;
                this.wr(abs, r);
                break;
            }
            case 144: {
                int s1 = this.consumeByte();
                if (this.getFlag(1)) break;
                this.tk();
                this.branch_offset = s1;
                break;
            }
            case 145: {
                int abs = this.getAddressIIX(this.consumeByte(), 0);
                this.dummyRead(abs, this.y);
                this.wr(abs + this.y, this.a);
                break;
            }
            case 148: {
                int r1 = this.getAddressZPX(this.x);
                this.wr(r1, this.y);
                break;
            }
            case 149: {
                int r1 = this.getAddressZPX(this.x);
                this.wr(r1, this.a);
                break;
            }
            case 150: {
                int r1 = this.getAddressZPX(this.y);
                this.wr(r1, this.x);
                break;
            }
            case 152: {
                this.a = this.y;
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 153: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                int r1 = this.getAddressAB(arg1, arg2, this.y);
                this.wr(r1, this.a);
                this.tk();
                break;
            }
            case 154: {
                this.s = this.x;
                this.tk();
                break;
            }
            case 157: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                int abs = this.getAddressAB(arg1, arg2, 0);
                this.dummyRead(abs, this.x);
                this.wr(abs + this.x, this.a);
                break;
            }
            case 160: {
                this.y = this.consumeByte();
                this.setArithmeticFlags(this.y);
                break;
            }
            case 161: {
                this.a = this.getMemIN(this.consumeByte(), this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 162: {
                this.x = this.consumeByte();
                this.setArithmeticFlags(this.x);
                break;
            }
            case 164: {
                this.y = this.getMemZP();
                this.setArithmeticFlags(this.y);
                this.tk();
                break;
            }
            case 165: {
                this.a = this.getMemZP();
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 166: {
                this.x = this.getMemZP();
                this.setArithmeticFlags(this.x);
                this.tk();
                break;
            }
            case 168: {
                this.y = this.a;
                this.setArithmeticFlags(this.y);
                this.tk();
                break;
            }
            case 169: {
                this.a = this.consumeByte();
                this.setArithmeticFlags(this.a);
                break;
            }
            case 170: {
                this.x = this.a;
                this.setArithmeticFlags(this.x);
                this.tk();
                break;
            }
            case 172: {
                int arg1 = this.consumeByte();
                this.y = this.getMemAB(arg1, this.consumeByte(), 0);
                this.setArithmeticFlags(this.y);
                this.tk();
                break;
            }
            case 173: {
                this.tk();
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                this.a = this.getMemAB(arg1, arg2, 0);
                this.setArithmeticFlags(this.a);
                break;
            }
            case 174: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                this.x = this.getMemAB(arg1, arg2, 0);
                this.setArithmeticFlags(this.x);
                this.tk();
                break;
            }
            case 176: {
                int s1 = this.consumeByte();
                if (!this.getFlag(1)) break;
                this.tk();
                this.branch_offset = s1;
                break;
            }
            case 177: {
                this.a = this.getMemIIX(this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 179: {
                this.x = this.a = this.getMemIIX(this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 180: {
                this.y = this.getMemZPX(this.x);
                this.setArithmeticFlags(this.y);
                this.tk();
                break;
            }
            case 181: {
                this.a = this.getMemZPX(this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 182: {
                this.x = this.getMemZPX(this.y);
                this.setArithmeticFlags(this.x);
                this.tk();
                break;
            }
            case 184: {
                this.setFlag(64, 0);
                this.tk();
                break;
            }
            case 185: {
                int arg1 = this.consumeByte();
                this.a = this.getMemABX(arg1, this.consumeByte(), this.y);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 186: {
                this.x = this.s;
                this.setArithmeticFlags(this.x);
                this.tk();
                break;
            }
            case 188: {
                int arg1 = this.consumeByte();
                this.y = this.getMemABX(arg1, this.consumeByte(), this.x);
                this.setArithmeticFlags(this.y);
                this.tk();
                break;
            }
            case 189: {
                int arg1 = this.consumeByte();
                this.a = this.getMemABX(arg1, this.consumeByte(), this.x);
                this.setArithmeticFlags(this.a);
                this.tk();
                break;
            }
            case 190: {
                int arg1 = this.consumeByte();
                int arg2 = this.consumeByte();
                this.x = this.getMemABX(arg1, arg2, this.y);
                this.setArithmeticFlags(this.x);
                this.tk();
                break;
            }
            case 192: {
                this.compare(this.consumeByte(), this.y);
                break;
            }
            case 193: {
                this.compare(this.getMemIN(this.consumeByte(), this.x), this.a);
                this.tk();
                break;
            }
            case 196: {
                this.compare(this.getMemZP(), this.y);
                this.tk();
                break;
            }
            case 197: {
                this.compare(this.getMemZP(), this.a);
                this.tk();
                break;
            }
            case 198: {
                int add = this.consumeByte();
                int v = this.rd(add) - 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 199: {
                int add = this.consumeByte();
                int v = this.rd(add);
                if (--v < 0) {
                    v = 255;
                    this.setFlag(1, 1);
                }
                this.wr(add, v);
                this.tk();
            }
            case 200: {
                this.y = this.y + 1 & 0xFF;
                this.setArithmeticFlags(this.y);
                this.tk();
                break;
            }
            case 201: {
                this.compare(this.consumeByte(), this.a);
                break;
            }
            case 202: {
                this.x = this.x - 1 & 0xFF;
                this.setArithmeticFlags(this.x);
                this.tk();
                break;
            }
            case 203: {
                this.x &= this.a;
                this.x = this.x - this.consumeByte() & 0xFF;
                break;
            }
            case 204: {
                this.compare(this.getMemAB(this.consumeByte(), this.consumeByte(), 0), this.y);
                this.tk();
                break;
            }
            case 205: {
                int arg1 = this.consumeByte();
                this.compare(this.getMemAB(arg1, this.consumeByte(), 0), this.a);
                this.tk();
                break;
            }
            case 206: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                int v = this.rd(add) - 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 208: {
                int s1 = this.consumeByte();
                if (this.getFlag(2)) break;
                this.tk();
                this.branch_offset = s1;
                break;
            }
            case 209: {
                this.compare(this.getMemIIX(this.consumeByte(), this.y), this.a);
                this.tk();
                break;
            }
            case 213: {
                this.compare(this.getMemZPX(this.x), this.a);
                this.tk();
                break;
            }
            case 214: {
                int add = this.getAddressZPX(this.x);
                int v = this.rd(add) - 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 216: {
                this.setFlag(8, 0);
                this.tk();
                break;
            }
            case 217: {
                int arg1 = this.consumeByte();
                this.compare(this.getMemABX(arg1, this.consumeByte(), this.y), this.a);
                this.tk();
                break;
            }
            case 221: {
                int arg1 = this.consumeByte();
                this.compare(this.getMemABX(arg1, this.consumeByte(), this.x), this.a);
                this.tk();
                break;
            }
            case 222: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                int v = this.rd(add) - 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                this.tk();
                break;
            }
            case 224: {
                this.compare(this.consumeByte(), this.x);
                break;
            }
            case 225: {
                this.sub(this.getMemIN(this.consumeByte(), this.x));
                this.tk();
                break;
            }
            case 228: {
                this.compare(this.getMemZP(), this.x);
                this.tk();
                break;
            }
            case 229: {
                this.sub(this.getMemZP());
                this.tk();
                break;
            }
            case 230: {
                int add = this.consumeByte();
                int v = this.rd(add) + 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 232: {
                this.x = this.x + 1 & 0xFF;
                this.setArithmeticFlags(this.x);
                this.tk();
                break;
            }
            case 233: {
                this.sub(this.consumeByte());
                break;
            }
            case 234: {
                this.tk();
                break;
            }
            case 236: {
                this.compare(this.getMemAB(this.consumeByte(), this.consumeByte(), 0), this.x);
                this.tk();
                break;
            }
            case 237: {
                int arg1 = this.consumeByte();
                this.sub(this.getMemAB(arg1, this.consumeByte(), 0));
                this.tk();
                break;
            }
            case 238: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                int v = this.rd(add);
                this.memory.write(add, v);
                v = v + 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 240: {
                int s1 = this.consumeByte();
                if (!this.getFlag(2)) break;
                this.tk();
                this.branch_offset = s1;
                break;
            }
            case 241: {
                this.sub(this.getMemIIX(this.consumeByte(), this.y));
                this.tk();
                break;
            }
            case 245: {
                this.sub(this.getMemZPX(this.x));
                this.tk();
                break;
            }
            case 246: {
                int add = this.getAddressZPX(this.x);
                int v = this.rd(add) + 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                break;
            }
            case 248: {
                this.setFlag(8, 1);
                this.tk();
                break;
            }
            case 249: {
                int arg1 = this.consumeByte();
                this.sub(this.getMemABX(arg1, this.consumeByte(), this.y));
                this.tk();
                break;
            }
            case 253: {
                int arg1 = this.consumeByte();
                this.sub(this.getMemABX(arg1, this.consumeByte(), this.x));
                this.tk();
                break;
            }
            case 254: {
                int arg1 = this.consumeByte();
                int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                int v = this.rd(add) + 1 & 0xFF;
                this.wr(add, v);
                this.setArithmeticFlags(v);
                this.tk();
                this.tk();
                break;
            }
            default: {
                this.instructionNotFound(opcode);
            }
        }
    }

    protected void instructionNotFound(int opcode) throws OpcodeNotFoundException {
        throw new OpcodeNotFoundException(opcode, this.upc - 1);
    }

    protected int rd(int address) {
        this.tk();
        return this.memory.read(address);
    }

    protected void wr(int address, int val) {
        this.tk();
        this.memory.write(address, val);
    }

    protected final void dummyRead() {
        this.rd(this.upc);
    }

    protected final int consumeByte() {
        return this.rd(this.upc++);
    }

    protected final int getAddressAB(int low, int high, int offset) {
        return offset + (low | high << 8) & 0xFFFF;
    }

    protected final int getAddressIN(int address, int offset) {
        int l = address + offset & 0xFF;
        return this.getAddressAB(this.rd(l), this.rd(l + 1 & 0xFF), 0);
    }

    protected final void setFlag(int flag, int set) {
        this.p = set != 0 ? (this.p |= flag) : (this.p &= ~flag & 0xFF);
    }

    protected final void setArithmeticFlags(int val) {
        this.setFlag(2, val == 0 ? 1 : 0);
        this.setFlag(128, val & 0x80);
    }

    protected final boolean getFlag(int flag) {
        return (this.p & flag) > 0;
    }

    public final void stackPush(int val) {
        this.wr(this.s-- + this.stack_start, val);
        this.s &= 0xFF;
    }

    protected final int stackPop() {
        this.s = this.s + 1 & 0xFF;
        return this.rd(this.s + this.stack_start);
    }

    protected final void compare(int mem, int reg) {
        this.setFlag(1, reg >= mem ? 1 : 0);
        this.setFlag(2, reg == mem ? 1 : 0);
        this.setFlag(128, 0x80 & (reg - mem & 0xFF));
    }

    private int bDecimal(int val) {
        return 10 * (val >> 4) + (0xF & val);
    }

    protected final int getMemAB(int low, int high, int offset) {
        return this.memory.read(this.getAddressAB(low, high, offset));
    }

    protected final int getMemABX(int low, int high, int offset) {
        int add = this.getAddressAB(low, high, offset);
        this.crossTick(add - offset, offset, low, high);
        return this.memory.read(add);
    }

    protected final int getMemIN(int address, int offset) {
        return this.rd(this.getAddressIN(address, offset));
    }

    protected final int getMemIIX(int address, int offset) {
        return this.getMemABX(this.rd(address), this.rd(address + 1 & 0xFF), offset);
    }

    protected final int getAddressIIX(int address, int offset) {
        return this.getAddressAB(this.rd(address), this.rd(address + 1 & 0xFF), offset);
    }

    protected final int getMemZP() {
        return this.memory.read(this.consumeByte());
    }

    protected final int getMemZPX(int x) {
        return this.rd(this.consumeByte() + x & 0xFF);
    }

    protected int getAddressZPX(int x) {
        this.tk();
        return this.consumeByte() + x & 0xFF;
    }

    protected final boolean cross(int a, int b) {
        return (a + b & 0xFF00) != (a & 0xFF00);
    }

    protected void crossTick(int a, int b, int low, int high) {
        if (this.cross(a, b)) {
            int abs = this.getAddressAB(low, high, 0);
            this.rd(abs + b - 256);
        }
    }

    protected final void dummyRead(int abs, int offset) {
        this.rd(abs & 0xFF00 | abs + offset & 0xFF);
    }

    protected final void add(int r1) {
        int nr = r1;
        if (this.decimal_math && this.getFlag(8)) {
            nr = this.bDecimal(r1) + this.bDecimal(this.a) + (this.getFlag(1) ? 1 : 0);
            this.setFlag(1, nr > 99 ? 1 : 0);
        } else {
            this.setFlag(1, (nr += this.a + (this.getFlag(1) ? 1 : 0)) & 0xFF00);
        }
        this.setFlag(64, ~(this.a ^ r1) & (this.a ^ (nr &= 0xFF)) & 0x80);
        this.setFlag(2, nr == 0 ? 1 : 0);
        this.setFlag(128, nr & 0x80);
        this.a = nr;
    }

    protected final void sub(int r1) {
        if (!this.decimal_math || !this.getFlag(8)) {
            this.add(~r1 & 0xFF);
            return;
        }
        r1 = this.bDecimal(this.a) - this.bDecimal(r1) - (this.getFlag(1) ? 0 : 1);
        this.setFlag(64, r1 > 99 || r1 < 0 ? 1 : 0);
        this.setFlag(1, r1 < 0 ? 0 : 1);
        this.setFlag(64, ~(this.a ^ (r1 &= 0xFF)) & (this.a ^ r1) & 0x80);
        this.setFlag(2, r1 == 0 ? 1 : 0);
        this.setFlag(128, r1 & 0x80);
        this.a = r1;
    }

    protected final void delayIFlag(boolean oldi, boolean newi) {
        if (oldi & !newi) {
            this.irq_clearflag_delay = true;
        } else if (newi & !oldi) {
            this.irq_setflag_delay = true;
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        this.cycles_elapsed = ByteSerializer.serializationInt(info, this.cycles_elapsed);
        this.cycle_odd = ByteSerializer.serializationBoolean(info, this.cycle_odd);
        this.pc = ByteSerializer.serializationInt(info, this.pc);
        this.a = ByteSerializer.serializationInt(info, this.a);
        this.x = ByteSerializer.serializationInt(info, this.x);
        this.y = ByteSerializer.serializationInt(info, this.y);
        this.s = ByteSerializer.serializationInt(info, this.s);
        this.p = ByteSerializer.serializationInt(info, this.p);
        this.pre_call_flag = ByteSerializer.serializationBoolean(info, this.pre_call_flag);
        this.irq = ByteSerializer.serializationBoolean(info, this.irq);
        this.nmi = ByteSerializer.serializationBoolean(info, this.nmi);
        this.data_bus = ByteSerializer.serializationInt(info, this.data_bus);
        ByteSerializer.serializationBooleanArray(info, this.irq_lines);
        this.irq_clearflag_delay = ByteSerializer.serializationBoolean(info, this.irq_clearflag_delay);
        this.irq_setflag_delay = ByteSerializer.serializationBoolean(info, this.irq_setflag_delay);
        this.nmi_delay = ByteSerializer.serializationBoolean(info, this.nmi_delay);
    }

    public void reset() {
        this.cycles_elapsed = 0;
        this.cycle_odd = false;
        this.pc = 0;
        this.p = 36;
        this.a = 0;
        this.x = 0;
        this.y = 0;
        this.s = 0;
        this.pre_call_flag = false;
        this.clearIRQ();
        this.setNMI(false);
        this.data_bus = 0;
        this.irq_clearflag_delay = false;
        this.irq_setflag_delay = false;
        this.nmi_delay = false;
        this.interrupt(1);
    }
}

