/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.emucore.cpu.mos6502;

import com.youkaicountry.emucore.IMemRW;
import com.youkaicountry.emucore.cpu.exceptions.OpcodeNotFoundException;
import com.youkaicountry.emucore.cpu.mos6502.CPU6502;
import com.youkaicountry.emucore.cpu.mos6502.CPU6502Tables;

public class CPU6502Fast
extends CPU6502 {
    int opcode;
    protected int tcycles;

    public CPU6502Fast(IMemRW memory, int irq_lines, boolean decimal_math, boolean in_jmp_bug) {
        super(memory, irq_lines, decimal_math, in_jmp_bug);
    }

    @Override
    protected void tk() {
        this.cycle_odd = !this.cycle_odd;
        this.tcycles = 0;
    }

    @Override
    public void interrupt(int itype) {
        if (itype != 3) {
            this.tcycles += 2;
        }
        if (itype != 1) {
            if (itype == 3) {
                this.pc += 2;
            }
            this.stackPush(this.pc >> 8);
            this.stackPush(this.pc & 0xFF);
            this.stackPush(this.p | (itype == 3 ? 1 : 0) << 4);
            this.tcycles += 3;
        } else {
            this.s = this.s - 3 & 0xFF;
            this.tcycles += 3;
        }
        this.p |= 4;
        this.tcycles += 2;
        int add = IntVectors[itype];
        this.pc = this.rd(add) | this.rd(add + 1) << 8;
        if (itype == 0) {
            this.setNMI(false);
        }
        this.jumped = true;
        this.tk();
    }

    @Override
    public void executeInstruction() throws OpcodeNotFoundException {
        this.tcycles = 0;
        this.cycles_elapsed = 0;
        if (this.nmi) {
            this.interrupt(0);
        } else if (this.irq && (!this.getFlag(4) && !this.irq_clearflag_delay || this.getFlag(4) && this.irq_setflag_delay)) {
            this.interrupt(2);
        }
        this.irq_clearflag_delay = false;
        this.irq_setflag_delay = false;
        this.jumped = false;
        this.upc = this.pc;
        this.branch_offset = 0;
        if (this.pre_call_flag) {
            this.pre_call_flag = false;
            this.pre_call.call();
            return;
        }
        this.dispatchInstruction();
        if (!this.jumped) {
            if (this.branch_offset != 0) {
                int h = this.upc & 0xFF00;
                this.upc += (byte)this.branch_offset;
                if ((this.upc & 0xFF00) != h) {
                    ++this.tcycles;
                }
            }
            this.pc = this.upc & 0xFFFF;
        }
        this.tk();
    }

    @Override
    protected final int rd(int address) {
        return this.memory.read(address);
    }

    @Override
    protected final void wr(int address, int val) {
        this.memory.write(address, val);
    }

    @Override
    protected final int getAddressZPX(int x) {
        return this.consumeByte() + x & 0xFF;
    }

    @Override
    protected final void crossTick(int a, int b, int low, int high) {
        if (this.cross(a, b)) {
            int abs = this.getAddressAB(low, high, 0);
            this.rd(abs + b - 256);
            ++this.tcycles;
        }
    }

    @Override
    protected void dispatchInstruction() throws OpcodeNotFoundException {
        this.opcode = this.consumeByte();
        this.tcycles += CPU6502Tables.instruction_cycles[this.opcode];
        block0 : switch (this.opcode & 0xF0) {
            case 0: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        this.dummyRead();
                        this.tcycles += 2;
                        this.interrupt(3);
                        break block0;
                    }
                    case 1: {
                        this.a |= this.getMemIN(this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 5: {
                        this.a |= this.getMemZP();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 6: {
                        int add = this.consumeByte();
                        int v = this.rd(add);
                        this.setFlag(1, v & 0x80);
                        v = v << 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                    case 8: {
                        this.stackPush(this.p | 0x10);
                        break block0;
                    }
                    case 9: {
                        this.a |= this.consumeByte();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 10: {
                        this.setFlag(1, this.a & 0x80);
                        this.a = this.a << 1 & 0xFF;
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 11: {
                        this.a &= this.consumeByte();
                        this.setArithmeticFlags(this.a);
                        this.setFlag(1, this.a & 0x80);
                        break block0;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.a |= this.getMemAB(arg1, this.consumeByte(), 0);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                        int v = this.rd(add);
                        this.setFlag(1, v & 0x80);
                        v = v << 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                }
                this.instructionNotFound(this.opcode);
                break;
            }
            case 16: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int s1 = this.consumeByte();
                        if (this.getFlag(128)) break block0;
                        ++this.tcycles;
                        this.branch_offset = s1;
                        break;
                    }
                    case 1: {
                        this.a |= this.getMemIIX(this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 5: {
                        this.a |= this.getMemZPX(this.x);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 6: {
                        int add = this.getAddressZPX(this.x);
                        int v = this.rd(add);
                        this.setFlag(1, v & 0x80);
                        v = v << 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    case 8: {
                        this.setFlag(1, 0);
                        break;
                    }
                    case 9: {
                        int arg1 = this.consumeByte();
                        this.a |= this.getMemABX(arg1, this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.a |= this.getMemABX(arg1, this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                        int v = this.rd(add);
                        this.setFlag(1, v & 0x80);
                        v = v << 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    default: {
                        this.instructionNotFound(this.opcode);
                        break;
                    }
                }
                break;
            }
            case 32: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int r1;
                        int r2 = this.pc + 2;
                        this.stackPush((r2 & 0xFF00) >> 8);
                        this.stackPush(r2 & 0xFF);
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        this.pc = r1 = this.getAddressAB(arg1, arg2, 0);
                        this.jumped = true;
                        break block0;
                    }
                    case 1: {
                        this.a &= this.getMemIN(this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 4: {
                        int t1 = this.rd(this.consumeByte());
                        this.setFlag(2, (t1 & this.a) == 0 ? 1 : 0);
                        this.setFlag(64, t1 & 0x40);
                        this.setFlag(128, t1 & 0x80);
                        break block0;
                    }
                    case 5: {
                        this.a &= this.getMemZP();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 6: {
                        int add = this.consumeByte();
                        int v = this.rd(add);
                        int c = v & 0x80;
                        v = (v << 1 | this.p & 1) & 0xFF;
                        this.wr(add, v);
                        this.setFlag(1, c);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                    case 8: {
                        boolean oldi = this.getFlag(4);
                        int old = 0x30 & this.p;
                        this.p = this.stackPop() & 0xCF | old;
                        boolean newi = this.getFlag(4);
                        this.delayIFlag(oldi, newi);
                        break block0;
                    }
                    case 9: {
                        this.a &= this.consumeByte();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 10: {
                        int c = this.a & 0x80;
                        this.a = (this.a << 1 | this.p & 1) & 0xFF;
                        this.setFlag(1, c);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 12: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        int t1 = this.getMemAB(arg1, arg2, 0);
                        this.setFlag(2, (t1 & this.a) == 0 ? 1 : 0);
                        this.setFlag(64, t1 & 0x40);
                        this.setFlag(128, t1 & 0x80);
                        break block0;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.a &= this.getMemAB(arg1, this.consumeByte(), 0);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                        int v = this.rd(add);
                        int c = v & 0x80;
                        v = (v << 1 | this.p & 1) & 0xFF;
                        this.wr(add, v);
                        this.setFlag(1, c);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                }
                this.instructionNotFound(this.opcode);
                break;
            }
            case 48: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int s1 = this.consumeByte();
                        if (!this.getFlag(128)) break block0;
                        ++this.tcycles;
                        this.branch_offset = s1;
                        break;
                    }
                    case 1: {
                        this.a &= this.getMemIIX(this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 5: {
                        this.a &= this.getMemZPX(this.x);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 6: {
                        int add = this.getAddressZPX(this.x);
                        int v = this.rd(add);
                        int c = v & 0x80;
                        v = (v << 1 | this.p & 1) & 0xFF;
                        this.wr(add, v);
                        this.setFlag(1, c);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    case 8: {
                        this.setFlag(1, 1);
                        break;
                    }
                    case 9: {
                        int arg1 = this.consumeByte();
                        this.a &= this.getMemABX(arg1, this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.a &= this.getMemABX(arg1, this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                        int v = this.rd(add);
                        int c = v & 0x80;
                        v = (v << 1 | this.p & 1) & 0xFF;
                        this.wr(add, v);
                        this.setFlag(1, c);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    default: {
                        this.instructionNotFound(this.opcode);
                        break;
                    }
                }
                break;
            }
            case 64: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        this.dummyRead();
                        this.p = this.stackPop() | 0x20;
                        int arg1 = this.stackPop();
                        this.pc = this.getAddressAB(arg1, this.stackPop(), 0);
                        this.jumped = true;
                        break block0;
                    }
                    case 1: {
                        this.a ^= this.getMemIN(this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 5: {
                        this.a ^= this.getMemZP();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 6: {
                        int add = this.consumeByte();
                        int v = this.rd(add);
                        this.setFlag(1, v & 1);
                        this.wr(add, v >>= 1);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                    case 8: {
                        this.stackPush(this.a);
                        break block0;
                    }
                    case 9: {
                        this.a ^= this.consumeByte();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 10: {
                        this.setFlag(1, this.a & 1);
                        this.a >>= 1;
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 12: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        this.pc = this.getAddressAB(arg1, arg2, 0);
                        this.jumped = true;
                        break block0;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.a ^= this.getMemAB(arg1, this.consumeByte(), 0);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                        int v = this.rd(add);
                        this.setFlag(1, v & 1);
                        this.wr(add, v >>= 1);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                }
                this.instructionNotFound(this.opcode);
                break;
            }
            case 80: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int s1 = this.consumeByte();
                        if (this.getFlag(64)) break block0;
                        ++this.tcycles;
                        this.branch_offset = s1;
                        break;
                    }
                    case 1: {
                        this.a ^= this.getMemIIX(this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 5: {
                        this.a ^= this.getMemZPX(this.x);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 6: {
                        int add = this.getAddressZPX(this.x);
                        int v = this.rd(add);
                        this.setFlag(1, v & 1);
                        this.wr(add, v >>= 1);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    case 8: {
                        this.irq_clearflag_delay = this.getFlag(4);
                        this.setFlag(4, 0);
                        break;
                    }
                    case 9: {
                        int arg1 = this.consumeByte();
                        this.a ^= this.getMemABX(arg1, this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.a ^= this.getMemABX(arg1, this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                        int v = this.rd(add);
                        this.setFlag(1, v & 1);
                        this.wr(add, v >>= 1);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    default: {
                        this.instructionNotFound(this.opcode);
                        break;
                    }
                }
                break;
            }
            case 96: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int arg1 = this.stackPop();
                        int arg2 = this.stackPop();
                        this.pc = this.getAddressAB(arg1, arg2, 0) + 1;
                        this.dummyRead();
                        this.jumped = true;
                        break block0;
                    }
                    case 1: {
                        this.add(this.getMemIN(this.consumeByte(), this.x));
                        break block0;
                    }
                    case 5: {
                        this.add(this.getMemZP());
                        break block0;
                    }
                    case 6: {
                        int add = this.consumeByte();
                        int v = this.rd(add);
                        int c = v & 1;
                        v = v >> 1 | (this.p & 1) << 7;
                        this.wr(add, v);
                        this.setFlag(1, c);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                    case 8: {
                        this.a = this.stackPop();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 9: {
                        this.add(this.consumeByte());
                        break block0;
                    }
                    case 10: {
                        int c = this.a & 1;
                        this.a = this.a >> 1 | (this.p & 1) << 7;
                        this.setFlag(1, c);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 12: {
                        if (this.in_jmp_bug) {
                            int arg1 = this.consumeByte();
                            int r1 = this.getAddressAB(arg1, this.consumeByte(), 0);
                            this.pc = this.getAddressAB(this.memory.read(r1), this.rd(r1 & 0xFF00 | (r1 & 0xFF) + 1 & 0xFF), 0);
                            this.jumped = true;
                            break block0;
                        }
                        int arg1 = this.consumeByte();
                        int r1 = this.getAddressAB(arg1, this.consumeByte(), 0);
                        this.pc = this.getAddressAB(this.rd(r1), this.memory.read(r1 + 1), 0);
                        this.jumped = true;
                        break block0;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.add(this.getMemAB(arg1, this.consumeByte(), 0));
                        break block0;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                        int v = this.rd(add);
                        int c = v & 1;
                        v = v >> 1 | (this.p & 1) << 7;
                        this.wr(add, v);
                        this.setFlag(1, c);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                }
                this.instructionNotFound(this.opcode);
                break;
            }
            case 112: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int s1 = this.consumeByte();
                        if (!this.getFlag(64)) break block0;
                        ++this.tcycles;
                        this.branch_offset = s1;
                        break;
                    }
                    case 1: {
                        this.add(this.getMemIIX(this.consumeByte(), this.y));
                        break;
                    }
                    case 5: {
                        this.add(this.getMemZPX(this.x));
                        break;
                    }
                    case 6: {
                        int add = this.getAddressZPX(this.x);
                        int v = this.rd(add);
                        int c = v & 1;
                        v = v >> 1 | (this.p & 1) << 7;
                        this.wr(add, v);
                        this.setFlag(1, c);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    case 8: {
                        this.irq_setflag_delay = !this.getFlag(4);
                        this.setFlag(4, 1);
                        break;
                    }
                    case 9: {
                        int arg1 = this.consumeByte();
                        this.add(this.getMemABX(arg1, this.consumeByte(), this.y));
                        break;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.add(this.getMemABX(arg1, this.consumeByte(), this.x));
                        break;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                        int v = this.rd(add);
                        int c = v & 1;
                        v = v >> 1 | (this.p & 1) << 7;
                        this.wr(add, v);
                        this.setFlag(1, c);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    default: {
                        this.instructionNotFound(this.opcode);
                        break;
                    }
                }
                break;
            }
            case 128: {
                switch (this.opcode & 0xF) {
                    case 1: {
                        int r1 = this.getAddressIN(this.consumeByte(), this.x);
                        this.wr(r1, this.a);
                        break block0;
                    }
                    case 4: {
                        int r1 = this.consumeByte();
                        this.wr(r1, this.y);
                        break block0;
                    }
                    case 5: {
                        int r1 = this.consumeByte();
                        this.wr(r1, this.a);
                        break block0;
                    }
                    case 6: {
                        int r1 = this.consumeByte();
                        this.wr(r1, this.x);
                        break block0;
                    }
                    case 8: {
                        this.y = this.y - 1 & 0xFF;
                        this.setArithmeticFlags(this.y);
                        break block0;
                    }
                    case 10: {
                        this.a = this.x;
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 12: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        int r1 = this.getAddressAB(arg1, arg2, 0);
                        this.wr(r1, this.y);
                        break block0;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        int r1 = this.getAddressAB(arg1, arg2, 0);
                        this.wr(r1, this.a);
                        break block0;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        int r1 = this.getAddressAB(arg1, arg2, 0);
                        this.wr(r1, this.x);
                        break block0;
                    }
                    case 15: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        int abs = this.getAddressAB(arg1, arg2, 0);
                        int r = this.a & this.x;
                        this.wr(abs, r);
                        break block0;
                    }
                }
                this.instructionNotFound(this.opcode);
                break;
            }
            case 144: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int s1 = this.consumeByte();
                        if (this.getFlag(1)) break block0;
                        ++this.tcycles;
                        this.branch_offset = s1;
                        break;
                    }
                    case 1: {
                        int abs = this.getAddressIIX(this.consumeByte(), 0);
                        this.dummyRead(abs, this.y);
                        this.wr(abs + this.y, this.a);
                        break;
                    }
                    case 4: {
                        int r1 = this.getAddressZPX(this.x);
                        this.wr(r1, this.y);
                        break;
                    }
                    case 5: {
                        int r1 = this.getAddressZPX(this.x);
                        this.wr(r1, this.a);
                        break;
                    }
                    case 6: {
                        int r1 = this.getAddressZPX(this.y);
                        this.wr(r1, this.x);
                        break;
                    }
                    case 8: {
                        this.a = this.y;
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 9: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        int r1 = this.getAddressAB(arg1, arg2, this.y);
                        this.wr(r1, this.a);
                        break;
                    }
                    case 10: {
                        this.s = this.x;
                        break;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        int abs = this.getAddressAB(arg1, arg2, 0);
                        this.dummyRead(abs, this.x);
                        this.wr(abs + this.x, this.a);
                        break;
                    }
                    default: {
                        this.instructionNotFound(this.opcode);
                        break;
                    }
                }
                break;
            }
            case 160: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        this.y = this.consumeByte();
                        this.setArithmeticFlags(this.y);
                        break block0;
                    }
                    case 1: {
                        this.a = this.getMemIN(this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 2: {
                        this.x = this.consumeByte();
                        this.setArithmeticFlags(this.x);
                        break block0;
                    }
                    case 4: {
                        this.y = this.getMemZP();
                        this.setArithmeticFlags(this.y);
                        break block0;
                    }
                    case 5: {
                        this.a = this.getMemZP();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 6: {
                        this.x = this.getMemZP();
                        this.setArithmeticFlags(this.x);
                        break block0;
                    }
                    case 8: {
                        this.y = this.a;
                        this.setArithmeticFlags(this.y);
                        break block0;
                    }
                    case 9: {
                        this.a = this.consumeByte();
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 10: {
                        this.x = this.a;
                        this.setArithmeticFlags(this.x);
                        break block0;
                    }
                    case 12: {
                        int arg1 = this.consumeByte();
                        this.y = this.getMemAB(arg1, this.consumeByte(), 0);
                        this.setArithmeticFlags(this.y);
                        break block0;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        this.a = this.getMemAB(arg1, arg2, 0);
                        this.setArithmeticFlags(this.a);
                        break block0;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        this.x = this.getMemAB(arg1, arg2, 0);
                        this.setArithmeticFlags(this.x);
                        break block0;
                    }
                }
                this.instructionNotFound(this.opcode);
                break;
            }
            case 176: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int s1 = this.consumeByte();
                        if (!this.getFlag(1)) break block0;
                        ++this.tcycles;
                        this.branch_offset = s1;
                        break;
                    }
                    case 1: {
                        this.a = this.getMemIIX(this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 3: {
                        this.x = this.a = this.getMemIIX(this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 4: {
                        this.y = this.getMemZPX(this.x);
                        this.setArithmeticFlags(this.y);
                        break;
                    }
                    case 5: {
                        this.a = this.getMemZPX(this.x);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 6: {
                        this.x = this.getMemZPX(this.y);
                        this.setArithmeticFlags(this.x);
                        break;
                    }
                    case 8: {
                        this.setFlag(64, 0);
                        break;
                    }
                    case 9: {
                        int arg1 = this.consumeByte();
                        this.a = this.getMemABX(arg1, this.consumeByte(), this.y);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 10: {
                        this.x = this.s;
                        this.setArithmeticFlags(this.x);
                        break;
                    }
                    case 12: {
                        int arg1 = this.consumeByte();
                        this.y = this.getMemABX(arg1, this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.y);
                        break;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.a = this.getMemABX(arg1, this.consumeByte(), this.x);
                        this.setArithmeticFlags(this.a);
                        break;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int arg2 = this.consumeByte();
                        this.x = this.getMemABX(arg1, arg2, this.y);
                        this.setArithmeticFlags(this.x);
                        break;
                    }
                    default: {
                        this.instructionNotFound(this.opcode);
                        break;
                    }
                }
                break;
            }
            case 192: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        this.compare(this.consumeByte(), this.y);
                        break block0;
                    }
                    case 1: {
                        this.compare(this.getMemIN(this.consumeByte(), this.x), this.a);
                        break block0;
                    }
                    case 4: {
                        this.compare(this.getMemZP(), this.y);
                        break block0;
                    }
                    case 5: {
                        this.compare(this.getMemZP(), this.a);
                        break block0;
                    }
                    case 6: {
                        int add = this.consumeByte();
                        int v = this.rd(add) - 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                    case 7: {
                        int add = this.consumeByte();
                        int v = this.rd(add);
                        if (--v < 0) {
                            v = 255;
                            this.setFlag(1, 1);
                        }
                        this.wr(add, v);
                    }
                    case 8: {
                        this.y = this.y + 1 & 0xFF;
                        this.setArithmeticFlags(this.y);
                        break block0;
                    }
                    case 9: {
                        this.compare(this.consumeByte(), this.a);
                        break block0;
                    }
                    case 10: {
                        this.x = this.x - 1 & 0xFF;
                        this.setArithmeticFlags(this.x);
                        break block0;
                    }
                    case 11: {
                        this.x &= this.a;
                        this.x = this.x - this.consumeByte() & 0xFF;
                        break block0;
                    }
                    case 12: {
                        this.compare(this.getMemAB(this.consumeByte(), this.consumeByte(), 0), this.y);
                        break block0;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.compare(this.getMemAB(arg1, this.consumeByte(), 0), this.a);
                        break block0;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                        int v = this.rd(add) - 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                }
                this.instructionNotFound(this.opcode);
                break;
            }
            case 208: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int s1 = this.consumeByte();
                        if (this.getFlag(2)) break block0;
                        ++this.tcycles;
                        this.branch_offset = s1;
                        break;
                    }
                    case 1: {
                        this.compare(this.getMemIIX(this.consumeByte(), this.y), this.a);
                        break;
                    }
                    case 5: {
                        this.compare(this.getMemZPX(this.x), this.a);
                        break;
                    }
                    case 6: {
                        int add = this.getAddressZPX(this.x);
                        int v = this.rd(add) - 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    case 8: {
                        this.setFlag(8, 0);
                        break;
                    }
                    case 9: {
                        int arg1 = this.consumeByte();
                        this.compare(this.getMemABX(arg1, this.consumeByte(), this.y), this.a);
                        break;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.compare(this.getMemABX(arg1, this.consumeByte(), this.x), this.a);
                        break;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                        int v = this.rd(add) - 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    default: {
                        this.instructionNotFound(this.opcode);
                        break;
                    }
                }
                break;
            }
            case 224: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        this.compare(this.consumeByte(), this.x);
                        break block0;
                    }
                    case 1: {
                        this.sub(this.getMemIN(this.consumeByte(), this.x));
                        break block0;
                    }
                    case 4: {
                        this.compare(this.getMemZP(), this.x);
                        break block0;
                    }
                    case 5: {
                        this.sub(this.getMemZP());
                        break block0;
                    }
                    case 6: {
                        int add = this.consumeByte();
                        int v = this.rd(add) + 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                    case 8: {
                        this.x = this.x + 1 & 0xFF;
                        this.setArithmeticFlags(this.x);
                        break block0;
                    }
                    case 9: {
                        this.sub(this.consumeByte());
                        break block0;
                    }
                    case 10: {
                        break block0;
                    }
                    case 12: {
                        this.compare(this.getMemAB(this.consumeByte(), this.consumeByte(), 0), this.x);
                        break block0;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.sub(this.getMemAB(arg1, this.consumeByte(), 0));
                        break block0;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), 0);
                        int v = this.rd(add) + 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break block0;
                    }
                }
                this.instructionNotFound(this.opcode);
                break;
            }
            case 240: {
                switch (this.opcode & 0xF) {
                    case 0: {
                        int s1 = this.consumeByte();
                        if (!this.getFlag(2)) break block0;
                        ++this.tcycles;
                        this.branch_offset = s1;
                        break;
                    }
                    case 1: {
                        this.sub(this.getMemIIX(this.consumeByte(), this.y));
                        break;
                    }
                    case 5: {
                        this.sub(this.getMemZPX(this.x));
                        break;
                    }
                    case 6: {
                        int add = this.getAddressZPX(this.x);
                        int v = this.rd(add) + 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    case 8: {
                        this.setFlag(8, 1);
                        break;
                    }
                    case 9: {
                        int arg1 = this.consumeByte();
                        this.sub(this.getMemABX(arg1, this.consumeByte(), this.y));
                        break;
                    }
                    case 13: {
                        int arg1 = this.consumeByte();
                        this.sub(this.getMemABX(arg1, this.consumeByte(), this.x));
                        break;
                    }
                    case 14: {
                        int arg1 = this.consumeByte();
                        int add = this.getAddressAB(arg1, this.consumeByte(), this.x);
                        int v = this.rd(add) + 1 & 0xFF;
                        this.wr(add, v);
                        this.setArithmeticFlags(v);
                        break;
                    }
                    default: {
                        this.instructionNotFound(this.opcode);
                        break;
                    }
                }
                break;
            }
            default: {
                this.instructionNotFound(this.opcode);
            }
        }
    }
}

