/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.emucore.cpu.mos6502;

import com.youkaicountry.emucore.cpu.mos6502.CPU6502;

public class Disassemble6502 {
    CPU6502 cpu;
    boolean mem_read;

    public Disassemble6502(CPU6502 cpu, boolean mem_read) {
        this.cpu = cpu;
        this.mem_read = mem_read;
    }

    private String getInstAB(String inst, int r_address, boolean show_mem) {
        StringBuilder sb = new StringBuilder();
        sb.append(inst);
        sb.append(" ");
        sb.append(this.getABString(r_address, show_mem));
        return sb.toString();
    }

    private String getInstIMM(String inst, int r_address) {
        StringBuilder sb = new StringBuilder();
        int val = this.cpu.memory.read(r_address);
        sb.append(inst);
        sb.append(" #");
        sb.append(this.getHexValueString(val, 2, true));
        return sb.toString();
    }

    private String getInstREL(String inst, int r_address) {
        StringBuilder sb = new StringBuilder();
        sb.append(inst);
        sb.append(" ");
        sb.append(this.getHexValueString(this.getRELAddress(this.cpu.pc + 2, this.cpu.memory.read(r_address)), 4, true));
        return sb.toString();
    }

    private String getInstZP(String inst, int r_address, boolean show_mem) {
        StringBuilder sb = new StringBuilder();
        sb.append(inst);
        sb.append(" ");
        sb.append(this.getZPString(r_address, show_mem));
        return sb.toString();
    }

    private String getInstZPX(String inst, String sval, int ival, int r_address) {
        StringBuilder sb = new StringBuilder();
        sb.append(inst);
        sb.append(" ");
        int zpa = this.cpu.memory.read(r_address);
        sb.append(this.getHexValueString(zpa, 2, true));
        sb.append(",");
        sb.append(sval);
        sb.append(" @ ");
        sb.append(this.getHexValueString(zpa + ival, 2, false));
        sb.append(this.tryGetMem(zpa + ival, true));
        return sb.toString();
    }

    private String getInstABX(String inst, String sval, int ival, int r_address) {
        StringBuilder sb = new StringBuilder();
        sb.append(inst);
        sb.append(" ");
        int aba = this.getABAddress(this.cpu.memory.read(r_address), this.cpu.memory.read(r_address + 1));
        sb.append(this.getHexValueString(aba, 4, true));
        sb.append(",");
        sb.append(sval);
        sb.append(" @ ");
        sb.append(this.getHexValueString(aba + ival, 4, false));
        sb.append(this.tryGetMem(aba + ival, true));
        return sb.toString();
    }

    private String getInstINY(String inst, int r_address) {
        StringBuilder sb = new StringBuilder();
        sb.append(inst);
        sb.append(" (");
        int v = this.cpu.memory.read(r_address);
        sb.append(this.getHexValueString(v, 2, true));
        sb.append("),Y = ");
        int add = this.getABAddress(this.cpu.memory.read(v), this.cpu.memory.read(v + 1) & 0xFF);
        sb.append(this.getHexValueString(add, 4, false));
        sb.append(" @ ");
        int addy = add + this.cpu.y;
        sb.append(this.getHexValueString(addy, 4, false));
        sb.append(this.tryGetMem(addy, true));
        return sb.toString();
    }

    private String getJMP(int r_address) {
        StringBuilder sb = new StringBuilder();
        sb.append("JMP (");
        int add = this.getABAddress(this.cpu.memory.read(r_address), this.cpu.memory.read(r_address + 1));
        sb.append(this.getHexValueString(add, 4, true));
        sb.append(") = ");
        sb.append(this.getHexValueString(this.cpu.memory.read(add + 1), 2, false));
        sb.append(this.getHexValueString(this.cpu.memory.read(add), 2, false));
        return sb.toString();
    }

    private int getABAddress(int low, int high) {
        return high << 8 | low;
    }

    private int getRELAddress(int start, int amt) {
        return start + (byte)amt;
    }

    private String getHexValueString(int address, int pad_to, boolean dollar) {
        StringBuilder sb = new StringBuilder();
        if (dollar) {
            sb.append("$");
        }
        sb.append(Integer.toHexString(address).toUpperCase());
        while (sb.length() < pad_to + (dollar ? 1 : 0)) {
            sb.insert(dollar ? 1 : 0, "0");
        }
        return sb.toString();
    }

    private String getABString(int start_address, boolean show_mem) {
        StringBuilder sb = new StringBuilder();
        int address = this.getABAddress(this.cpu.memory.read(start_address), this.cpu.memory.read(start_address + 1));
        sb.append(this.getHexValueString(address, 4, true));
        sb.append(this.tryGetMem(address, show_mem));
        return sb.toString();
    }

    private String getZPString(int start_address, boolean show_mem) {
        StringBuilder sb = new StringBuilder();
        int address = this.cpu.memory.read(start_address);
        sb.append(this.getHexValueString(address, 2, true));
        sb.append(this.tryGetMem(address, show_mem));
        return sb.toString();
    }

    private String tryGetMem(int address, boolean show_mem) {
        if (!this.mem_read | !show_mem) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" = ");
        if (!this.isValidAddress(address)) {
            sb.append("FF");
        } else {
            sb.append(Integer.toHexString(this.cpu.memory.read(address)).toUpperCase());
        }
        while (sb.length() < 5) {
            sb.insert(3, "0");
        }
        return sb.toString();
    }

    private boolean isValidAddress(int address) {
        if (address >= 8192 && address < 16384) {
            return false;
        }
        return address < 16384 || address > 16408;
    }

    public String getCurrentASMString() {
        return this.getASMString(this.cpu.pc);
    }

    public String getASMString(int address) {
        StringBuilder sb = new StringBuilder();
        int opcode = this.cpu.memory.read(address);
        int as = address + 1;
        block0 : switch (opcode & 0xF0) {
            case 0: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstIMM("BRK", as));
                        break block0;
                    }
                    case 8: {
                        sb.append("PHP");
                        break block0;
                    }
                    case 10: {
                        sb.append("ASL A");
                        break block0;
                    }
                    case 13: {
                        sb.append(this.getInstAB("ORA", as, true));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 16: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstREL("BPL", as));
                        break block0;
                    }
                    case 8: {
                        sb.append("CLC");
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 32: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstAB("JSR", as, false));
                        break block0;
                    }
                    case 8: {
                        sb.append("PLP");
                        break block0;
                    }
                    case 9: {
                        sb.append(this.getInstIMM("AND", as));
                        break block0;
                    }
                    case 12: {
                        sb.append(this.getInstAB("BIT", as, true));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 48: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstREL("BMI", as));
                        break block0;
                    }
                    case 8: {
                        sb.append("SEC");
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 64: {
                switch (opcode & 0xF) {
                    case 8: {
                        sb.append("PHA");
                        break block0;
                    }
                    case 10: {
                        sb.append("LSR A");
                        break block0;
                    }
                    case 12: {
                        sb.append(this.getInstAB("JMP", as, false));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 80: {
                switch (opcode & 0xF) {
                    default: 
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 96: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append("RTS");
                        break block0;
                    }
                    case 8: {
                        sb.append("PLA");
                        break block0;
                    }
                    case 9: {
                        sb.append(this.getInstIMM("ADC", as));
                        break block0;
                    }
                    case 10: {
                        sb.append("ROR A");
                        break block0;
                    }
                    case 12: {
                        sb.append(this.getJMP(as));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 112: {
                switch (opcode & 0xF) {
                    case 8: {
                        sb.append("SEI");
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 128: {
                switch (opcode & 0xF) {
                    case 4: {
                        sb.append(this.getInstZP("STY", as, true));
                        break block0;
                    }
                    case 5: {
                        sb.append(this.getInstZP("STA", as, true));
                        break block0;
                    }
                    case 6: {
                        sb.append(this.getInstZP("STX", as, true));
                        break block0;
                    }
                    case 8: {
                        sb.append("DEY");
                        break block0;
                    }
                    case 10: {
                        sb.append("TXA");
                        break block0;
                    }
                    case 13: {
                        sb.append(this.getInstAB("STA", as, true));
                        break block0;
                    }
                    case 14: {
                        sb.append(this.getInstAB("STX", as, true));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 144: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstREL("BCC", as));
                        break block0;
                    }
                    case 5: {
                        sb.append(this.getInstZPX("STA", "X", this.cpu.x, as));
                        break block0;
                    }
                    case 8: {
                        sb.append("TYA");
                        break block0;
                    }
                    case 9: {
                        sb.append(this.getInstABX("STA", "Y", this.cpu.y, as));
                        break block0;
                    }
                    case 10: {
                        sb.append("TXS");
                        break block0;
                    }
                    case 13: {
                        sb.append(this.getInstABX("STA", "X", this.cpu.x, as));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 160: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstIMM("LDY", as));
                        break block0;
                    }
                    case 2: {
                        sb.append(this.getInstIMM("LDX", as));
                        break block0;
                    }
                    case 4: {
                        sb.append(this.getInstZP("LDY", as, true));
                        break block0;
                    }
                    case 5: {
                        sb.append(this.getInstZP("LDA", as, true));
                        break block0;
                    }
                    case 6: {
                        sb.append(this.getInstZP("LDX", as, true));
                        break block0;
                    }
                    case 8: {
                        sb.append("TAY");
                        break block0;
                    }
                    case 9: {
                        sb.append(this.getInstIMM("LDA", as));
                        break block0;
                    }
                    case 10: {
                        sb.append("TAX");
                        break block0;
                    }
                    case 13: {
                        sb.append(this.getInstAB("LDA", as, true));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 176: {
                switch (opcode & 0xF) {
                    case 1: {
                        sb.append(this.getInstINY("LDA", as));
                        break block0;
                    }
                    case 9: {
                        sb.append(this.getInstABX("LDA", "Y", this.cpu.y, as));
                        break block0;
                    }
                    case 10: {
                        sb.append("TSX");
                        break block0;
                    }
                    case 13: {
                        sb.append(this.getInstABX("LDA", "X", this.cpu.x, as));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 192: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstIMM("CPY", as));
                        break block0;
                    }
                    case 6: {
                        sb.append(this.getInstZP("DEC", as, true));
                        break block0;
                    }
                    case 8: {
                        sb.append("INY");
                        break block0;
                    }
                    case 9: {
                        sb.append(this.getInstIMM("CMP", as));
                        break block0;
                    }
                    case 10: {
                        sb.append("DEX");
                        break block0;
                    }
                    case 13: {
                        sb.append(this.getInstAB("CMP", as, true));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 208: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstREL("BNE", as));
                        break block0;
                    }
                    case 8: {
                        sb.append("CLD");
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 224: {
                switch (opcode & 0xF) {
                    case 8: {
                        sb.append("INX");
                        break block0;
                    }
                    case 9: {
                        sb.append(this.getInstIMM("SBC", as));
                        break block0;
                    }
                    case 10: {
                        sb.append("NOP");
                        break block0;
                    }
                    case 14: {
                        sb.append(this.getInstAB("INC", as, true));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            case 240: {
                switch (opcode & 0xF) {
                    case 0: {
                        sb.append(this.getInstREL("BEQ", as));
                        break block0;
                    }
                }
                sb.append(this.instructionNotFound(opcode));
                break;
            }
            default: {
                sb.append(this.instructionNotFound(opcode));
            }
        }
        return sb.toString();
    }

    private String instructionNotFound(int opcode) {
        return "??";
    }
}

