/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.util.compression;

import java.util.ArrayList;

public class RLETapeInt {
    ArrayList<Integer> tape = new ArrayList();
    int current_value;
    int current_num;
    boolean init;
    int values;
    int playing_i;
    int playing_j;

    public void add(int value) {
        if (!this.init) {
            if (this.tape.size() == 0 || value != this.tape.get(this.tape.size() - 1)) {
                this.current_value = value;
                this.current_num = 1;
            } else {
                this.current_value = this.tape.remove(this.tape.size() - 1);
                this.current_num = this.tape.remove(this.tape.size() - 1) + 1;
            }
            this.init = true;
        } else if (value == this.current_value) {
            ++this.current_num;
        } else {
            this.tape.add(this.current_num);
            this.tape.add(this.current_value);
            this.current_value = value;
            this.current_num = 1;
        }
        ++this.values;
    }

    public void add(int[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i]);
        }
    }

    private void flush() {
        if (this.init) {
            this.tape.add(this.current_num);
            this.tape.add(this.current_value);
            this.init = false;
        }
    }

    public String toString() {
        this.flush();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tape.size(); i += 2) {
            sb.append(this.tape.get(i));
            sb.append("x");
            sb.append(this.tape.get(i + 1));
            sb.append(" ");
        }
        sb.append("\nValues: ");
        sb.append(this.getUncompressedSize());
        sb.append(", RLE: ");
        sb.append(this.getRLESize());
        return sb.toString();
    }

    public int getRLESize() {
        this.flush();
        return this.tape.size();
    }

    public int getUncompressedSize() {
        return this.values;
    }

    public int[] getRLEArray() {
        this.flush();
        int[] array = new int[this.tape.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.tape.get(i);
        }
        return array;
    }

    public void startPlaying() {
        this.flush();
        this.playing_i = 0;
        this.playing_j = 0;
    }

    public boolean hasNext() {
        return this.playing_i < this.tape.size();
    }

    public int getNext() {
        int rval = this.tape.get(this.playing_i + 1);
        ++this.playing_j;
        if (this.playing_j >= this.tape.get(this.playing_i)) {
            this.playing_i += 2;
            this.playing_j = 0;
        }
        return rval;
    }

    public void clear() {
        this.init = false;
        this.tape = new ArrayList();
        this.values = 0;
        this.playing_i = 0;
        this.playing_j = 0;
    }

    public void setRLE(int[] rle) {
        this.tape = new ArrayList();
        for (int i = 0; i < rle.length; ++i) {
            this.tape.add(rle[i]);
        }
    }
}

