/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.util.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class INILoader {
    public static HashMap<String, String> loadBasicINI(List<String> lines) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (String line : lines) {
            String[] sides = line.split("=");
            if (sides.length < 2) continue;
            String lside = sides[0];
            String rside = INILoader.getRightSide(sides);
            data.put(lside.trim(), rside.trim());
        }
        return data;
    }

    public static HashMap<String, String> loadBasicINI(BufferedReader r) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String fline = r.readLine();
        while (fline != null) {
            lines.add(fline);
            fline = r.readLine();
        }
        return INILoader.loadBasicINI(lines);
    }

    public static String getSpecificValue(BufferedReader r, String section, String value) throws IOException {
        Object result = null;
        boolean in_section = section.equals("");
        String fline = r.readLine();
        while (fline != null) {
            String[] sides;
            String uline = fline.trim();
            fline = r.readLine();
            if (uline.length() == 0) continue;
            if (uline.charAt(0) == '[') {
                String current_section = uline.substring(1, uline.length() - 1);
                in_section = current_section.equals(section);
                continue;
            }
            if (!in_section || (sides = uline.split("=")).length < 2 || !sides[0].trim().equals(value)) continue;
            return INILoader.getRightSide(sides);
        }
        return null;
    }

    private static String getRightSide(String[] sides) {
        StringBuilder rside = new StringBuilder();
        for (int i = 1; i < sides.length; ++i) {
            rside.append(sides[i]);
        }
        return rside.toString();
    }
}

