/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.util.math;

public class SineTable {
    public int precision;
    public final double D_TWO_PI = Math.PI * 2;
    public final float TWO_PI = (float)Math.PI * 2;
    public final float PI_O_2 = 1.5707964f;
    private final float[] sine_table;
    private int mod;

    public SineTable(int precision) {
        this.precision = precision;
        this.mod = (int)((float)Math.PI * 2 * (float)precision);
        this.sine_table = new float[this.mod];
        this.generateTables();
    }

    public final float sin(float angle) {
        return this.sine_table[(int)(angle * (float)this.precision + 0.5f) % this.mod];
    }

    public final float cos(float angle) {
        return this.sine_table[(int)((angle + 1.5707964f) * (float)this.precision + 0.5f) % this.mod];
    }

    private void generateTables() {
        double da = Math.PI * 2 / (double)this.mod;
        double angle = 0.0;
        for (int i = 0; i < this.mod; ++i) {
            this.sine_table[i] = (float)Math.sin(angle);
            angle += da;
        }
    }
}

