/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.util.serialize;

import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ByteSerializer {
    ArrayList<IByteSerialize> targets = new ArrayList();

    public void addTarget(IByteSerialize target) {
        this.targets.add(target);
    }

    public void removeTarget(IByteSerialize target) {
        this.targets.remove(target);
    }

    public void serialize(OutputStream stream) throws IOException {
        DataOutputStream dstream = new DataOutputStream(stream);
        SerializationInfo info = new SerializationInfo(dstream);
        for (int i = 0; i < this.targets.size(); ++i) {
            IByteSerialize target = this.targets.get(i);
            target.serialization(info);
        }
        dstream.close();
    }

    public void deserialize(InputStream stream) throws IOException {
        DataInputStream dstream = new DataInputStream(stream);
        SerializationInfo info = new SerializationInfo(dstream);
        for (int i = 0; i < this.targets.size(); ++i) {
            IByteSerialize target = this.targets.get(i);
            target.serialization(info);
        }
        dstream.close();
    }

    public static byte serializationByte(SerializationInfo info, byte b) throws IOException {
        if (info.serializing) {
            ByteSerializer.serializeByte(info.ostream, b);
            return b;
        }
        return ByteSerializer.deserializeByte(info.istream);
    }

    public static void serializeByte(DataOutputStream stream, byte b) throws IOException {
        stream.writeByte(b);
    }

    public static byte deserializeByte(DataInputStream stream) throws IOException {
        return stream.readByte();
    }

    public static int serializationInt(SerializationInfo info, int i) throws IOException {
        if (info.serializing) {
            ByteSerializer.serializeInt(info.ostream, i);
            return i;
        }
        return ByteSerializer.deserializeInt(info.istream);
    }

    public static void serializeInt(DataOutputStream stream, int i) throws IOException {
        stream.writeInt(i);
    }

    public static int deserializeInt(DataInputStream stream) throws IOException {
        return stream.readInt();
    }

    public static boolean serializationBoolean(SerializationInfo info, boolean b) throws IOException {
        if (info.serializing) {
            ByteSerializer.serializeBoolean(info.ostream, b);
            return b;
        }
        return ByteSerializer.deserializeBoolean(info.istream);
    }

    public static void serializeBoolean(DataOutputStream stream, boolean b) throws IOException {
        stream.writeBoolean(b);
    }

    public static boolean deserializeBoolean(DataInputStream stream) throws IOException {
        return stream.readBoolean();
    }

    public static void serializationByteArray(SerializationInfo info, byte[] b) throws IOException {
        if (info.serializing) {
            ByteSerializer.serializeByteArray(info.ostream, b);
        } else {
            ByteSerializer.deserializeByteArray(info.istream, b);
        }
    }

    public static void serializeByteArray(DataOutputStream stream, byte[] b) throws IOException {
        stream.write(b);
    }

    public static void deserializeByteArray(DataInputStream stream, byte[] b) throws IOException {
        stream.read(b);
    }

    public static void serializationIntArray(SerializationInfo info, int[] i) throws IOException {
        if (info.serializing) {
            ByteSerializer.serializeIntArray(info.ostream, i);
        } else {
            ByteSerializer.deserializeIntArray(info.istream, i);
        }
    }

    public static void serializeIntArray(DataOutputStream stream, int[] i) throws IOException {
        for (int j = 0; j < i.length; ++j) {
            stream.writeInt(i[j]);
        }
    }

    public static void deserializeIntArray(DataInputStream stream, int[] i) throws IOException {
        for (int j = 0; j < i.length; ++j) {
            i[j] = stream.readInt();
        }
    }

    public static void serializationBooleanArray(SerializationInfo info, boolean[] b) throws IOException {
        if (info.serializing) {
            ByteSerializer.serializeBooleanArray(info.ostream, b);
        } else {
            ByteSerializer.deserializeBooleanArray(info.istream, b);
        }
    }

    public static void serializeBooleanArray(DataOutputStream stream, boolean[] b) throws IOException {
        for (int j = 0; j < b.length; ++j) {
            stream.writeBoolean(b[j]);
        }
    }

    public static void deserializeBooleanArray(DataInputStream stream, boolean[] b) throws IOException {
        for (int j = 0; j < b.length; ++j) {
            b[j] = stream.readBoolean();
        }
    }
}

