/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.youkaicountry.vnand.VNGameEngine;
import com.youkaicountry.vnand.gameengines.vnovels.VNMusic;
import com.youkaicountry.vnand.gameengines.vnovels.VNSettings;
import com.youkaicountry.vnand.gameloader.VNFormatChooser;
import com.youkaicountry.vnand.gameloader.VNFormatInstance;
import com.youkaicountry.vnand.screens.GameMenuScreen;
import com.youkaicountry.vnand.utils.BitmapLoader;
import com.youkaicountry.vnand.utils.TempFileManager;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VNAnd
extends Game
implements ApplicationListener {
    private SpriteBatch batch;
    public ShapeRenderer shape;
    public GameMenuScreen gms;
    String default_base_directory;
    String[] base_directories;
    String loader_config;
    VNGameEngine[] engines;
    String start_file;
    public static BitmapLoader bitmap_loader;
    public static VNMusic midi_player;
    public static Screen current_screen;
    public static TempFileManager temp_files;
    public static FileHandle vnand_root;
    public static VNSettings settings;
    public static Skin skin;
    public static int cores;
    int direct_launch;

    public VNAnd(String default_base_directory, String loader_config, BitmapLoader bml, VNMusic midi, VNGameEngine[] engines, String[] args, int direct_launch) {
        this.direct_launch = direct_launch;
        bitmap_loader = bml;
        midi_player = midi;
        this.default_base_directory = default_base_directory;
        this.base_directories = this.base_directories;
        this.loader_config = loader_config;
        this.engines = engines;
        this.start_file = args.length > 0 ? args[0] : null;
    }

    public VNAnd(String default_base_directory, String loader_config, VNGameEngine[] engines, int direct_launch) {
        bitmap_loader = null;
        midi_player = null;
        this.direct_launch = direct_launch;
        this.default_base_directory = default_base_directory;
        this.loader_config = loader_config;
        this.engines = engines;
        this.start_file = null;
    }

    public void init() {
        if (skin == null) {
            skin = new Skin(Gdx.files.internal("skins/default/uiskin.json"));
        }
        Gdx.app.debug("", "Cores: " + cores);
    }

    @Override
    public void create() {
        this.init();
        System.out.println("Gdx version 1.9.6");
        this.batch = new SpriteBatch();
        this.shape = new ShapeRenderer();
        temp_files = new TempFileManager(Gdx.files.external("vnand/temp/"));
        vnand_root = Gdx.files.external("vnand");
        vnand_root.mkdirs();
        if (this.start_file != null) {
            VNFormatChooser chooser = new VNFormatChooser(this.engines);
            VNFormatInstance instance = chooser.chooseFormat(new FileHandle(this.start_file));
            if (instance != null) {
                instance.activate(this, this.batch);
            } else {
                this.launchGameMenu();
            }
        } else if (this.direct_launch >= 0) {
            this.engines[this.direct_launch].directLaunch(this, this.batch);
        } else {
            this.launchGameMenu();
        }
    }

    private void launchGameMenu() {
        this.gms = new GameMenuScreen(this.default_base_directory, this.loader_config, this.batch, this.shape, this, this.engines);
        this.setScreen(this.gms);
    }

    public void clearGames() {
        if (current_screen != null) {
            current_screen.dispose();
            current_screen = null;
        }
    }

    public void quitGame() {
        this.clearGames();
        if (this.gms != null) {
            this.setScreen(this.gms);
        } else {
            Gdx.app.exit();
        }
    }

    public void startNewFormat(Screen screen) {
        this.clearGames();
        current_screen = screen;
        this.setScreen(current_screen);
    }

    public void gotoNovel() {
        this.setScreen(current_screen);
    }

    @Override
    public void dispose() {
        if (current_screen != null) {
            current_screen.dispose();
        }
        temp_files.removeAllTempFiles();
        if (this.gms != null) {
            this.gms.dispose();
        }
        this.batch.dispose();
    }

    public static FileHandle getLogDirectory(String game) {
        FileHandle fh = vnand_root.child("engine_data").child(game).child("logs");
        fh.mkdirs();
        return fh;
    }

    public static FileHandle getUniqueLogFile(String game, String log_name, String extension) {
        FileHandle ld = VNAnd.getLogDirectory(game);
        String time_stamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        return ld.child(log_name + "_" + time_stamp + "." + extension);
    }

    public static FileHandle getSaveDirectory(String game) {
        FileHandle fh = vnand_root.child("engine_data").child(game).child("saves");
        fh.mkdirs();
        return fh;
    }

    public static FileHandle getConfigDirectory(String game) {
        FileHandle fh = vnand_root.child("engine_data").child(game).child("config");
        fh.mkdirs();
        return fh;
    }

    public static FileHandle getRecordingDirectory(String game) {
        FileHandle fh = vnand_root.child("engine_data").child(game).child("recordings");
        fh.mkdirs();
        return fh;
    }

    public static FileHandle getSpecificGameDataDirectory(String game, String dirname) {
        FileHandle fh = vnand_root.child("engine_data").child(game).child(dirname);
        fh.mkdirs();
        return fh;
    }

    public static FileHandle getLoaderConfigDirectory(String config_name) {
        FileHandle fh = vnand_root.child("loader").child("config").child(config_name);
        fh.mkdirs();
        return fh;
    }

    public static int getQuarterCores() {
        int c = Math.max(cores / 4, 1);
        return c;
    }

    public static int getHalfCores() {
        int c = Math.max(cores / 2, 1);
        Gdx.app.debug("", "H Core: " + c);
        return c;
    }

    static {
        settings = new VNSettings();
        settings.setSetting("sound_volume", 1.0f);
        settings.setSetting("music_volume", 1.0f);
        settings.setSetting("overall_volume", 1.0f);
        settings.setSetting("text_lines", 11.0f);
        settings.setSetting("text_speed", 33.0f);
        cores = Runtime.getRuntime().availableProcessors();
    }
}

