/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.actors.VNButton;
import com.youkaicountry.vnand.gameengines.vnovels.script.instructions.AddTextButtonInstruction;
import com.youkaicountry.vnand.screens.VNScreen;
import java.util.ArrayList;

public class ButtonActor
extends Actor {
    private ArrayList<VNButton> buttons;
    private int current;
    private VNScreen vnscreen;
    public boolean waiting = false;
    public ArrayList<AddTextButtonInstruction> inst_registry;

    public ButtonActor(VNScreen vnscreen) {
        this.vnscreen = vnscreen;
        this.current = -1;
        this.buttons = new ArrayList();
        this.inst_registry = new ArrayList();
    }

    public ArrayList<VNButton> getButtons() {
        return this.buttons;
    }

    private int whichButton(float x, float y) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).isIn(x, y)) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.buttons.size();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).draw(batch);
        }
    }

    public void touchDown(float x, float y) {
        int b = this.whichButton(x, y);
        if (b < 0) {
            return;
        }
        this.cleanButtonState();
        this.current = b;
        VNButton button = this.buttons.get(b);
        button.current_state = VNButton.ButtonState.BUTTON_PRESSING;
    }

    public void touchUp(float x, float y) {
        int b = this.whichButton(x, y);
        if (b < 0) {
            this.cleanButtonState();
            return;
        }
        if (b == this.current) {
            this.pressButton(b);
        }
    }

    public void touchDragged(float x, float y) {
        if (this.current >= 0) {
            return;
        }
        int b = this.whichButton(x, y);
        if (b < 0) {
            return;
        }
        this.cleanButtonState();
        this.buttons.get((int)b).current_state = VNButton.ButtonState.BUTTON_HOVERING;
    }

    private void cleanButtonState() {
        this.current = -1;
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get((int)i).current_state = VNButton.ButtonState.BUTTON_NORMAL;
        }
    }

    private void pressButton(int num) {
        this.buttons.get(num).executeAction();
        this.stopWaiting();
    }

    public void waitForButton() {
        if (this.buttons.size() == 0) {
            return;
        }
        this.vnscreen.vn.blocked = true;
        this.waiting = true;
    }

    public void stopWaiting() {
        if (this.waiting) {
            this.vnscreen.vn.blocked = false;
            this.waiting = false;
        }
    }

    public void addButton(VNButton button) {
        this.buttons.add(button);
    }

    public void addButton(VNButton button, AddTextButtonInstruction inst) {
        this.buttons.add(button);
        this.inst_registry.add(inst);
    }

    public void repositionButtons() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).reposition();
        }
    }

    public void centerAllButtonsX() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).centerX();
        }
    }

    public void arrangeYInList() {
        int size = this.buttons.size();
        float height = VNAnd.settings.getSetting("height");
        float dy = height / (float)(size + 1);
        float locy = height;
        for (int i = 0; i < size; ++i) {
            this.buttons.get(i).setY(locy -= dy);
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).dispose();
        }
        this.buttons.clear();
        this.current = -1;
        this.stopWaiting();
    }
}

