/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.youkaicountry.vnand.actors.IMenuSelection;
import com.youkaicountry.vnand.utils.text.VNFont;

public class MenuActor
extends Actor {
    String[] entries;
    Sprite menu_top;
    Sprite menu_middle;
    Sprite menu_bottom;
    Sprite menu_sep;
    VNFont font;
    IMenuSelection isel;
    Vector3 tempv;
    Rectangle[] entry_rects;
    int hovering;
    int selecting;
    int over;
    private boolean enabled;

    public MenuActor(String[] entries, IMenuSelection isel, VNFont font, Sprite[] menu_parts, float x, float y) {
        this.init(entries, isel, font, menu_parts, x, y);
    }

    public MenuActor(String[] entries, IMenuSelection isel, float x, float y) {
        Texture top = new Texture(Gdx.files.internal("sprites/menu_top.png"));
        top.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite stop = new Sprite(top);
        stop.setOrigin(0.0f, 0.0f);
        stop.setScale(0.5f);
        Texture middle = new Texture(Gdx.files.internal("sprites/menu_middle.png"));
        top.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite smiddle = new Sprite(middle);
        smiddle.setOrigin(0.0f, 0.0f);
        smiddle.setScale(0.5f);
        Texture bottom = new Texture(Gdx.files.internal("sprites/menu_bottom.png"));
        top.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite sbottom = new Sprite(bottom);
        sbottom.setOrigin(0.0f, 0.0f);
        sbottom.setScale(0.5f);
        Texture sep = new Texture(Gdx.files.internal("sprites/menu_sep.png"));
        top.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Sprite ssep = new Sprite(sep);
        ssep.setOrigin(0.0f, 0.0f);
        ssep.setScale(0.5f);
        VNFont font = new VNFont(Gdx.files.internal("fonts/sazanami.ttf"), "sazanami8", 8, 4, 5);
        font.font.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.init(entries, isel, font, new Sprite[]{stop, smiddle, sbottom, ssep}, x, y);
    }

    private void init(String[] entries, IMenuSelection isel, VNFont font, Sprite[] menu_parts, float x, float y) {
        this.tempv = new Vector3();
        this.entries = entries;
        this.menu_top = menu_parts[0];
        this.menu_middle = menu_parts[1];
        this.menu_bottom = menu_parts[2];
        this.menu_sep = menu_parts[3];
        this.enabled = false;
        this.setPosition(x, y);
        this.font = font;
        this.isel = isel;
        this.hovering = -1;
        this.selecting = -1;
        this.over = -1;
        this.calcRects();
    }

    public void calcRects() {
        int height = 14;
        this.entry_rects = new Rectangle[this.entries.length];
        float y = this.getY() + (float)(height * this.entries.length);
        for (int i = 0; i < this.entries.length; ++i) {
            this.entry_rects[i] = new Rectangle(this.getX(), y - (float)height, 92.0f, height);
            y -= (float)height;
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.enabled) {
            int size = this.entries.length;
            float x = this.getX();
            float y = this.getY();
            for (int i = size - 1; i >= 0; --i) {
                Sprite current = this.menu_middle;
                if (i == size - 1) {
                    current = this.menu_bottom;
                } else if (i == 0) {
                    current = this.menu_top;
                }
                if (i == this.hovering) {
                    current.setColor(0.65f, 0.55f, 0.55f, 1.0f);
                } else if (this.selecting == i && this.selecting == this.over) {
                    current.setColor(8.0f, 0.8f, 1.0f, 1.0f);
                } else {
                    current.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                }
                current.setPosition(x, y);
                current.draw(batch);
                if (i != 0) {
                    this.menu_sep.setPosition(x, y + 14.0f);
                    this.menu_sep.draw(batch);
                }
                float tx = (float)(96 - this.entries[i].length() * this.font.width) / 2.0f + x;
                this.font.font.draw(batch, this.entries[i], tx, y + 10.0f);
                y += 14.5f;
            }
        }
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.hovering = -1;
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        this.getStage().getViewport().unproject(this.tempv);
        this.over = this.selecting = this.inside(this.tempv);
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        this.getStage().getViewport().unproject(this.tempv);
        this.over = this.inside(this.tempv);
        if (this.selecting != -1 && this.selecting == this.over) {
            this.isel.menuSelection(this.entries[this.selecting], this.selecting);
        }
        if (Gdx.app.getType() == Application.ApplicationType.Desktop || Gdx.app.getType() == Application.ApplicationType.Desktop) {
            this.hovering = this.over;
        }
        this.selecting = -1;
        this.over = -1;
        return false;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        this.getStage().getCamera().unproject(this.tempv);
        this.over = this.inside(this.tempv);
        return false;
    }

    private int inside(Vector3 loc) {
        int sel = -1;
        for (int i = 0; i < this.entry_rects.length; ++i) {
            if (!this.entry_rects[i].contains(this.tempv.x, this.tempv.y)) continue;
            sel = i;
            break;
        }
        return sel;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        if (this.selecting >= 0) {
            this.hovering = -1;
            return false;
        }
        this.tempv.x = screenX;
        this.tempv.y = screenY;
        this.tempv.z = 0.0f;
        this.getStage().getViewport().unproject(this.tempv);
        this.hovering = this.inside(this.tempv);
        return false;
    }

    public void enable() {
        this.enabled = true;
        this.selecting = -1;
        this.hovering = -1;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean toggleEnabled() {
        if (this.enabled) {
            this.disable();
            return false;
        }
        this.enable();
        return true;
    }
}

