/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Actor;
import java.nio.ByteBuffer;

public class PixelActor
extends Actor {
    Pixmap pixels;
    Sprite s;

    public PixelActor(int width, int height, Pixmap.Format format) {
        this.pixels = new Pixmap(width, height, format);
        Texture t = new Texture(this.pixels);
        t.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        this.s = new Sprite(t);
    }

    public PixelActor(int width, int height) {
        this(width, height, Pixmap.Format.RGBA8888);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.s.setPosition(this.getX(), this.getY());
        this.s.draw(batch);
    }

    public Pixmap getPixmap() {
        return this.pixels;
    }

    public void setPixmap(Pixmap pixmap) {
        this.s.getTexture().draw(pixmap, 0, 0);
    }

    public void setFromBuffer(byte[] buffer) {
        Pixmap pix = this.getPixmap();
        ByteBuffer pbuffer = pix.getPixels();
        for (int i = 0; i < buffer.length; ++i) {
            pbuffer.put(i, buffer[i]);
        }
        this.setPixmap(pix);
    }

    public void setFilter(Texture.TextureFilter filter) {
        this.s.getTexture().setFilter(filter, filter);
    }

    public void dispose() {
        this.s.getTexture().dispose();
        this.pixels.dispose();
    }

    @Override
    public void setScale(float xy) {
        this.s.setScale(xy);
    }
}

