/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import java.util.HashMap;

public class RectangleActor
extends Actor {
    public boolean enabled;
    public boolean hidden;
    public HashMap<Long, Rectangle> rectangles;
    public HashMap<Long, Color> colors;
    long id_top;
    private ShapeRenderer shape;

    public RectangleActor(ShapeRenderer shape) {
        this.shape = shape;
        this.enabled = true;
        this.hidden = false;
        this.rectangles = new HashMap();
        this.colors = new HashMap();
        this.id_top = 0L;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.enabled && !this.hidden) {
            batch.end();
            this.shape.setProjectionMatrix(batch.getProjectionMatrix());
            this.shape.begin(ShapeRenderer.ShapeType.Filled);
            for (long l : this.rectangles.keySet()) {
                Rectangle r = this.rectangles.get(l);
                this.shape.setColor(this.colors.get(l));
                this.shape.rect(r.x, r.y, r.width, r.height);
            }
            this.shape.end();
            batch.begin();
        }
    }

    public long addRectangle(Rectangle rect, Color c) {
        long id = this.id_top++;
        this.rectangles.put(id, rect);
        this.colors.put(id, c);
        return id;
    }

    public long addRectangle(Rectangle rect, float r, float g, float b, float a) {
        return this.addRectangle(rect, new Color(r, g, b, a));
    }

    public long addRectangle(float x, float y, float width, float height, float r, float g, float b, float a) {
        return this.addRectangle(new Rectangle(x, y, width, height), r, g, b, a);
    }

    public void removeRectangle(long id) {
        this.rectangles.remove(id);
        this.colors.remove(id);
    }

    public void clearRectangles() {
        this.rectangles.clear();
        this.colors.clear();
    }
}

