/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Actor;
import java.util.ArrayList;

public class SimpleSpriteActor
extends Actor {
    private ArrayList<Sprite> sprites = new ArrayList();
    public boolean enabled = true;
    public boolean hidden = false;

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.enabled && !this.hidden) {
            int size = this.sprites.size();
            for (int i = 0; i < size; ++i) {
                this.sprites.get(i).draw(batch);
            }
        }
    }

    public void addSprite(Sprite s) {
        this.sprites.add(s);
    }

    public void clearSprites() {
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).getTexture().dispose();
        }
        this.sprites.clear();
    }

    public void clearAllButN(int n) {
        int i;
        ArrayList<Integer> removal = new ArrayList<Integer>();
        int size = this.sprites.size() - n;
        for (i = 0; i < size; ++i) {
            this.sprites.get(i).getTexture().dispose();
            removal.add(i);
        }
        for (i = 0; i < removal.size(); ++i) {
            this.sprites.remove((Integer)removal.get(i) - i);
        }
    }

    public void translateSprites(float x, float y) {
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setX(this.getX() + x);
            this.sprites.get(i).setY(this.getY() + y);
        }
    }

    public void moveAllSpritesTo(float x, float y) {
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setX(x);
            this.sprites.get(i).setY(y);
        }
    }
}

