/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.youkaicountry.vnand.actors.IFadeEvent;
import com.youkaicountry.vnand.gameengines.vnovels.VNSave;
import com.youkaicountry.vnand.gameengines.vnovels.VNSprite;
import com.youkaicountry.vnand.gameengines.vnovels.effect.IEffectEvent;
import com.youkaicountry.vnand.gameengines.vnovels.effect.VNEffect;
import com.youkaicountry.vnand.gameengines.vnovels.effect.effects.CrossFadeEffect;
import com.youkaicountry.vnand.gameengines.vnovels.effect.effects.FadeEffect;
import com.youkaicountry.vnand.screens.VNScreen;
import com.youkaicountry.vnand.utils.assethandling.assets.ImageAsset;
import java.util.ArrayList;
import java.util.LinkedList;

public class SlottedAssetActor
extends Actor
implements IEffectEvent {
    private LinkedList<FadeEffect> fade;
    private LinkedList<CrossFadeEffect> crossfade;
    private LinkedList<ImageAsset> slots;
    boolean replace;
    boolean filter_name;
    boolean filter_position;
    float delta;
    boolean enabled;
    boolean hidden;
    VNScreen vnscreen;
    IFadeEvent eventhandler;
    boolean is_fading;
    private ArrayList<ImageAsset> sprite_queue;

    public SlottedAssetActor(VNScreen vnscreen, IFadeEvent eventhandler) {
        this.vnscreen = vnscreen;
        this.sprite_queue = new ArrayList();
        this.enabled = true;
        this.hidden = false;
        this.fade = new LinkedList();
        this.crossfade = new LinkedList();
        this.slots = new LinkedList();
        this.eventhandler = eventhandler;
        this.is_fading = false;
    }

    public void update(float dt) {
        if (this.enabled && this.is_fading) {
            int i;
            for (i = 0; i < this.fade.size(); ++i) {
                this.fade.get(i).update(dt);
            }
            for (i = 0; i < this.crossfade.size(); ++i) {
                this.crossfade.get(i).update(dt);
            }
        }
    }

    public void queueSprite(ImageAsset asset) {
        this.sprite_queue.add(asset);
    }

    public void transitionQueuedSprites(float time, boolean destructive) {
        int i;
        if (destructive) {
            for (i = 0; i < this.slots.size(); ++i) {
                ImageAsset slotia = this.slots.get(i);
                boolean isin = false;
                for (int j = 0; j < this.sprite_queue.size(); ++j) {
                    ImageAsset queueia = this.sprite_queue.get(j);
                    if (!queueia.name.equals(slotia.name) || queueia.x_pos != slotia.x_pos || queueia.y_pos != slotia.y_pos) continue;
                    isin = true;
                    break;
                }
                if (isin) continue;
                this.fade.add(new FadeEffect((VNSprite)slotia.getAsset(), this, 1.0f, 0.0f, time, "out"));
            }
        }
        for (i = 0; i < this.sprite_queue.size(); ++i) {
            ImageAsset s = this.sprite_queue.get(i);
            System.out.println(s.name);
            this.fadeInImageAsset(s, time);
        }
        this.calcIsFading();
        this.sprite_queue.clear();
        if (this.isFading()) {
            this.eventhandler.fadeChainStarted();
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.enabled && !this.hidden) {
            for (int i = 0; i < this.crossfade.size(); ++i) {
                ((VNSprite)this.crossfade.get(i).getFromAsset().getAsset()).draw(batch);
                ((VNSprite)this.crossfade.get(i).getFromAsset().getAsset()).draw(batch);
                ((VNSprite)this.crossfade.get(i).getFromAsset().getAsset()).draw(batch);
                ((VNSprite)this.crossfade.get(i).getToAsset().getAsset()).draw(batch);
                ((VNSprite)this.crossfade.get(i).getToAsset().getAsset()).draw(batch);
            }
            int size = this.slots.size();
            for (int i = 0; i < size; ++i) {
                ((VNSprite)this.slots.get(i).getAsset()).draw(batch);
            }
        }
    }

    private void calcIsFading() {
        this.is_fading = this.crossfade.size() != 0 | this.fade.size() != 0;
    }

    public boolean isFading() {
        return this.is_fading;
    }

    public void fadeInImageAsset(ImageAsset asset, float time) {
        ImageAsset xfade = this.addImageAsset(asset);
        if (xfade != null) {
            this.crossfade.add(new CrossFadeEffect(xfade, asset, this, 0.0f, 1.0f, time, ""));
        } else {
            this.fade.add(new FadeEffect((VNSprite)asset.getAsset(), this, 0.0f, 1.0f, time, ""));
        }
        this.calcIsFading();
    }

    public ImageAsset addImageAsset(ImageAsset asset) {
        if (this.replace) {
            int repnum = -1;
            if (this.filter_name || this.filter_position) {
                for (int i = 0; i < this.slots.size(); ++i) {
                    ImageAsset target = this.slots.get(i);
                    if (this.filter_name && !target.name.equals(asset.name) || this.filter_position && (((VNSprite)asset.getAsset()).getX() != ((VNSprite)target.getAsset()).getX() || ((VNSprite)asset.getAsset()).getY() != ((VNSprite)target.getAsset()).getY())) continue;
                    repnum = i;
                }
            } else {
                repnum = this.slots.size() - 1;
            }
            if (repnum >= 0) {
                ImageAsset removed = this.slots.remove(repnum);
                this.slots.add(repnum, asset);
                return removed;
            }
        }
        this.slots.add(asset);
        return null;
    }

    public void setReplacementPolicy(boolean replace, boolean filter_name, boolean filter_position, float delta) {
        this.replace = replace;
        this.filter_name = filter_name;
        this.filter_position = filter_position;
        this.delta = delta;
    }

    public void clearSprites() {
        int size = this.slots.size();
        for (int i = 0; i < size; ++i) {
            this.slots.get(i).unloadAsset();
        }
        this.slots.clear();
    }

    public void clearAllButN(int n) {
        int i;
        ArrayList<Integer> removal = new ArrayList<Integer>();
        int size = this.slots.size() - n;
        for (i = 0; i < size; ++i) {
            this.slots.get(i).unloadAsset();
            removal.add(i);
        }
        for (i = 0; i < removal.size(); ++i) {
            this.slots.remove((Integer)removal.get(i) - i);
        }
    }

    public int size() {
        return this.slots.size();
    }

    public void deflateAssets() {
        for (int i = 0; i < this.slots.size(); ++i) {
            this.slots.get(i).unloadAsset();
        }
    }

    public void inflateAssets() {
        for (int i = 0; i < this.slots.size(); ++i) {
            this.slots.get(i).loadAsset();
            this.slots.get(i).refreshPosition();
        }
    }

    public void fillSave(VNSave save) {
        ArrayList<String> locs = new ArrayList<String>();
        ArrayList<Float> xa = new ArrayList<Float>();
        ArrayList<Float> ya = new ArrayList<Float>();
        for (int i = 0; i < this.slots.size(); ++i) {
            ImageAsset asset = this.slots.get(i);
            locs.add(asset.name);
            xa.add(Float.valueOf(asset.x_pos));
            ya.add(Float.valueOf(asset.y_pos));
        }
        save.sprites = locs;
        save.sprite_x = xa;
        save.sprite_y = ya;
    }

    @Override
    public void effectFinished(VNEffect effect) {
        if (effect.data.equals("out")) {
            for (int i = 0; i < this.slots.size(); ++i) {
                FadeEffect f = (FadeEffect)effect;
                if (f.sprite != this.slots.get(i).getAsset()) continue;
                this.slots.remove(i);
                break;
            }
        }
        if (this.crossfade.contains(effect)) {
            this.crossfade.remove(effect);
        } else if (this.fade.contains(effect)) {
            this.fade.remove(effect);
        }
        this.calcIsFading();
        if (!this.is_fading) {
            this.eventhandler.fadeChainComplete();
        }
    }
}

