/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.actors.IButtonAction;
import com.youkaicountry.vnand.gameengines.vnovels.ScreenMode;
import com.youkaicountry.vnand.screens.VNScreen;

public abstract class VNButton {
    protected float base_x;
    protected float base_y;
    protected Rectangle bounds;
    public ButtonState current_state;
    private IButtonAction action;
    protected ButtonPositionMode position_mode;

    public VNButton(Rectangle bounds, ButtonPositionMode position_mode, IButtonAction action) {
        this.setBounds(bounds);
        this.current_state = ButtonState.BUTTON_NORMAL;
        this.position_mode = position_mode;
        this.action = action;
    }

    public VNButton(ButtonPositionMode position_mode, IButtonAction action) {
        this.position_mode = position_mode;
        this.action = action;
    }

    public VNButton() {
    }

    public void executeAction() {
        this.action.buttonAction();
    }

    public void setBounds(Rectangle bounds) {
        this.base_x = bounds.x;
        this.base_y = bounds.y;
        this.bounds = bounds;
        this.reposition();
    }

    public void setPosition(float x, float y) {
        this.base_x = x;
        this.base_y = y;
        this.reposition();
    }

    public void setX(float x) {
        this.setPosition(x, this.base_y);
    }

    public void setY(float y) {
        this.setPosition(this.base_x, y);
    }

    private void resetPosition() {
        this.bounds.x = this.base_x;
        this.bounds.y = this.base_y;
    }

    public boolean isIn(float x, float y) {
        return this.bounds.contains(x, y);
    }

    public abstract void draw(Batch var1);

    public abstract void dispose();

    public void reposition() {
        this.resetPosition();
        ScreenMode sm = ((VNScreen)VNAnd.current_screen).screen_modes.getCurrentScreenMode();
        if (sm.mode == ScreenMode.Mode.DUAL_BOTTOM) {
            this.bounds.y -= VNAnd.settings.getSetting("height");
        } else if (sm.mode == ScreenMode.Mode.DUAL_RIGHT) {
            this.bounds.x += VNAnd.settings.getSetting("width");
        } else if (sm.mode == ScreenMode.Mode.SINGLE) {
            // empty if block
        }
    }

    public void centerX() {
        float midx = VNAnd.settings.getSetting("width") / 2.0f;
        float boundmid = this.bounds.width / 2.0f;
        float newx = midx - boundmid;
        this.setX(newx);
    }

    public static enum ButtonPositionMode {
        POSITION_TEXT,
        POSITION_IMAGE;

    }

    public static enum ButtonState {
        BUTTON_NORMAL,
        BUTTON_HOVERING,
        BUTTON_PRESSING;

    }
}

