/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ActorGestureListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.youkaicountry.vnand.VNAnd;
import com.youkaicountry.vnand.actors.VNGameAlphabetize;
import com.youkaicountry.vnand.screens.GameMenuScreen;
import com.youkaicountry.vnand.utils.text.VNFont;

public abstract class VNEntry
extends Actor {
    public static final VNGameAlphabetize ALPHABETIZE = new VNGameAlphabetize();
    public String name;
    private String disp_name;
    protected Sprite thumbnail;
    protected String format_name;
    public int type_weight = 1;
    GlyphLayout layout;
    private VNFont font;
    public boolean highlighted = false;
    GameMenuScreen screen;

    protected void init(String name, GameMenuScreen screen, VNFont font, String format_name, int weight) {
        this.cacheThumbnail();
        this.font = font;
        this.screen = screen;
        this.name = name;
        this.format_name = format_name;
        this.type_weight = weight;
        this.layout = new GlyphLayout();
        this.disp_name = name;
        this.setSize(318.0f, 85.0f);
        this.createClickListener();
    }

    private void createClickListener() {
        this.addListener(new ActorGestureListener(){

            @Override
            public void touchDown(InputEvent event, float x, float y, int pointer, int button) {
                System.out.println("DOWN: " + pointer + " " + button + " " + VNEntry.this.name);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                System.out.println("UP: " + pointer + " " + button + " " + VNEntry.this.name);
                if (VNEntry.this.highlighted) {
                    System.out.println("ACTIVATE: " + VNEntry.this.name);
                    VNEntry.this.callMakeGame();
                }
            }
        });
        this.addListener(new ClickListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                VNEntry.this.highlighted = true;
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                VNEntry.this.highlighted = false;
            }
        });
    }

    private void callMakeGame() {
        this.screen.makeGame(this);
    }

    public abstract void activate(VNAnd var1, SpriteBatch var2);

    public abstract void cacheThumbnail();

    protected abstract Sprite getThumbnail();

    public void loadThumbnail() {
        this.thumbnail = this.getThumbnail();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.thumbnail != null) {
            if (this.highlighted) {
                this.thumbnail.setColor(1.0f, 0.0f, 0.0f, 1.0f);
            } else {
                this.thumbnail.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            this.thumbnail.setPosition(this.getX(), this.getY());
            this.thumbnail.draw(batch);
        }
        this.font.font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        float gy = this.getY() + 72.0f;
        this.layout.setText(this.font.font, this.disp_name, 0, this.disp_name.length(), Color.WHITE, 215.0f, 8, true, null);
        this.font.font.draw(batch, this.layout, this.getX() + 105.0f, gy);
        this.font.font.setColor(0.7f, 0.7f, 1.0f, 1.0f);
        this.font.font.draw(batch, this.format_name, this.getX() + 105.0f, gy - this.layout.height - 5.0f);
    }
}

