/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.youkaicountry.vnand.utils.assethandling.assets.FontAsset;
import com.youkaicountry.vnand.utils.text.ITextRenderEvent;
import com.youkaicountry.vnand.utils.text.VNFont;

public class VNText {
    private ITextRenderEvent callback;
    private char[] target_text;
    private StringBuilder current_sb;
    public String text;
    public boolean animating;
    private float char_per_sec;
    private float time_elapsed;
    private float total_time;
    private int chars_in;
    public int lines;
    public FontAsset font;
    public int height;

    public VNText(String text, FontAsset font, ITextRenderEvent ev, float char_per_sec) {
        this.current_sb = new StringBuilder();
        this.callback = ev;
        this.animating = true;
        this.text = "";
        this.char_per_sec = char_per_sec;
        this.time_elapsed = 0.0f;
        this.target_text = text.toCharArray();
        this.total_time = (float)this.target_text.length / this.char_per_sec;
        this.chars_in = 0;
        this.setFont(font);
    }

    public VNText(String text, FontAsset font) {
        this.target_text = text.toCharArray();
        this.current_sb = new StringBuilder(text);
        this.animating = false;
        this.updateText();
        this.setFont(font);
    }

    private void updateText() {
        this.text = this.current_sb.toString();
    }

    public void update(float dt) {
        if (!this.animating) {
            return;
        }
        this.time_elapsed += dt;
        int cnum = (int)Math.min(Math.floor(this.time_elapsed / this.total_time * (float)this.target_text.length), (double)this.target_text.length);
        int delta = cnum - this.chars_in;
        for (int i = this.chars_in; i < this.chars_in + delta; ++i) {
            this.current_sb.append(this.target_text[i]);
        }
        this.updateText();
        this.chars_in += delta;
        if (this.chars_in >= this.target_text.length) {
            this.animating = false;
            this.callback.finishedRender(this);
        }
    }

    public void draw(Batch batch, float x, float y) {
        float uy = y - (float)this.font.size;
        ((VNFont)this.font.getAsset()).font.draw(batch, this.text, x, uy);
    }

    public void flush() {
        if (this.time_elapsed < this.total_time) {
            this.time_elapsed = this.total_time;
        }
    }

    public void setFont(FontAsset font) {
        this.font = font;
        this.height = ((VNFont)this.font.getAsset()).size;
    }
}

