/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors.inputmap;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.TimeUtils;
import com.youkaicountry.vnand.actors.inputmap.ControllerNotFoundException;
import com.youkaicountry.vnand.actors.inputmap.FieldMapping;
import com.youkaicountry.vnand.actors.inputmap.IMapEvent;
import com.youkaicountry.vnand.actors.inputmap.InputField;
import java.util.ArrayList;
import java.util.HashMap;

public class ButtonSetupActor
extends Actor
implements ControllerListener,
InputProcessor {
    final BitmapFont font;
    public String text = "";
    public final ArrayList<InputField> fields = new ArrayList();
    public final ArrayList<Controller> controllers;
    public final HashMap<String, Integer> controllername2id;
    public final HashMap<String, Integer> fieldname2id = new HashMap();
    public boolean record_mode;
    int record_i;
    long last_event_time;
    static long MIN_TIME_BETWEEN_EVENTS = 100L;
    final IMapEvent event;
    int last_axis = -1;
    boolean last_pos;

    public ButtonSetupActor(IMapEvent event) {
        this.controllers = new ArrayList();
        this.controllername2id = new HashMap();
        for (Controller controller : Controllers.getControllers()) {
            this.controllers.add(controller);
            this.controllername2id.put(controller.getName(), this.controllers.size() - 1);
            controller.addListener(this);
        }
        this.font = new BitmapFont();
        this.font.getData().setScale(4.0f);
        this.event = event;
    }

    public int getControllerID(Controller controller) {
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (!controller.equals(this.controllers.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int getControllerID(String name) {
        if (!this.controllername2id.containsKey(name)) {
            return -1;
        }
        return this.controllername2id.get(name);
    }

    public int addField(String name) {
        int id = this.fields.size();
        this.fields.add(new InputField(id, name));
        this.fieldname2id.put(name, id);
        return id;
    }

    public void remapFields() {
        this.removeMappings();
        this.record_i = 0;
        this.record_mode = true;
        this.last_event_time = TimeUtils.millis();
    }

    private void addNextRemapping(FieldMapping mapping) {
        if (TimeUtils.millis() - this.last_event_time < MIN_TIME_BETWEEN_EVENTS) {
            return;
        }
        if (this.record_i >= this.fields.size()) {
            this.endRemapping();
            return;
        }
        if (mapping == null) {
            return;
        }
        this.fields.get(this.record_i).addMapping(mapping);
        ++this.record_i;
        this.last_event_time = TimeUtils.millis();
    }

    private void endRemapping() {
        this.record_mode = false;
        this.event.remapFinished();
    }

    public void removeMappings() {
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fields.get(i).removeAllMappings();
        }
    }

    public FieldMapping addMapping(int id) {
        FieldMapping mapping = new FieldMapping(this);
        this.fields.get(id).addMapping(mapping);
        return mapping;
    }

    public boolean isFieldPressed(int id) {
        return this.fields.get(id).isPressed();
    }

    @Override
    public void act(float delta) {
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.record_mode) {
            if (this.record_i < this.fields.size()) {
                this.font.draw(batch, "Press a button to map it to:", 10.0f, 220.0f);
                this.font.draw(batch, this.fields.get((int)this.record_i).name, 80.0f, 120.0f);
            } else {
                this.font.draw(batch, "Done! Press any key to continue...", 10.0f, 50.0f);
            }
        }
    }

    @Override
    public void connected(Controller controller) {
    }

    @Override
    public void disconnected(Controller controller) {
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        this.event.anyButtonPressed();
        if (!this.record_mode) {
            return false;
        }
        FieldMapping fm = new FieldMapping(this);
        fm.setAsJButton(this.getControllerID(controller), buttonCode);
        this.addNextRemapping(fm);
        return false;
    }

    @Override
    public boolean buttonUp(Controller controller, int buttonCode) {
        this.event.anyButtonPressed();
        return false;
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float value) {
        this.event.anyButtonPressed();
        if (!this.record_mode) {
            return false;
        }
        if (Math.abs(value) < 0.2f) {
            this.last_axis = -1;
            return false;
        }
        if (this.last_axis == axisCode && value > 0.0f && this.last_pos) {
            return false;
        }
        FieldMapping fm = new FieldMapping(this);
        fm.setAsJAxis(this.getControllerID(controller), axisCode, value > 0.0f, 0.2f);
        this.addNextRemapping(fm);
        this.last_axis = axisCode;
        this.last_pos = value > 0.0f;
        System.out.println(axisCode + " " + value);
        return false;
    }

    @Override
    public boolean povMoved(Controller controller, int povCode, PovDirection value) {
        this.event.anyButtonPressed();
        if (!this.record_mode) {
            return false;
        }
        FieldMapping fm = new FieldMapping(this);
        fm.setAsJPov(this.getControllerID(controller), povCode, value, true);
        return false;
    }

    @Override
    public boolean xSliderMoved(Controller controller, int sliderCode, boolean value) {
        this.event.anyButtonPressed();
        return false;
    }

    @Override
    public boolean ySliderMoved(Controller controller, int sliderCode, boolean value) {
        this.event.anyButtonPressed();
        return false;
    }

    @Override
    public boolean accelerometerMoved(Controller controller, int accelerometerCode, Vector3 value) {
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        this.event.anyButtonPressed();
        if (!this.record_mode) {
            return false;
        }
        if (keycode == 131) {
            this.endRemapping();
            return false;
        }
        if (keycode == 4) {
            this.endRemapping();
            return false;
        }
        this.addNextRemapping(null);
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        this.event.anyButtonPressed();
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.event.anyButtonPressed();
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.event.anyButtonPressed();
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fields.size(); ++i) {
            sb.append(this.fields.get(i).toString());
        }
        return sb.toString();
    }

    public void loadConfig(FileHandle config) {
        if (!config.exists()) {
            return;
        }
        this.removeMappings();
        String[] lines = config.readString().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String trimmed = lines[i].trim();
            if (trimmed.equals("")) continue;
            FieldMapping mapping = new FieldMapping(this);
            try {
                mapping.setFromString(trimmed);
                continue;
            }
            catch (ControllerNotFoundException e) {
                // empty catch block
            }
        }
    }

    public void saveConfig(FileHandle config) {
        config.writeString(this.toString(), false);
    }

    public static enum MappingType {
        J_AXIS,
        J_BUTTON,
        J_POV,
        K_KEY;

    }
}

