/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.actors.inputmap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.PovDirection;
import com.youkaicountry.vnand.actors.inputmap.ButtonSetupActor;
import com.youkaicountry.vnand.actors.inputmap.ControllerNotFoundException;
import com.youkaicountry.vnand.actors.inputmap.InputField;

public class FieldMapping {
    final ButtonSetupActor btn;
    public ButtonSetupActor.MappingType field_type;
    InputField field;
    boolean builtin;
    int cat_a;
    int cat_b;
    int top_a;
    float top_b;
    PovDirection direction;
    boolean b;

    public FieldMapping(ButtonSetupActor btn) {
        this.btn = btn;
    }

    public FieldMapping setAsKey(int keycode) {
        this.field_type = ButtonSetupActor.MappingType.K_KEY;
        this.top_a = keycode;
        return this;
    }

    public FieldMapping setAsJButton(int controller, int button) {
        this.field_type = ButtonSetupActor.MappingType.J_BUTTON;
        this.cat_a = controller;
        this.top_a = button;
        return this;
    }

    public FieldMapping setAsJPov(int controller, int pov, PovDirection direction, boolean diagonal) {
        this.field_type = ButtonSetupActor.MappingType.J_POV;
        this.cat_a = controller;
        this.cat_b = pov;
        this.direction = direction;
        this.b = diagonal;
        return this;
    }

    public FieldMapping setAsJAxis(int controller, int axis, boolean positive, float thresh) {
        this.field_type = ButtonSetupActor.MappingType.J_AXIS;
        this.cat_a = controller;
        this.cat_b = axis;
        this.b = positive;
        this.top_b = Math.abs(thresh);
        return this;
    }

    public FieldMapping setBuiltin(boolean builtin) {
        this.builtin = builtin;
        return this;
    }

    public boolean isPressed() {
        switch (this.field_type) {
            case K_KEY: {
                return Gdx.input.isKeyPressed(this.top_a);
            }
            case J_BUTTON: {
                return this.btn.controllers.get(this.cat_a).getButton(this.top_a);
            }
            case J_POV: {
                return this.isPovPressed();
            }
            case J_AXIS: {
                float av = this.btn.controllers.get(this.cat_a).getAxis(this.cat_b);
                if (av <= 0.0f && this.b || av >= 0.0f && !this.b) {
                    return false;
                }
                return Math.abs(av) > this.top_b;
            }
        }
        return false;
    }

    private boolean isPovPressed() {
        if (!this.b) {
            return this.btn.controllers.get(this.cat_a).getPov(this.cat_b) == this.direction;
        }
        PovDirection pd = this.btn.controllers.get(this.cat_a).getPov(this.cat_b);
        switch (this.direction) {
            case north: {
                return pd == PovDirection.north || pd == PovDirection.northEast || pd == PovDirection.northWest;
            }
            case south: {
                return pd == PovDirection.south || pd == PovDirection.southWest || pd == PovDirection.southEast;
            }
            case west: {
                return pd == PovDirection.west || pd == PovDirection.northWest || pd == PovDirection.southWest;
            }
            case east: {
                return pd == PovDirection.east || pd == PovDirection.northEast || pd == PovDirection.southEast;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.makeQuotedString(sb, this.field.name);
        switch (this.field_type) {
            case J_AXIS: {
                this.makeJAxisString(sb);
                break;
            }
            case J_BUTTON: {
                this.makeJButtonString(sb);
                break;
            }
            case J_POV: {
                this.makeJPOVString(sb);
                break;
            }
            case K_KEY: {
                this.makeKKey(sb);
            }
        }
        return sb.toString();
    }

    private void makeQuotedString(StringBuilder sb, String s) {
        sb.append("\"");
        sb.append(s);
        sb.append("\", ");
    }

    private void makeJAxisString(StringBuilder sb) {
        sb.append("J_AXIS, ");
        this.makeQuotedString(sb, this.btn.controllers.get(this.cat_a).getName());
        sb.append(this.cat_b);
        sb.append(", ");
        sb.append(this.b ? "+" : "-");
    }

    private void makeJButtonString(StringBuilder sb) {
        sb.append("J_BUTTON, ");
        this.makeQuotedString(sb, this.btn.controllers.get(this.cat_a).getName());
        sb.append(this.top_a);
    }

    private void makeJPOVString(StringBuilder sb) {
        sb.append("J_POV, ");
        this.makeQuotedString(sb, this.btn.controllers.get(this.cat_a).getName());
        sb.append(this.cat_b);
        sb.append(", ");
        switch (this.direction) {
            case north: {
                sb.append("U");
            }
            case south: {
                sb.append("D");
            }
            case east: {
                sb.append("R");
            }
            case west: {
                sb.append("L");
            }
        }
        sb.append(", ");
        sb.append(this.b ? "D" : "O");
    }

    private void makeKKey(StringBuilder sb) {
        sb.append("K_KEY, ");
        sb.append(this.top_a);
    }

    public FieldMapping setFromString(String s) throws ControllerNotFoundException {
        String[] params = s.trim().split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
        String field = this.unquote(params[0].trim());
        String type = params[1].trim();
        if (type.equals("J_AXIS")) {
            this.setFromStringJAxis(params);
        } else if (type.equals("J_BUTTON")) {
            this.setFromStringJButton(params);
        } else if (type.equals("J_POV")) {
            this.setFromStringJPOV(params);
        } else if (type.equals("K_KEY")) {
            this.setFromStringKKey(params);
        }
        int field_id = this.btn.fieldname2id.get(field);
        this.btn.fields.get(field_id).addMapping(this);
        return this;
    }

    private int getControllerID(String cn) throws ControllerNotFoundException {
        String cname = this.unquote(cn.trim());
        int c = this.btn.getControllerID(cname);
        if (c < 0) {
            throw new ControllerNotFoundException("cname");
        }
        return c;
    }

    private void setFromStringJAxis(String[] params) throws ControllerNotFoundException {
        int c = this.getControllerID(params[2]);
        int axis = Integer.parseInt(params[3].trim());
        boolean pos = params[4].trim().equals("+");
        this.setAsJAxis(c, axis, pos, 0.2f);
    }

    private void setFromStringJButton(String[] params) throws ControllerNotFoundException {
        int c = this.getControllerID(params[2]);
        int button = Integer.parseInt(params[3].trim());
        this.setAsJButton(c, button);
    }

    private void setFromStringJPOV(String[] params) throws ControllerNotFoundException {
        int c = this.getControllerID(params[2]);
        int pov = Integer.parseInt(params[3].trim());
        String ds = params[4].trim();
        PovDirection dir = null;
        if (ds.equals("U")) {
            dir = PovDirection.north;
        } else if (ds.equals("D")) {
            dir = PovDirection.south;
        } else if (ds.equals("L")) {
            dir = PovDirection.west;
        } else if (ds.equals("R")) {
            dir = PovDirection.east;
        }
        boolean diagonal = params[5].trim().equals("D");
        this.setAsJPov(c, pov, dir, diagonal);
    }

    private void setFromStringKKey(String[] params) {
        int key = Integer.parseInt(params[2].trim());
        this.setAsKey(key);
    }

    private String unquote(String s) {
        return s.replace("\"", "");
    }
}

