/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.vnand.gameengines.vnovels;

import com.badlogic.gdx.audio.Sound;
import com.youkaicountry.vnand.gameengines.vnovels.VNMusic;
import java.util.ArrayList;
import java.util.HashMap;

public class AudioManager {
    public VNMusic current_music = null;
    public boolean music_looping;
    public String music_loc = null;
    public HashMap<Integer, ArrayList<Sound>> playing_sounds = new HashMap();
    private static final int WaitLimit = 1000;
    private static final int ThrottleMs = 100;

    public void playSound(Sound sound, int channel, int loop) {
        System.out.println("CHANNEL " + channel);
        if (sound == null) {
            return;
        }
        this.checkedPlay(sound, 1.0f, loop);
        if (!this.playing_sounds.containsKey(channel)) {
            this.playing_sounds.put(channel, new ArrayList());
        }
        this.playing_sounds.get(channel).add(sound);
    }

    protected long checkedPlay(Sound sound, float volume, int loop) {
        int waitCounter = 0;
        long soundId = 0L;
        boolean ready = false;
        while (!ready && waitCounter < 1000) {
            soundId = loop < 0 ? sound.loop() : sound.play(volume);
            ready = soundId != -1L;
            ++waitCounter;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return soundId;
    }

    public void stopAllSounds() {
        for (int key : this.playing_sounds.keySet()) {
            this.stopSoundChannel(key);
        }
    }

    public void stopSoundChannel(int channel) {
        if (!this.playing_sounds.containsKey(channel)) {
            return;
        }
        System.out.println("Stop channel " + channel);
        for (Sound s : this.playing_sounds.get(channel)) {
            s.stop();
        }
        this.playing_sounds.get(channel).clear();
    }

    public void playMusic(VNMusic music, String loc, boolean looping) {
        this.stopMusic();
        if (music == null) {
            return;
        }
        music.play();
        music.setLooping(true);
        this.current_music = music;
        this.music_loc = loc;
        this.music_looping = looping;
    }

    public void stopMusic() {
        try {
            if (this.current_music != null && this.current_music.isPlaying()) {
                this.current_music.stop();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.music_loc = null;
        this.current_music = null;
    }

    public void stopAllAudio() {
        this.stopMusic();
        this.stopAllSounds();
    }
}

